/*
 * Decompiled with CFR 0.152.
 */
package io.qameta.allure;

import io.qameta.allure.ConfigurationBuilder;
import io.qameta.allure.Extension;
import io.qameta.allure.ReportGenerator;
import io.qameta.allure.allure1.Allure1Plugin;
import io.qameta.allure.allure2.Allure2Plugin;
import io.qameta.allure.category.CategoriesPlugin;
import io.qameta.allure.category.CategoriesTrendPlugin;
import io.qameta.allure.context.FreemarkerContext;
import io.qameta.allure.context.JacksonContext;
import io.qameta.allure.context.MarkdownContext;
import io.qameta.allure.context.RandomUidContext;
import io.qameta.allure.context.ReportInfoContext;
import io.qameta.allure.core.AttachmentsPlugin;
import io.qameta.allure.core.Configuration;
import io.qameta.allure.core.MarkdownDescriptionsPlugin;
import io.qameta.allure.core.Plugin;
import io.qameta.allure.core.TestsResultsPlugin;
import io.qameta.allure.duration.DurationPlugin;
import io.qameta.allure.duration.DurationTrendPlugin;
import io.qameta.allure.environment.Allure1EnvironmentPlugin;
import io.qameta.allure.executor.ExecutorPlugin;
import io.qameta.allure.history.HistoryPlugin;
import io.qameta.allure.history.HistoryTrendPlugin;
import io.qameta.allure.idea.IdeaLinksPlugin;
import io.qameta.allure.influxdb.InfluxDbExportPlugin;
import io.qameta.allure.launch.LaunchPlugin;
import io.qameta.allure.mail.MailPlugin;
import io.qameta.allure.owner.OwnerPlugin;
import io.qameta.allure.plugin.DefaultPluginLoader;
import io.qameta.allure.prometheus.PrometheusExportPlugin;
import io.qameta.allure.retry.RetryPlugin;
import io.qameta.allure.retry.RetryTrendPlugin;
import io.qameta.allure.severity.SeverityPlugin;
import io.qameta.allure.status.StatusChartPlugin;
import io.qameta.allure.suites.SuitesPlugin;
import io.qameta.allure.summary.SummaryPlugin;
import io.qameta.allure.tags.TagsPlugin;
import io.qameta.allure.timeline.TimelinePlugin;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class DummyReportGenerator {
    private static final Logger LOGGER = LoggerFactory.getLogger(DummyReportGenerator.class);
    private static final int MIN_ARGUMENTS_COUNT = 2;
    private static final List<Extension> EXTENSIONS = Arrays.asList(new Extension[]{new ReportInfoContext("dev"), new JacksonContext(), new MarkdownContext(), new FreemarkerContext(), new RandomUidContext(), new MarkdownDescriptionsPlugin(), new TagsPlugin(), new RetryPlugin(), new RetryTrendPlugin(), new SeverityPlugin(), new OwnerPlugin(), new IdeaLinksPlugin(), new HistoryPlugin(), new HistoryTrendPlugin(), new CategoriesPlugin(), new CategoriesTrendPlugin(), new DurationPlugin(), new DurationTrendPlugin(), new StatusChartPlugin(), new TimelinePlugin(), new SuitesPlugin(), new TestsResultsPlugin(), new AttachmentsPlugin(), new MailPlugin(), new InfluxDbExportPlugin(), new PrometheusExportPlugin(), new SummaryPlugin(), new ExecutorPlugin(), new LaunchPlugin(), new Allure1Plugin(), new Allure1EnvironmentPlugin(), new Allure2Plugin()});

    private DummyReportGenerator() {
        throw new IllegalStateException("Do not instance");
    }

    public static void main(String ... args) throws IOException {
        if (args.length < 2) {
            LOGGER.error("There must be at least two arguments");
            return;
        }
        int lastIndex = args.length - 1;
        Path[] files = DummyReportGenerator.getFiles(args);
        List<Plugin> plugins = DummyReportGenerator.loadPlugins();
        LOGGER.info("Found {} plugins", (Object)plugins.size());
        plugins.forEach(plugin -> LOGGER.info(plugin.getConfig().getName()));
        Configuration configuration = new ConfigurationBuilder().fromExtensions(EXTENSIONS).fromPlugins(plugins).build();
        ReportGenerator generator = new ReportGenerator(configuration);
        generator.generateSingleFile(files[lastIndex], Arrays.asList(Arrays.copyOf(files, lastIndex)));
    }

    public static Path[] getFiles(String ... paths) {
        return (Path[])Arrays.stream(paths).map(x$0 -> Paths.get(x$0, new String[0])).toArray(Path[]::new);
    }

    public static List<Plugin> loadPlugins() throws IOException {
        Optional<Path> optional = Optional.ofNullable(System.getProperty("allure.plugins.directory")).map(x$0 -> Paths.get(x$0, new String[0])).filter(x$0 -> Files.isDirectory(x$0, new LinkOption[0]));
        if (!optional.isPresent()) {
            return Collections.emptyList();
        }
        Path pluginsDirectory = optional.get();
        LOGGER.info("Found plugins directory {}", (Object)pluginsDirectory);
        DefaultPluginLoader loader = new DefaultPluginLoader();
        ClassLoader classLoader = DummyReportGenerator.class.getClassLoader();
        return Files.list(pluginsDirectory).filter(x$0 -> Files.isDirectory(x$0, new LinkOption[0])).map(pluginDir -> loader.loadPlugin(classLoader, (Path)pluginDir)).filter(Optional::isPresent).map(Optional::get).collect(Collectors.toList());
    }
}

