/*
 * Decompiled with CFR 0.152.
 */
package io.qameta.allure.hamcrest;

import io.qameta.allure.Allure;
import io.qameta.allure.AllureLifecycle;
import io.qameta.allure.model.Status;
import io.qameta.allure.model.StepResult;
import io.qameta.allure.util.ObjectUtils;
import io.qameta.allure.util.ResultsUtils;
import java.util.UUID;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.annotation.AfterReturning;
import org.aspectj.lang.annotation.AfterThrowing;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Before;
import org.aspectj.lang.annotation.Pointcut;
import org.hamcrest.Matcher;
import org.hamcrest.SelfDescribing;
import org.hamcrest.StringDescription;

@Aspect
public class AllureHamcrestAssert {
    private static InheritableThreadLocal<AllureLifecycle> lifecycle = new InheritableThreadLocal<AllureLifecycle>(){

        @Override
        protected AllureLifecycle initialValue() {
            return Allure.getLifecycle();
        }
    };

    public static AllureLifecycle getLifecycle() {
        return (AllureLifecycle)lifecycle.get();
    }

    @Pointcut(value="execution(void org.hamcrest.MatcherAssert.**(..))")
    public void initAssertThat() {
    }

    @Before(value="initAssertThat()")
    public void catchAndStartStep(JoinPoint joinPoint) {
        if (joinPoint.getArgs().length == 3) {
            String reason = (String)joinPoint.getArgs()[0];
            String actual = ObjectUtils.toString((Object)joinPoint.getArgs()[1]);
            StringDescription description = new StringDescription();
            String expecting = description.appendText("assert \"").appendText(actual).appendText("\" ").appendDescriptionOf((SelfDescribing)((Matcher)joinPoint.getArgs()[2])).toString();
            AllureHamcrestAssert.getLifecycle().startStep(UUID.randomUUID().toString(), new StepResult().setName(reason.isEmpty() ? expecting : expecting + " | " + reason).setDescription("Hamcrest assert").setStatus(Status.PASSED));
        }
    }

    @AfterThrowing(pointcut="initAssertThat()", throwing="e")
    public void stepFailed(Throwable e) {
        AllureHamcrestAssert.getLifecycle().updateStep(s -> s.setStatus(ResultsUtils.getStatus((Throwable)e).orElse(Status.BROKEN)));
        AllureHamcrestAssert.getLifecycle().stopStep();
    }

    @AfterReturning(pointcut="initAssertThat()")
    public void stepStop() {
        AllureHamcrestAssert.getLifecycle().updateStep(s -> s.setStatus(Status.PASSED));
        AllureHamcrestAssert.getLifecycle().stopStep();
    }

    public static void setLifecycle(AllureLifecycle allure) {
        lifecycle.set(allure);
    }
}

