/*
 * Decompiled with CFR 0.152.
 */
package io.qameta.allure.junit5;

import io.qameta.allure.Allure;
import io.qameta.allure.AllureLifecycle;
import io.qameta.allure.Description;
import io.qameta.allure.model.Label;
import io.qameta.allure.model.Stage;
import io.qameta.allure.model.Status;
import io.qameta.allure.model.StatusDetails;
import io.qameta.allure.model.TestResult;
import io.qameta.allure.util.ResultsUtils;
import java.math.BigInteger;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import java.util.stream.Collectors;
import org.junit.jupiter.api.DisplayName;
import org.junit.platform.engine.TestExecutionResult;
import org.junit.platform.engine.support.descriptor.MethodSource;
import org.junit.platform.launcher.TestExecutionListener;
import org.junit.platform.launcher.TestIdentifier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AllureJunit5
implements TestExecutionListener {
    private static final Logger LOGGER = LoggerFactory.getLogger(AllureJunit5.class);
    private static final String TAG = "tag";
    private static final String SUITE = "suite";
    private static final String PACKAGE = "package";
    private final ThreadLocal<String> tests = InheritableThreadLocal.withInitial(() -> UUID.randomUUID().toString());
    private final AllureLifecycle lifecycle;

    public AllureJunit5(AllureLifecycle lifecycle) {
        this.lifecycle = lifecycle;
    }

    public AllureJunit5() {
        this.lifecycle = Allure.getLifecycle();
    }

    public AllureLifecycle getLifecycle() {
        return this.lifecycle;
    }

    public void executionStarted(TestIdentifier testIdentifier) {
        if (testIdentifier.isTest()) {
            Optional<MethodSource> methodSource = testIdentifier.getSource().filter(MethodSource.class::isInstance).map(MethodSource.class::cast);
            String uuid = this.tests.get();
            TestResult result = new TestResult().withUuid(uuid).withName(testIdentifier.getDisplayName()).withLabels(this.getTags(testIdentifier)).withHistoryId(this.getHistoryId(testIdentifier)).withStage(Stage.RUNNING);
            methodSource.ifPresent(source -> {
                result.setDescription(this.getDescription((MethodSource)source));
                result.getLabels().add(new Label().withName(SUITE).withValue(this.getSuite((MethodSource)source)));
                result.getLabels().add(new Label().withName(PACKAGE).withValue(source.getClassName()));
            });
            this.getLifecycle().scheduleTestCase(result);
            this.getLifecycle().startTestCase(uuid);
        }
    }

    public void executionSkipped(TestIdentifier testIdentifier, String reason) {
        if (testIdentifier.isTest()) {
            String uuid = this.tests.get();
            TestResult result = new TestResult().withUuid(uuid).withName(testIdentifier.getDisplayName()).withLabels(this.getTags(testIdentifier)).withHistoryId(this.getHistoryId(testIdentifier)).withStage(Stage.RUNNING);
            testIdentifier.getSource().filter(MethodSource.class::isInstance).map(MethodSource.class::cast).ifPresent(source -> {
                result.setDescription(this.getDescription((MethodSource)source));
                result.getLabels().add(new Label().withName(SUITE).withValue(this.getSuite((MethodSource)source)));
                result.getLabels().add(new Label().withName(PACKAGE).withValue(source.getClassName()));
            });
            this.getLifecycle().scheduleTestCase(result);
            this.getLifecycle().startTestCase(uuid);
            this.tests.remove();
            this.getLifecycle().updateTestCase(uuid, testResult -> {
                testResult.setStage(Stage.FINISHED);
                testResult.setStatus(Status.SKIPPED);
            });
            this.getLifecycle().stopTestCase(uuid);
            this.getLifecycle().writeTestCase(uuid);
        }
    }

    public void executionFinished(TestIdentifier testIdentifier, TestExecutionResult testExecutionResult) {
        if (testIdentifier.isTest()) {
            String uuid = this.tests.get();
            this.tests.remove();
            this.getLifecycle().updateTestCase(uuid, result -> {
                result.setStage(Stage.FINISHED);
                switch (testExecutionResult.getStatus()) {
                    case FAILED: {
                        testExecutionResult.getThrowable().ifPresent(throwable -> {
                            result.setStatus(this.getStatus((Throwable)throwable));
                            result.setStatusDetails((StatusDetails)ResultsUtils.getStatusDetails((Throwable)throwable).orElse(null));
                        });
                        break;
                    }
                    case SUCCESSFUL: {
                        result.setStatus(Status.PASSED);
                        break;
                    }
                    default: {
                        result.setStatus(Status.SKIPPED);
                        testExecutionResult.getThrowable().ifPresent(throwable -> result.setStatusDetails((StatusDetails)ResultsUtils.getStatusDetails((Throwable)throwable).orElse(null)));
                    }
                }
            });
            this.getLifecycle().stopTestCase(uuid);
            this.getLifecycle().writeTestCase(uuid);
        }
    }

    protected Status getStatus(Throwable throwable) {
        return ResultsUtils.getStatus((Throwable)throwable).orElse(Status.FAILED);
    }

    private List<Label> getTags(TestIdentifier testIdentifier) {
        return testIdentifier.getTags().stream().map(tag -> new Label().withName(TAG).withValue(tag.getName())).collect(Collectors.toList());
    }

    protected String getHistoryId(TestIdentifier testIdentifier) {
        return this.md5(testIdentifier.getUniqueId());
    }

    private String md5(String source) {
        byte[] bytes = this.getMessageDigest().digest(source.getBytes(StandardCharsets.UTF_8));
        return new BigInteger(1, bytes).toString(16);
    }

    private MessageDigest getMessageDigest() {
        try {
            return MessageDigest.getInstance("md5");
        }
        catch (NoSuchAlgorithmException e) {
            throw new IllegalStateException("Could not find md5 hashing algorithm", e);
        }
    }

    private String getSuite(MethodSource source) {
        try {
            DisplayName displayNameAnnotation = Class.forName(source.getClassName()).getAnnotation(DisplayName.class);
            if (displayNameAnnotation != null && !displayNameAnnotation.value().isEmpty()) {
                return displayNameAnnotation.value();
            }
        }
        catch (ClassNotFoundException e) {
            LOGGER.trace(e.getMessage(), (Throwable)e);
        }
        return source.getClassName();
    }

    private String getDescription(MethodSource source) {
        try {
            Description descriptionAnnotation = Class.forName(source.getClassName()).getDeclaredMethod(source.getMethodName(), new Class[0]).getAnnotation(Description.class);
            if (descriptionAnnotation != null) {
                return descriptionAnnotation.value();
            }
        }
        catch (ClassNotFoundException | NoSuchMethodException e) {
            LOGGER.trace(e.getMessage(), (Throwable)e);
        }
        return null;
    }
}

