/*
 * Decompiled with CFR 0.152.
 */
package io.qameta.allure.restassured;

import io.qameta.allure.attachment.AttachmentData;
import io.qameta.allure.attachment.AttachmentRenderer;
import io.qameta.allure.attachment.DefaultAttachmentProcessor;
import io.qameta.allure.attachment.FreemarkerAttachmentRenderer;
import io.qameta.allure.attachment.http.HttpRequestAttachment;
import io.qameta.allure.attachment.http.HttpResponseAttachment;
import io.restassured.filter.FilterContext;
import io.restassured.filter.OrderedFilter;
import io.restassured.internal.NameAndValue;
import io.restassured.internal.support.Prettifier;
import io.restassured.response.Response;
import io.restassured.response.ResponseOptions;
import io.restassured.specification.FilterableRequestSpecification;
import io.restassured.specification.FilterableResponseSpecification;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

public class AllureRestAssured
implements OrderedFilter {
    private String requestTemplatePath = "http-request.ftl";
    private String responseTemplatePath = "http-response.ftl";
    private String requestAttachmentName = "Request";
    private String responseAttachmentName;

    public AllureRestAssured setRequestTemplate(String templatePath) {
        this.requestTemplatePath = templatePath;
        return this;
    }

    public AllureRestAssured setResponseTemplate(String templatePath) {
        this.responseTemplatePath = templatePath;
        return this;
    }

    public AllureRestAssured setRequestAttachmentName(String requestAttachmentName) {
        this.requestAttachmentName = requestAttachmentName;
        return this;
    }

    public AllureRestAssured setResponseAttachmentName(String responseAttachmentName) {
        this.responseAttachmentName = responseAttachmentName;
        return this;
    }

    @Deprecated
    public AllureRestAssured withRequestTemplate(String templatePath) {
        return this.setRequestTemplate(templatePath);
    }

    @Deprecated
    public AllureRestAssured withResponseTemplate(String templatePath) {
        return this.setResponseTemplate(templatePath);
    }

    public Response filter(FilterableRequestSpecification requestSpec, FilterableResponseSpecification responseSpec, FilterContext filterContext) {
        Prettifier prettifier = new Prettifier();
        String url = requestSpec.getURI();
        HttpRequestAttachment.Builder requestAttachmentBuilder = HttpRequestAttachment.Builder.create((String)this.requestAttachmentName, (String)url).setMethod(requestSpec.getMethod()).setHeaders(AllureRestAssured.toMapConverter((Iterable<? extends NameAndValue>)requestSpec.getHeaders())).setCookies(AllureRestAssured.toMapConverter((Iterable<? extends NameAndValue>)requestSpec.getCookies()));
        if (Objects.nonNull(requestSpec.getBody())) {
            requestAttachmentBuilder.setBody(prettifier.getPrettifiedBodyIfPossible(requestSpec));
        }
        HttpRequestAttachment requestAttachment = requestAttachmentBuilder.build();
        new DefaultAttachmentProcessor().addAttachment((AttachmentData)requestAttachment, (AttachmentRenderer)new FreemarkerAttachmentRenderer(this.requestTemplatePath));
        Response response = filterContext.next(requestSpec, responseSpec);
        if (Objects.isNull(this.responseAttachmentName)) {
            this.responseAttachmentName = response.getStatusLine();
        }
        HttpResponseAttachment responseAttachment = HttpResponseAttachment.Builder.create((String)this.responseAttachmentName).setResponseCode(response.getStatusCode()).setHeaders(AllureRestAssured.toMapConverter((Iterable<? extends NameAndValue>)response.getHeaders())).setBody(prettifier.getPrettifiedBodyIfPossible((ResponseOptions)response, response.getBody())).build();
        new DefaultAttachmentProcessor().addAttachment((AttachmentData)responseAttachment, (AttachmentRenderer)new FreemarkerAttachmentRenderer(this.responseTemplatePath));
        return response;
    }

    private static Map<String, String> toMapConverter(Iterable<? extends NameAndValue> items) {
        HashMap<String, String> result = new HashMap<String, String>();
        items.forEach(h -> result.put(h.getName(), h.getValue()));
        return result;
    }

    public int getOrder() {
        return Integer.MAX_VALUE;
    }
}

