/*
 * Decompiled with CFR 0.152.
 */
package io.qameta.allure.selenide;

import com.codeborne.selenide.Selenide;
import com.codeborne.selenide.WebDriverRunner;
import com.codeborne.selenide.logevents.LogEvent;
import com.codeborne.selenide.logevents.LogEventListener;
import com.codeborne.selenide.logevents.SelenideLog;
import io.qameta.allure.Allure;
import io.qameta.allure.AllureLifecycle;
import io.qameta.allure.model.Status;
import io.qameta.allure.model.StatusDetails;
import io.qameta.allure.model.StepResult;
import io.qameta.allure.selenide.LogType;
import io.qameta.allure.util.ResultsUtils;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.logging.Level;
import org.openqa.selenium.OutputType;
import org.openqa.selenium.TakesScreenshot;
import org.openqa.selenium.WebDriverException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AllureSelenide
implements LogEventListener {
    private static final Logger LOGGER = LoggerFactory.getLogger(AllureSelenide.class);
    private boolean saveScreenshots = true;
    private boolean savePageHtml = true;
    private boolean includeSelenideLocatorsSteps = true;
    private final Map<LogType, Level> logTypesToSave = new HashMap<LogType, Level>();
    private final AllureLifecycle lifecycle;

    public AllureSelenide() {
        this(Allure.getLifecycle());
    }

    public AllureSelenide(AllureLifecycle lifecycle) {
        this.lifecycle = lifecycle;
    }

    public AllureSelenide screenshots(boolean saveScreenshots) {
        this.saveScreenshots = saveScreenshots;
        return this;
    }

    public AllureSelenide savePageSource(boolean savePageHtml) {
        this.savePageHtml = savePageHtml;
        return this;
    }

    public AllureSelenide includeSelenideSteps(boolean includeSelenideSteps) {
        this.includeSelenideLocatorsSteps = includeSelenideSteps;
        return this;
    }

    public AllureSelenide enableLogs(LogType logType, Level logLevel) {
        this.logTypesToSave.put(logType, logLevel);
        return this;
    }

    public AllureSelenide disableLogs(LogType logType) {
        this.logTypesToSave.remove((Object)logType);
        return this;
    }

    private static Optional<byte[]> getScreenshotBytes() {
        try {
            return WebDriverRunner.hasWebDriverStarted() ? Optional.of((byte[])((TakesScreenshot)WebDriverRunner.getWebDriver()).getScreenshotAs(OutputType.BYTES)) : Optional.empty();
        }
        catch (WebDriverException e) {
            LOGGER.warn("Could not get screen shot", (Throwable)e);
            return Optional.empty();
        }
    }

    private static Optional<byte[]> getPageSourceBytes() {
        try {
            return WebDriverRunner.hasWebDriverStarted() ? Optional.of(WebDriverRunner.getWebDriver().getPageSource().getBytes(StandardCharsets.UTF_8)) : Optional.empty();
        }
        catch (WebDriverException e) {
            LOGGER.warn("Could not get page source", (Throwable)e);
            return Optional.empty();
        }
    }

    private static String getBrowserLogs(LogType logType, Level level) {
        return String.join((CharSequence)"\n\n", Selenide.getWebDriverLogs((String)logType.toString(), (Level)level));
    }

    public void beforeEvent(LogEvent event) {
        if (this.stepsShouldBeLogged(event)) {
            this.lifecycle.getCurrentTestCaseOrStep().ifPresent(parentUuid -> {
                String uuid = UUID.randomUUID().toString();
                this.lifecycle.startStep(parentUuid, uuid, new StepResult().setName(event.toString()));
            });
        }
    }

    public void afterEvent(LogEvent event) {
        if (event.getStatus().equals((Object)LogEvent.EventStatus.FAIL)) {
            this.lifecycle.getCurrentTestCaseOrStep().ifPresent(parentUuid -> {
                if (this.saveScreenshots) {
                    AllureSelenide.getScreenshotBytes().ifPresent(bytes -> this.lifecycle.addAttachment("Screenshot", "image/png", "png", bytes));
                }
                if (this.savePageHtml) {
                    AllureSelenide.getPageSourceBytes().ifPresent(bytes -> this.lifecycle.addAttachment("Page source", "text/html", "html", bytes));
                }
                if (!this.logTypesToSave.isEmpty()) {
                    this.logTypesToSave.forEach((logType, level) -> {
                        byte[] content = AllureSelenide.getBrowserLogs(logType, level).getBytes(StandardCharsets.UTF_8);
                        this.lifecycle.addAttachment("Logs from: " + (Object)logType, "application/json", ".txt", content);
                    });
                }
            });
        }
        if (this.stepsShouldBeLogged(event)) {
            this.lifecycle.getCurrentTestCaseOrStep().ifPresent(parentUuid -> {
                switch (event.getStatus()) {
                    case PASS: {
                        this.lifecycle.updateStep(step -> step.setStatus(Status.PASSED));
                        break;
                    }
                    case FAIL: {
                        this.lifecycle.updateStep(stepResult -> {
                            stepResult.setStatus(ResultsUtils.getStatus((Throwable)event.getError()).orElse(Status.BROKEN));
                            stepResult.setStatusDetails(ResultsUtils.getStatusDetails((Throwable)event.getError()).orElse(new StatusDetails()));
                        });
                        break;
                    }
                    default: {
                        LOGGER.warn("Step finished with unsupported status {}", (Object)event.getStatus());
                    }
                }
                this.lifecycle.stopStep();
            });
        }
    }

    private boolean stepsShouldBeLogged(LogEvent event) {
        return this.includeSelenideLocatorsSteps || !(event instanceof SelenideLog);
    }
}

