/*
 * Decompiled with CFR 0.152.
 */
package io.qameta.allure.testng;

import io.qameta.allure.Allure;
import io.qameta.allure.AllureLifecycle;
import io.qameta.allure.Flaky;
import io.qameta.allure.Muted;
import io.qameta.allure.Severity;
import io.qameta.allure.SeverityLevel;
import io.qameta.allure.model.ExecutableItem;
import io.qameta.allure.model.FixtureResult;
import io.qameta.allure.model.Label;
import io.qameta.allure.model.Link;
import io.qameta.allure.model.Stage;
import io.qameta.allure.model.Status;
import io.qameta.allure.model.StatusDetails;
import io.qameta.allure.model.TestResult;
import io.qameta.allure.model.TestResultContainer;
import io.qameta.allure.testng.AllureTestNgTestFilter;
import io.qameta.allure.testng.TestInstanceParameter;
import io.qameta.allure.util.AnnotationUtils;
import io.qameta.allure.util.ObjectUtils;
import io.qameta.allure.util.ResultsUtils;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.testng.IAttributes;
import org.testng.IClass;
import org.testng.IConfigurationListener;
import org.testng.IInvokedMethod;
import org.testng.IInvokedMethodListener;
import org.testng.IMethodInstance;
import org.testng.IMethodInterceptor;
import org.testng.ISuite;
import org.testng.ISuiteListener;
import org.testng.ITestClass;
import org.testng.ITestContext;
import org.testng.ITestListener;
import org.testng.ITestNGMethod;
import org.testng.ITestResult;
import org.testng.annotations.Parameters;
import org.testng.internal.ConstructorOrMethod;
import org.testng.xml.XmlSuite;
import org.testng.xml.XmlTest;

public class AllureTestNg
implements ISuiteListener,
ITestListener,
IInvokedMethodListener,
IConfigurationListener,
IMethodInterceptor {
    private static final Logger LOGGER = LoggerFactory.getLogger(AllureTestNg.class);
    private static final String ALLURE_UUID = "ALLURE_UUID";
    private final ThreadLocal<Current> currentTestResult = ThreadLocal.withInitial(Current::new);
    private final ThreadLocal<String> currentTestContainer = ThreadLocal.withInitial(() -> UUID.randomUUID().toString());
    private final ThreadLocal<String> currentExecutable = ThreadLocal.withInitial(() -> UUID.randomUUID().toString());
    private final Map<ITestClass, String> classContainerUuidStorage = new ConcurrentHashMap<ITestClass, String>();
    private final ReadWriteLock lock = new ReentrantReadWriteLock();
    private static final List<Class<?>> INJECTED_TYPES = Arrays.asList(ITestContext.class, ITestResult.class, XmlTest.class, Method.class, Object[].class);
    private final AllureLifecycle lifecycle;
    private final AllureTestNgTestFilter testFilter;

    public AllureTestNg(AllureLifecycle lifecycle, AllureTestNgTestFilter testFilter) {
        this.lifecycle = lifecycle;
        this.testFilter = testFilter;
    }

    public AllureTestNg(AllureLifecycle lifecycle) {
        this(lifecycle, new AllureTestNgTestFilter());
    }

    public AllureTestNg() {
        this(Allure.getLifecycle());
    }

    public AllureLifecycle getLifecycle() {
        return this.lifecycle;
    }

    public List<IMethodInstance> intercept(List<IMethodInstance> methods, ITestContext context) {
        return this.testFilter.intercept(methods, context);
    }

    public void onStart(ISuite suite) {
        TestResultContainer result = new TestResultContainer().setUuid(this.getUniqueUuid((IAttributes)suite)).setName(suite.getName()).setStart(Long.valueOf(System.currentTimeMillis()));
        this.getLifecycle().startTestContainer(result);
    }

    public void onStart(ITestContext context) {
        String parentUuid = this.getUniqueUuid((IAttributes)context.getSuite());
        String uuid = this.getUniqueUuid((IAttributes)context);
        TestResultContainer container = new TestResultContainer().setUuid(uuid).setName(context.getName()).setStart(Long.valueOf(System.currentTimeMillis()));
        this.getLifecycle().startTestContainer(parentUuid, container);
        Stream.of(context.getAllTestMethods()).map(ITestNGMethod::getTestClass).distinct().forEach(this::onBeforeClass);
        context.getExcludedMethods().stream().filter(ITestNGMethod::isTest).filter(method -> !method.getEnabled()).filter(this.testFilter::isSelected).forEach(method -> this.createFakeResult(context, (ITestNGMethod)method));
    }

    protected void createFakeResult(ITestContext context, ITestNGMethod method) {
        String uuid = UUID.randomUUID().toString();
        String parentUuid = UUID.randomUUID().toString();
        this.startTestCase(context, method, (IClass)method.getTestClass(), new Object[0], parentUuid, uuid);
        this.stopTestCase(uuid, null, null);
    }

    public void onFinish(ISuite suite) {
        String uuid = this.getUniqueUuid((IAttributes)suite);
        this.getLifecycle().stopTestContainer(uuid);
        this.getLifecycle().writeTestContainer(uuid);
    }

    public void onFinish(ITestContext context) {
        String uuid = this.getUniqueUuid((IAttributes)context);
        this.getLifecycle().stopTestContainer(uuid);
        this.getLifecycle().writeTestContainer(uuid);
        Stream.of(context.getAllTestMethods()).map(ITestNGMethod::getTestClass).distinct().forEach(this::onAfterClass);
    }

    public void onBeforeClass(ITestClass testClass) {
        String uuid = UUID.randomUUID().toString();
        TestResultContainer container = new TestResultContainer().setUuid(uuid).setName(testClass.getName());
        this.getLifecycle().startTestContainer(container);
        this.setClassContainer(testClass, uuid);
    }

    public void onAfterClass(ITestClass testClass) {
        this.getClassContainer(testClass).ifPresent(uuid -> {
            this.getLifecycle().stopTestContainer(uuid);
            this.getLifecycle().writeTestContainer(uuid);
        });
    }

    public void onTestStart(ITestResult testResult) {
        Current current = this.currentTestResult.get();
        if (current.isStarted()) {
            current = this.refreshContext();
        }
        current.test();
        String uuid = current.getUuid();
        String parentUuid = this.getUniqueUuid((IAttributes)testResult.getTestContext());
        this.startTestCase(testResult, parentUuid, uuid);
        Optional.of(testResult).map(ITestResult::getMethod).map(ITestNGMethod::getTestClass).ifPresent(clazz -> this.addClassContainerChild((ITestClass)clazz, uuid));
    }

    protected void startTestCase(ITestResult testResult, String parentUuid, String uuid) {
        this.startTestCase(testResult.getTestContext(), testResult.getMethod(), testResult.getTestClass(), testResult.getParameters(), parentUuid, uuid);
    }

    protected void startTestCase(ITestContext context, ITestNGMethod method, IClass iClass, Object[] params, String parentUuid, String uuid) {
        ITestClass testClass = method.getTestClass();
        ArrayList<Label> labels = new ArrayList<Label>();
        labels.addAll(ResultsUtils.getProvidedLabels());
        labels.addAll(Arrays.asList(ResultsUtils.createPackageLabel((String)testClass.getName()), ResultsUtils.createTestClassLabel((String)testClass.getName()), ResultsUtils.createTestMethodLabel((String)method.getMethodName()), ResultsUtils.createParentSuiteLabel((String)AllureTestNg.safeExtractSuiteName(testClass)), ResultsUtils.createSuiteLabel((String)AllureTestNg.safeExtractTestTag(testClass)), ResultsUtils.createSubSuiteLabel((String)AllureTestNg.safeExtractTestClassName(testClass)), ResultsUtils.createHostLabel(), ResultsUtils.createThreadLabel(), ResultsUtils.createFrameworkLabel((String)"testng"), ResultsUtils.createLanguageLabel((String)"java")));
        labels.addAll(this.getLabels(method, iClass));
        List<io.qameta.allure.model.Parameter> parameters = this.getParameters(context, method, params);
        TestResult result = new TestResult().setUuid(uuid).setHistoryId(this.getHistoryId(method, parameters)).setName(this.getMethodName(method)).setFullName(this.getQualifiedName(method)).setStatusDetails(new StatusDetails().setFlaky(this.isFlaky(method, iClass)).setMuted(this.isMuted(method, iClass))).setParameters(parameters).setLinks(this.getLinks(method, iClass)).setLabels(labels);
        ResultsUtils.processDescription((ClassLoader)this.getClass().getClassLoader(), (Method)method.getConstructorOrMethod().getMethod(), (ExecutableItem)result);
        this.getLifecycle().scheduleTestCase(parentUuid, result);
        this.getLifecycle().startTestCase(uuid);
    }

    public void onTestSuccess(ITestResult testResult) {
        Current current = this.currentTestResult.get();
        current.after();
        this.getLifecycle().updateTestCase(current.getUuid(), this.setStatus(Status.PASSED));
        this.getLifecycle().stopTestCase(current.getUuid());
        this.getLifecycle().writeTestCase(current.getUuid());
    }

    public void onTestFailure(ITestResult result) {
        Current current = this.currentTestResult.get();
        if (current.isAfter()) {
            current = this.refreshContext();
        }
        if (!current.isStarted()) {
            this.createTestResultForTestWithoutSetup(result);
        }
        current.after();
        String uuid = current.getUuid();
        Throwable throwable = result.getThrowable();
        Status status = this.getStatus(throwable);
        this.stopTestCase(uuid, throwable, status);
    }

    protected void stopTestCase(String uuid, Throwable throwable, Status status) {
        StatusDetails details = ResultsUtils.getStatusDetails((Throwable)throwable).orElse(null);
        this.getLifecycle().updateTestCase(uuid, this.setStatus(status, details));
        this.getLifecycle().stopTestCase(uuid);
        this.getLifecycle().writeTestCase(uuid);
    }

    public void onTestSkipped(ITestResult result) {
        Current current = this.currentTestResult.get();
        if (current.isAfter()) {
            current = this.refreshContext();
        }
        if (!current.isStarted()) {
            this.createTestResultForTestWithoutSetup(result);
        }
        current.after();
        this.stopTestCase(current.getUuid(), result.getThrowable(), Status.SKIPPED);
    }

    private void createTestResultForTestWithoutSetup(ITestResult result) {
        this.onTestStart(result);
        this.currentTestResult.remove();
    }

    public void onTestFailedButWithinSuccessPercentage(ITestResult result) {
    }

    public void beforeInvocation(IInvokedMethod method, ITestResult testResult) {
        ITestNGMethod testMethod = method.getTestMethod();
        ITestContext context = testResult.getTestContext();
        if (this.isSupportedConfigurationFixture(testMethod)) {
            this.ifSuiteFixtureStarted(context.getSuite(), testMethod);
            this.ifTestFixtureStarted(context, testMethod);
            this.ifClassFixtureStarted(testMethod);
            this.ifMethodFixtureStarted(testMethod);
        }
    }

    private void ifSuiteFixtureStarted(ISuite suite, ITestNGMethod testMethod) {
        if (testMethod.isBeforeSuiteConfiguration()) {
            this.startBefore(this.getUniqueUuid((IAttributes)suite), testMethod);
        }
        if (testMethod.isAfterSuiteConfiguration()) {
            this.startAfter(this.getUniqueUuid((IAttributes)suite), testMethod);
        }
    }

    private void ifClassFixtureStarted(ITestNGMethod testMethod) {
        if (testMethod.isBeforeClassConfiguration()) {
            this.getClassContainer(testMethod.getTestClass()).ifPresent(parentUuid -> this.startBefore((String)parentUuid, testMethod));
        }
        if (testMethod.isAfterClassConfiguration()) {
            this.getClassContainer(testMethod.getTestClass()).ifPresent(parentUuid -> this.startAfter((String)parentUuid, testMethod));
        }
    }

    private void ifTestFixtureStarted(ITestContext context, ITestNGMethod testMethod) {
        if (testMethod.isBeforeTestConfiguration()) {
            this.startBefore(this.getUniqueUuid((IAttributes)context), testMethod);
        }
        if (testMethod.isAfterTestConfiguration()) {
            this.startAfter(this.getUniqueUuid((IAttributes)context), testMethod);
        }
    }

    private void startBefore(String parentUuid, ITestNGMethod method) {
        String uuid = this.currentExecutable.get();
        this.getLifecycle().startPrepareFixture(parentUuid, uuid, this.getFixtureResult(method));
    }

    private void startAfter(String parentUuid, ITestNGMethod method) {
        String uuid = this.currentExecutable.get();
        this.getLifecycle().startTearDownFixture(parentUuid, uuid, this.getFixtureResult(method));
    }

    private void ifMethodFixtureStarted(ITestNGMethod testMethod) {
        this.currentTestContainer.remove();
        Current current = this.currentTestResult.get();
        FixtureResult fixture = this.getFixtureResult(testMethod);
        String uuid = this.currentExecutable.get();
        if (testMethod.isBeforeMethodConfiguration()) {
            if (current.isStarted()) {
                this.currentTestResult.remove();
                current = this.currentTestResult.get();
            }
            this.getLifecycle().startPrepareFixture(this.createFakeContainer(testMethod, current), uuid, fixture);
        }
        if (testMethod.isAfterMethodConfiguration()) {
            this.getLifecycle().startTearDownFixture(this.createFakeContainer(testMethod, current), uuid, fixture);
        }
    }

    private String createFakeContainer(ITestNGMethod method, Current current) {
        String parentUuid = this.currentTestContainer.get();
        TestResultContainer container = new TestResultContainer().setUuid(parentUuid).setName(this.getQualifiedName(method)).setStart(Long.valueOf(System.currentTimeMillis())).setDescription(method.getDescription()).setChildren(Collections.singletonList(current.getUuid()));
        this.getLifecycle().startTestContainer(container);
        return parentUuid;
    }

    private String getQualifiedName(ITestNGMethod method) {
        return method.getRealClass().getName() + "." + method.getMethodName();
    }

    private FixtureResult getFixtureResult(ITestNGMethod method) {
        FixtureResult fixtureResult = new FixtureResult().withName(this.getMethodName(method)).withStart(Long.valueOf(System.currentTimeMillis())).withDescription(method.getDescription()).withStage(Stage.RUNNING);
        ResultsUtils.processDescription((ClassLoader)this.getClass().getClassLoader(), (Method)method.getConstructorOrMethod().getMethod(), (ExecutableItem)fixtureResult);
        return fixtureResult;
    }

    public void afterInvocation(IInvokedMethod method, ITestResult testResult) {
        ITestNGMethod testMethod = method.getTestMethod();
        if (this.isSupportedConfigurationFixture(testMethod)) {
            String executableUuid = this.currentExecutable.get();
            this.currentExecutable.remove();
            if (testResult.isSuccess()) {
                this.getLifecycle().updateFixture(executableUuid, result -> result.setStatus(Status.PASSED));
            } else {
                this.getLifecycle().updateFixture(executableUuid, result -> result.setStatus(this.getStatus(testResult.getThrowable())).setStatusDetails((StatusDetails)ResultsUtils.getStatusDetails((Throwable)testResult.getThrowable()).orElse(null)));
            }
            this.getLifecycle().stopFixture(executableUuid);
            if (testMethod.isBeforeMethodConfiguration() || testMethod.isAfterMethodConfiguration()) {
                String containerUuid = this.currentTestContainer.get();
                this.validateContainerExists(this.getQualifiedName(testMethod), containerUuid);
                this.currentTestContainer.remove();
                this.getLifecycle().stopTestContainer(containerUuid);
                this.getLifecycle().writeTestContainer(containerUuid);
            }
        }
    }

    public void onConfigurationSuccess(ITestResult itr) {
    }

    public void onConfigurationFailure(ITestResult itr) {
        String uuid = UUID.randomUUID().toString();
        String parentUuid = UUID.randomUUID().toString();
        this.startTestCase(itr, parentUuid, uuid);
        this.addChildToContainer(this.getUniqueUuid((IAttributes)itr.getTestContext()), uuid);
        this.addChildToContainer(this.getUniqueUuid((IAttributes)itr.getTestContext().getSuite()), uuid);
        this.addClassContainerChild(itr.getMethod().getTestClass(), uuid);
        this.getLifecycle().updateTestCase(uuid, tr -> tr.getLabels().add(new Label().setName("AS_ID").setValue("-1")));
        this.stopTestCase(uuid, itr.getThrowable(), this.getStatus(itr.getThrowable()));
    }

    public void onConfigurationSkip(ITestResult itr) {
    }

    protected String getHistoryId(ITestNGMethod method, List<io.qameta.allure.model.Parameter> parameters) {
        MessageDigest digest = ResultsUtils.getMd5Digest();
        String testClassName = method.getTestClass().getName();
        String methodName = method.getMethodName();
        digest.update(testClassName.getBytes(StandardCharsets.UTF_8));
        digest.update(methodName.getBytes(StandardCharsets.UTF_8));
        parameters.stream().sorted(Comparator.comparing(io.qameta.allure.model.Parameter::getName).thenComparing(io.qameta.allure.model.Parameter::getValue)).forEachOrdered(parameter -> {
            digest.update(parameter.getName().getBytes(StandardCharsets.UTF_8));
            digest.update(parameter.getValue().getBytes(StandardCharsets.UTF_8));
        });
        byte[] bytes = digest.digest();
        return ResultsUtils.bytesToHex((byte[])bytes);
    }

    protected Status getStatus(Throwable throwable) {
        return ResultsUtils.getStatus((Throwable)throwable).orElse(Status.BROKEN);
    }

    private boolean isSupportedConfigurationFixture(ITestNGMethod testMethod) {
        return testMethod.isBeforeMethodConfiguration() || testMethod.isAfterMethodConfiguration() || testMethod.isBeforeTestConfiguration() || testMethod.isAfterTestConfiguration() || testMethod.isBeforeClassConfiguration() || testMethod.isAfterClassConfiguration() || testMethod.isBeforeSuiteConfiguration() || testMethod.isAfterSuiteConfiguration();
    }

    private void validateContainerExists(String fixtureName, String containerUuid) {
        if (Objects.isNull(containerUuid)) {
            throw new IllegalStateException("Could not find container for after method fixture " + fixtureName);
        }
    }

    private List<Label> getLabels(ITestNGMethod method, IClass iClass) {
        ArrayList<Label> labels = new ArrayList<Label>();
        this.getMethod(method).map(AnnotationUtils::getLabels).ifPresent(labels::addAll);
        this.getClass(iClass).map(AnnotationUtils::getLabels).ifPresent(labels::addAll);
        this.getMethod(method).map(this::getSeverity).filter(Optional::isPresent).orElse(this.getClass(iClass).flatMap(this::getSeverity)).map(ResultsUtils::createSeverityLabel).ifPresent(labels::add);
        return labels;
    }

    private Optional<SeverityLevel> getSeverity(AnnotatedElement annotatedElement) {
        return Stream.of(annotatedElement.getAnnotationsByType(Severity.class)).map(Severity::value).findAny();
    }

    private List<Link> getLinks(ITestNGMethod method, IClass iClass) {
        ArrayList<Link> links = new ArrayList<Link>();
        this.getMethod(method).map(AnnotationUtils::getLinks).ifPresent(links::addAll);
        this.getClass(iClass).map(AnnotationUtils::getLinks).ifPresent(links::addAll);
        return links;
    }

    private boolean isFlaky(ITestNGMethod method, IClass iClass) {
        boolean flakyMethod = this.getMethod(method).map(m -> m.isAnnotationPresent(Flaky.class)).orElse(false);
        boolean flakyClass = this.getClass(iClass).map(clazz -> clazz.isAnnotationPresent(Flaky.class)).orElse(false);
        return flakyMethod || flakyClass;
    }

    private boolean isMuted(ITestNGMethod method, IClass iClass) {
        boolean mutedMethod = this.getMethod(method).map(m -> m.isAnnotationPresent(Muted.class)).orElse(false);
        boolean mutedClass = this.getClass(iClass).map(clazz -> clazz.isAnnotationPresent(Muted.class)).orElse(false);
        return mutedMethod || mutedClass;
    }

    private Optional<Method> getMethod(ITestNGMethod method) {
        return Optional.ofNullable(method).map(ITestNGMethod::getConstructorOrMethod).map(ConstructorOrMethod::getMethod);
    }

    private Optional<Class<?>> getClass(IClass iClass) {
        return Optional.ofNullable(iClass).map(IClass::getRealClass);
    }

    private String getUniqueUuid(IAttributes suite) {
        if (Objects.isNull(suite.getAttribute(ALLURE_UUID))) {
            suite.setAttribute(ALLURE_UUID, (Object)UUID.randomUUID().toString());
        }
        return Objects.toString(suite.getAttribute(ALLURE_UUID));
    }

    private static String safeExtractSuiteName(ITestClass testClass) {
        Optional<XmlTest> xmlTest = Optional.ofNullable(testClass.getXmlTest());
        return xmlTest.map(XmlTest::getSuite).map(XmlSuite::getName).orElse("Undefined suite");
    }

    private static String safeExtractTestTag(ITestClass testClass) {
        Optional<XmlTest> xmlTest = Optional.ofNullable(testClass.getXmlTest());
        return xmlTest.map(XmlTest::getName).orElse("Undefined testng tag");
    }

    private static String safeExtractTestClassName(ITestClass testClass) {
        return ResultsUtils.firstNonEmpty((String[])new String[]{testClass.getTestName(), testClass.getName()}).orElse("Undefined class name");
    }

    private List<io.qameta.allure.model.Parameter> getParameters(ITestContext context, ITestNGMethod method, Object ... parameters) {
        HashMap result = new HashMap(context.getCurrentXmlTest().getAllParameters());
        Object instance = method.getInstance();
        if (Objects.nonNull(instance)) {
            Stream.of(instance.getClass().getDeclaredFields()).filter(field -> field.isAnnotationPresent(TestInstanceParameter.class)).forEach(field -> {
                String name = Optional.ofNullable(field.getAnnotation(TestInstanceParameter.class)).map(TestInstanceParameter::value).filter(s -> !s.isEmpty()).orElseGet(field::getName);
                try {
                    field.setAccessible(true);
                    String value = ObjectUtils.toString((Object)field.get(instance));
                    result.put(name, value);
                }
                catch (IllegalAccessException e) {
                    LOGGER.debug("Could not access field value");
                }
            });
        }
        this.getMethod(method).ifPresent(m -> {
            Class<?>[] parameterTypes = m.getParameterTypes();
            if (parameterTypes.length != parameters.length) {
                return;
            }
            String[] providedNames = Optional.ofNullable(m.getAnnotation(Parameters.class)).map(Parameters::value).orElse(new String[0]);
            String[] reflectionNames = (String[])Stream.of(m.getParameters()).map(Parameter::getName).toArray(String[]::new);
            int skippedCount = 0;
            for (int i = 0; i < parameterTypes.length; ++i) {
                Class<?> parameterType = parameterTypes[i];
                if (INJECTED_TYPES.contains(parameterType)) {
                    ++skippedCount;
                    continue;
                }
                int indexFromAnnotation = i - skippedCount;
                if (indexFromAnnotation < providedNames.length) {
                    result.put(providedNames[indexFromAnnotation], ObjectUtils.toString((Object)parameters[i]));
                    continue;
                }
                if (i >= reflectionNames.length) continue;
                result.put(reflectionNames[i], ObjectUtils.toString((Object)parameters[i]));
            }
        });
        return result.entrySet().stream().map(entry -> ResultsUtils.createParameter((String)((String)entry.getKey()), entry.getValue())).collect(Collectors.toList());
    }

    private String getMethodName(ITestNGMethod method) {
        return ResultsUtils.firstNonEmpty((String[])new String[]{method.getDescription(), method.getMethodName(), this.getQualifiedName(method)}).orElse("Unknown");
    }

    private Consumer<TestResult> setStatus(Status status) {
        return result -> result.setStatus(status);
    }

    private Consumer<TestResult> setStatus(Status status, StatusDetails details) {
        return result -> {
            result.setStatus(status);
            if (Objects.nonNull(details)) {
                result.getStatusDetails().setTrace(details.getTrace());
                result.getStatusDetails().setMessage(details.getMessage());
            }
        };
    }

    private void addClassContainerChild(ITestClass clazz, String childUuid) {
        this.addChildToContainer(this.classContainerUuidStorage.get(clazz), childUuid);
    }

    private void addChildToContainer(String containerUuid, String childUuid) {
        this.lock.writeLock().lock();
        try {
            if (Objects.nonNull(containerUuid)) {
                this.getLifecycle().updateTestContainer(containerUuid, container -> container.getChildren().add(childUuid));
            }
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    private Optional<String> getClassContainer(ITestClass clazz) {
        this.lock.readLock().lock();
        try {
            Optional<String> optional = Optional.ofNullable(this.classContainerUuidStorage.get(clazz));
            return optional;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    private void setClassContainer(ITestClass clazz, String uuid) {
        this.lock.writeLock().lock();
        try {
            this.classContainerUuidStorage.put(clazz, uuid);
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    private Current refreshContext() {
        this.currentTestResult.remove();
        return this.currentTestResult.get();
    }

    private static enum CurrentStage {
        BEFORE,
        TEST,
        AFTER;

    }

    private static class Current {
        private final String uuid = UUID.randomUUID().toString();
        private CurrentStage currentStage = CurrentStage.BEFORE;

        Current() {
        }

        public void test() {
            this.currentStage = CurrentStage.TEST;
        }

        public void after() {
            this.currentStage = CurrentStage.AFTER;
        }

        public boolean isStarted() {
            return this.currentStage != CurrentStage.BEFORE;
        }

        public boolean isAfter() {
            return this.currentStage == CurrentStage.AFTER;
        }

        public String getUuid() {
            return this.uuid;
        }
    }
}

