/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.azure.storage.blob.runtime;

import com.azure.core.util.ClientOptions;
import com.azure.storage.blob.BlobServiceAsyncClient;
import com.azure.storage.blob.BlobServiceClient;
import com.azure.storage.blob.BlobServiceClientBuilder;
import io.quarkiverse.azure.storage.blob.runtime.StorageBlobConfig;
import jakarta.enterprise.inject.Produces;
import jakarta.inject.Inject;

public class StorageBlobServiceClientProducer {
    @Inject
    StorageBlobConfig storageBlobConfiguration;

    @Produces
    public BlobServiceClient blobServiceClient() {
        BlobServiceClientBuilder builder = this.getBuilder();
        return null == builder ? null : builder.buildClient();
    }

    @Produces
    public BlobServiceAsyncClient blobServiceAsyncClient() {
        BlobServiceClientBuilder builder = this.getBuilder();
        return null == builder ? null : builder.buildAsyncClient();
    }

    private BlobServiceClientBuilder getBuilder() {
        if (!this.storageBlobConfiguration.enabled()) {
            return null;
        }
        assert (this.storageBlobConfiguration.connectionString().isPresent()) : "The connection string of Azure Storage Account must be set";
        return new BlobServiceClientBuilder().clientOptions(new ClientOptions().setApplicationId("az-qk-storage-blob")).connectionString(this.storageBlobConfiguration.connectionString().get());
    }
}

