/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.fx.deployment;

import io.quarkiverse.fx.FXMLLoaderProducer;
import io.quarkiverse.fx.FxStartupLatch;
import io.quarkiverse.fx.HostServicesProducer;
import io.quarkiverse.fx.QuarkusFxApplication;
import io.quarkiverse.fx.RunOnFxThread;
import io.quarkiverse.fx.RunOnFxThreadInterceptor;
import io.quarkiverse.fx.livereload.LiveReloadRecorder;
import io.quarkiverse.fx.views.FxView;
import io.quarkiverse.fx.views.FxViewRecorder;
import io.quarkiverse.fx.views.FxViewRepository;
import io.quarkus.arc.deployment.AdditionalBeanBuildItem;
import io.quarkus.arc.deployment.BeanContainerBuildItem;
import io.quarkus.builder.item.BuildItem;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.annotations.ExecutionTime;
import io.quarkus.deployment.annotations.Overridable;
import io.quarkus.deployment.annotations.Record;
import io.quarkus.deployment.builditem.CombinedIndexBuildItem;
import io.quarkus.deployment.builditem.FeatureBuildItem;
import io.quarkus.deployment.builditem.LiveReloadBuildItem;
import io.quarkus.deployment.builditem.QuarkusApplicationClassBuildItem;
import io.quarkus.runtime.annotations.QuarkusMain;
import java.util.ArrayList;
import java.util.Collection;
import java.util.function.Consumer;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.AnnotationTarget;
import org.jboss.jandex.AnnotationValue;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.DotName;
import org.jboss.jandex.IndexView;
import org.jboss.jandex.VoidType;
import org.jboss.logging.Logger;

class QuarkusFxExtensionProcessor {
    private static final String FEATURE = "quarkus-fx";
    private static final String CONTROLLER_SUFFIX = "Controller";
    private static final Logger LOGGER = Logger.getLogger(QuarkusFxExtensionProcessor.class);

    QuarkusFxExtensionProcessor() {
    }

    @BuildStep
    FeatureBuildItem feature() {
        return new FeatureBuildItem(FEATURE);
    }

    @BuildStep
    AdditionalBeanBuildItem fxmlLoader() {
        return new AdditionalBeanBuildItem(new Class[]{FXMLLoaderProducer.class});
    }

    @BuildStep
    AdditionalBeanBuildItem hostServices() {
        return new AdditionalBeanBuildItem(new Class[]{HostServicesProducer.class});
    }

    @BuildStep
    AdditionalBeanBuildItem startupLatch() {
        return new AdditionalBeanBuildItem(new Class[]{FxStartupLatch.class});
    }

    @BuildStep
    AdditionalBeanBuildItem fxViewRepository() {
        return new AdditionalBeanBuildItem(new Class[]{FxViewRepository.class});
    }

    @BuildStep
    AdditionalBeanBuildItem runOnFxThreadInterceptor(CombinedIndexBuildItem combinedIndex) {
        Consumer<AnnotationTarget> methodChecker = target -> {
            if (!(target.asMethod().returnType() instanceof VoidType)) {
                LOGGER.warnf("Method %s annotated with %s return value will be lost, set return type to void", (Object)target.asMethod().name(), (Object)RunOnFxThread.class.getSimpleName());
            }
        };
        Collection annotations = combinedIndex.getComputingIndex().getAnnotations(RunOnFxThread.class);
        for (AnnotationInstance annotation : annotations) {
            AnnotationTarget target2 = annotation.target();
            switch (target2.kind()) {
                case METHOD: {
                    methodChecker.accept(target2);
                    break;
                }
                case CLASS: {
                    target2.asClass().methods().forEach(methodChecker);
                }
            }
        }
        return new AdditionalBeanBuildItem(new Class[]{RunOnFxThread.class, RunOnFxThreadInterceptor.class});
    }

    @BuildStep
    void quarkusFxLauncher(CombinedIndexBuildItem combinedIndex, @Overridable BuildProducer<QuarkusApplicationClassBuildItem> quarkusApplicationClass) {
        IndexView index = combinedIndex.getIndex();
        if (index.getAnnotations(DotName.createSimple((String)QuarkusMain.class.getName())).isEmpty()) {
            quarkusApplicationClass.produce((BuildItem)new QuarkusApplicationClassBuildItem(QuarkusFxApplication.class));
        } else {
            LOGGER.info((Object)"Existing @QuarkusMain annotation were found, Quarkus-FX will not generate QuarkusFxApplication.");
        }
    }

    @Record(value=ExecutionTime.RUNTIME_INIT)
    @BuildStep
    void handleLiveReload(LiveReloadBuildItem liveReloadBuildItem, LiveReloadRecorder recorder) {
        recorder.process(liveReloadBuildItem.isLiveReload());
    }

    @Record(value=ExecutionTime.RUNTIME_INIT)
    @BuildStep
    void fxViews(CombinedIndexBuildItem combinedIndex, FxViewRecorder recorder, BeanContainerBuildItem beanContainerBuildItem) {
        ArrayList<String> views = new ArrayList<String>();
        Collection annotations = combinedIndex.getComputingIndex().getAnnotations(FxView.class);
        for (AnnotationInstance annotation : annotations) {
            ClassInfo target = annotation.target().asClass();
            AnnotationValue value = annotation.value();
            if (value != null) {
                String customName = value.asString();
                views.add(customName);
                continue;
            }
            String name = target.simpleName();
            if (name.endsWith(CONTROLLER_SUFFIX)) {
                LOGGER.debugf("Found controller annotated with %s : %s", (Object)FxView.class.getName(), (Object)name);
                String baseName = name.substring(0, name.length() - CONTROLLER_SUFFIX.length());
                views.add(baseName);
                continue;
            }
            LOGGER.warnf("Type %s is annotated with %s but does not comply with naming convention (shall end with %s)", (Object)name, (Object)FxView.class.getName(), (Object)CONTROLLER_SUFFIX);
            views.add(name);
        }
        LOGGER.infof("Fx views : {}", views);
        recorder.process(views, beanContainerBuildItem.getValue());
    }
}

