/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.githubaction;

import java.util.Map;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.OptionalLong;

public interface Inputs {
    public static final String ACTION = "action";
    public static final String GITHUB_TOKEN = "github-token";

    public Map<String, String> all();

    default public Optional<String> get(String key) {
        String value = this.all().get(key);
        if (value == null || value.isEmpty()) {
            return Optional.empty();
        }
        return Optional.of(value);
    }

    default public String getRequired(String key) {
        return this.get(key).orElseThrow(() -> new IllegalStateException("Input " + key + " is required and has not been provided"));
    }

    default public Optional<Boolean> getBoolean(String key) {
        String value = this.all().get(key);
        if (value == null || value.isBlank()) {
            return Optional.empty();
        }
        return Optional.of(Boolean.parseBoolean(value));
    }

    default public boolean getRequiredBoolean(String key) {
        return this.getBoolean(key).orElseThrow(() -> new IllegalStateException("Input " + key + " is required and has not been provided"));
    }

    default public OptionalLong getLong(String key) {
        String value = this.all().get(key);
        if (value == null || value.isBlank()) {
            return OptionalLong.empty();
        }
        return OptionalLong.of(Long.valueOf(value));
    }

    default public long getRequiredLong(String key) {
        return this.getLong(key).orElseThrow(() -> new IllegalStateException("Input " + key + " is required and has not been provided"));
    }

    @Deprecated(forRemoval=true)
    default public OptionalInt getInteger(String key) {
        return this.getInt(key);
    }

    default public OptionalInt getInt(String key) {
        String value = this.all().get(key);
        if (value == null || value.isBlank()) {
            return OptionalInt.empty();
        }
        return OptionalInt.of(Integer.valueOf(value));
    }

    default public int getRequiredInt(String key) {
        return this.getInt(key).orElseThrow(() -> new IllegalStateException("Input " + key + " is required and has not been provided"));
    }

    default public String getAction() {
        String action = this.all().get(ACTION);
        if (action == null || action.isBlank()) {
            return "<<UNNAMED>>";
        }
        return action;
    }

    default public Optional<String> getGitHubToken() {
        return this.get(GITHUB_TOKEN);
    }
}

