/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.githubaction.runtime;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.quarkiverse.githubaction.Commands;
import io.quarkiverse.githubaction.CommandsInitializer;
import io.quarkiverse.githubaction.Context;
import io.quarkiverse.githubaction.ContextInitializer;
import io.quarkiverse.githubaction.Inputs;
import io.quarkiverse.githubaction.InputsInitializer;
import io.quarkiverse.githubaction.runtime.GitHubEvent;
import io.quarkiverse.githubaction.runtime.GitHubEventHandler;
import io.quarkiverse.githubaction.runtime.PayloadTypeResolver;
import io.quarkus.runtime.QuarkusApplication;
import io.quarkus.runtime.annotations.QuarkusMain;
import io.quarkus.runtime.annotations.RegisterForReflection;
import jakarta.inject.Inject;
import java.io.File;
import org.jboss.logging.Logger;

@QuarkusMain
public class ActionMain
implements QuarkusApplication {
    private static final Logger LOG = Logger.getLogger(ActionMain.class);
    @Inject
    ContextInitializer contextInitializer;
    @Inject
    InputsInitializer inputsInitializer;
    @Inject
    CommandsInitializer commandsInitializer;
    @Inject
    PayloadTypeResolver payloadTypeResolver;
    @Inject
    GitHubEventHandler gitHubEventHandler;
    @Inject
    ObjectMapper objectMapper;

    public int run(String ... args) throws Exception {
        try {
            Context context = this.contextInitializer.createContext();
            Inputs inputs = this.inputsInitializer.createInputs();
            Commands commands = this.commandsInitializer.createCommands();
            GitHubEvent gitHubEvent = new GitHubEvent(inputs.getAction(), context, this.getEventAction(context), inputs, commands, this.payloadTypeResolver.getPayloadType(context.getGitHubEventName()));
            this.gitHubEventHandler.handle(gitHubEvent);
            return 0;
        }
        catch (Exception e) {
            LOG.error((Object)"An error occured while executing the action", (Throwable)e);
            return 1;
        }
    }

    private String getEventAction(Context context) {
        GenericPayload genericPayload = null;
        if (context.getGitHubEventPath() != null) {
            try {
                genericPayload = (GenericPayload)this.objectMapper.readValue(new File(context.getGitHubEventPath()), GenericPayload.class);
            }
            catch (Exception e) {
                LOG.warnf("Error extracting the event action from the payload %s", (Object)context.getGitHubEventPath());
            }
        }
        return genericPayload != null ? genericPayload.getAction() : null;
    }

    @RegisterForReflection
    private static class GenericPayload {
        private String action;

        private GenericPayload() {
        }

        public String getAction() {
            return this.action;
        }
    }
}

