/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.githubaction.runtime;

import io.quarkiverse.githubaction.Commands;
import io.quarkiverse.githubaction.Context;
import io.quarkiverse.githubaction.Inputs;
import io.smallrye.graphql.client.dynamic.api.DynamicGraphQLClient;
import io.smallrye.graphql.client.dynamic.api.DynamicGraphQLClientBuilder;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.Path;
import org.kohsuke.github.GHEventPayload;
import org.kohsuke.github.GHRepository;
import org.kohsuke.github.GitHub;
import org.kohsuke.github.GitHubBuilder;

public class GitHubEvent {
    private static final String AUTHORIZATION_HEADER = "Authorization";
    private static final String AUTHORIZATION_HEADER_BEARER = "Bearer %s";
    private final String name;
    private final Context context;
    private final String eventAction;
    private final Inputs inputs;
    private final Commands commands;
    private final Class<? extends GHEventPayload> payloadType;
    private volatile GHEventPayload payload;
    private volatile GitHub gitHubClient;
    private volatile DynamicGraphQLClient gitHubGraphQLClient;
    private volatile GHRepository gitHubRepository;

    GitHubEvent(String name, Context context, String eventAction, Inputs inputs, Commands commands, Class<? extends GHEventPayload> payloadType) {
        this.name = name;
        this.context = context;
        this.eventAction = eventAction;
        this.inputs = inputs;
        this.commands = commands;
        this.payloadType = payloadType;
    }

    public String getName() {
        return this.name;
    }

    public String getEvent() {
        return this.context.getGitHubEventName();
    }

    public String getEventAction() {
        return this.eventAction;
    }

    public Context getContext() {
        return this.context;
    }

    public Inputs getInputs() {
        return this.inputs;
    }

    public Commands getCommands() {
        return this.commands;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public GHEventPayload getPayload() {
        GHEventPayload localPayload = this.payload;
        if (localPayload == null) {
            GitHubEvent gitHubEvent = this;
            synchronized (gitHubEvent) {
                localPayload = this.payload;
                if (localPayload == null) {
                    try (BufferedReader payloadReader = Files.newBufferedReader(Path.of(this.context.getGitHubEventPath(), new String[0]));){
                        this.payload = localPayload = this.getGitHub().parseEventPayload((Reader)payloadReader, this.payloadType);
                    }
                    catch (IOException e) {
                        throw new IllegalStateException("Unable to read or parse payload file " + this.context.getGitHubEventPath(), e);
                    }
                }
            }
        }
        return localPayload;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public GitHub getGitHub() {
        GitHub localGitHubClient = this.gitHubClient;
        if (localGitHubClient == null) {
            GitHubEvent gitHubEvent = this;
            synchronized (gitHubEvent) {
                localGitHubClient = this.gitHubClient;
                if (localGitHubClient == null) {
                    try {
                        if (this.inputs.getGitHubToken().isPresent()) {
                            localGitHubClient = new GitHubBuilder().withEndpoint(this.context.getGitHubApiUrl()).withAppInstallationToken(this.inputs.getGitHubToken().get()).build();
                            localGitHubClient.getRateLimit();
                        } else {
                            localGitHubClient = GitHub.offline();
                        }
                        this.gitHubClient = localGitHubClient;
                    }
                    catch (Exception e) {
                        throw new IllegalStateException("Unable to initialize the GitHub API client, is the token valid?", e);
                    }
                }
            }
        }
        return localGitHubClient;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DynamicGraphQLClient getDynamicGraphQLClient() {
        if (this.inputs.getGitHubToken().isEmpty()) {
            throw new IllegalStateException("No GitHub token provided, unable to initialize the GitHub GraphQL client");
        }
        DynamicGraphQLClient localGitHubGraphQLClient = this.gitHubGraphQLClient;
        if (localGitHubGraphQLClient == null) {
            GitHubEvent gitHubEvent = this;
            synchronized (gitHubEvent) {
                localGitHubGraphQLClient = this.gitHubGraphQLClient;
                if (localGitHubGraphQLClient == null) {
                    try {
                        this.gitHubGraphQLClient = localGitHubGraphQLClient = DynamicGraphQLClientBuilder.newBuilder().url(this.context.getGithubGraphQLUrl()).header(AUTHORIZATION_HEADER, String.format(AUTHORIZATION_HEADER_BEARER, this.inputs.getGitHubToken().get())).build();
                        localGitHubGraphQLClient.executeSync("query {\n  rateLimit {\n    limit\n    cost\n    remaining\n    resetAt\n  }\n}");
                    }
                    catch (Exception e) {
                        throw new IllegalStateException("Unable to initialize the GitHub GraphQL client, is the token valid?", e);
                    }
                }
            }
        }
        return localGitHubGraphQLClient;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public GHRepository getGHRepository() {
        GHRepository localGitHubRepository = this.gitHubRepository;
        if (localGitHubRepository == null) {
            GitHubEvent gitHubEvent = this;
            synchronized (gitHubEvent) {
                if (this.gitHubRepository == null) {
                    this.gitHubRepository = localGitHubRepository = GitHubEvent.createGHRepository(this.getGitHub(), this.context.getGitHubRepository());
                }
            }
        }
        return localGitHubRepository;
    }

    private static GHRepository createGHRepository(GitHub gitHub, String repositoryName) {
        if (gitHub.isOffline()) {
            throw new IllegalStateException("The GitHub REST client is offline, unable to inject the repository '%s'".formatted(repositoryName));
        }
        try {
            return gitHub.getRepository(repositoryName);
        }
        catch (IOException ex) {
            throw new IllegalStateException("Unable to access repository '%s'".formatted(repositoryName), ex);
        }
    }
}

