/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.githubaction.runtime;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.quarkiverse.githubaction.Inputs;
import java.util.Collections;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;

class InputsImpl
implements Inputs {
    private static final String INPUT_PREFIX = "INPUT_";
    private static final String JSON_INPUTS = "JSON_INPUTS";
    private final Map<String, String> inputs;

    InputsImpl(ObjectMapper objectMapper) {
        Map<String, String> tmpInputs;
        String jsonInputs = System.getenv(JSON_INPUTS);
        if (jsonInputs != null && !jsonInputs.isBlank()) {
            try {
                tmpInputs = (Map)objectMapper.readValue(jsonInputs, (TypeReference)new TypeReference<Map<String, String>>(){});
            }
            catch (JsonProcessingException e) {
                throw new IllegalStateException("Unable to parse JSON inputs to a map", e);
            }
        } else {
            tmpInputs = new HashMap();
            for (Map.Entry<String, String> envEntry : System.getenv().entrySet()) {
                if (!envEntry.getKey().startsWith(INPUT_PREFIX)) continue;
                tmpInputs.put(envEntry.getKey().substring(INPUT_PREFIX.length()).toLowerCase(Locale.ROOT), envEntry.getValue());
            }
        }
        this.inputs = Collections.unmodifiableMap(tmpInputs);
    }

    @Override
    public Map<String, String> all() {
        return this.inputs;
    }
}

