/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.githubaction.runtime.github;

import io.quarkiverse.githubaction.GitHubFileDownloader;
import io.quarkus.runtime.LaunchMode;
import jakarta.inject.Inject;
import jakarta.inject.Singleton;
import java.io.IOException;
import java.util.Optional;
import org.jboss.logging.Logger;
import org.kohsuke.github.GHContent;
import org.kohsuke.github.GHFileNotFoundException;
import org.kohsuke.github.GHRepository;
import org.kohsuke.github.GitHub;

@Singleton
public class GitHubFileDownloaderImpl
implements GitHubFileDownloader {
    private static final Logger LOG = Logger.getLogger(GitHubFileDownloaderImpl.class);
    @Inject
    LaunchMode launchMode;

    @Override
    public Optional<String> getFileContent(GitHub gitHub, String repository, String fullPath) {
        if (gitHub.isOffline()) {
            throw new IllegalStateException("A connected GitHub API client is necessary to read a config file and no token was provided. Please provide a token as input of the action.");
        }
        try {
            GHRepository ghRepository = gitHub.getRepository(repository);
            GHContent ghContent = ghRepository.getFileContent(fullPath);
            return Optional.of(ghContent.getContent());
        }
        catch (GHFileNotFoundException e) {
            if (this.launchMode.isDevOrTest()) {
                LOG.warn((Object)("Unable to read file " + fullPath + " for repository " + repository + ". Either the file does not exist or the 'Contents' permission has not been set for the application."));
            }
            return Optional.empty();
        }
        catch (IOException e) {
            throw new IllegalStateException("Error downloading file " + fullPath + " for repository " + repository, e);
        }
    }
}

