/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.jnosql.core.runtime;

import io.quarkiverse.jnosql.core.runtime.MicroProfileSettings;
import jakarta.data.exceptions.MappingException;
import jakarta.inject.Inject;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.jnosql.communication.Settings;
import org.eclipse.jnosql.mapping.core.config.MappingConfigurations;

public abstract class AbstractManagerProducer<M extends AutoCloseable, F extends Function<String, M>, C extends Function<Settings, F>>
implements Function<MappingConfigurations, M> {
    private static final Logger LOGGER = Logger.getLogger(AbstractManagerProducer.class.getName());
    private final Settings settings = new MicroProfileSettings();
    @Inject
    protected C configuration;

    @Override
    public M apply(MappingConfigurations databaseSetting) {
        Function managerFactory = (Function)this.configuration.apply((Settings)this.settings);
        Optional database = this.settings.get((Supplier)databaseSetting, String.class);
        String db = (String)database.orElseThrow(() -> new MappingException("Please, inform the database filling up the property " + databaseSetting));
        AutoCloseable manager = (AutoCloseable)managerFactory.apply(db);
        LOGGER.log(Level.FINEST, String.format("Starting a %s instance using Eclipse MicroProfile Config, database name: %s", manager.getClass().getName(), db));
        return (M)manager;
    }
}

