/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.jnosql.core.runtime;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.eclipse.jnosql.communication.Settings;
import org.eclipse.microprofile.config.Config;
import org.eclipse.microprofile.config.ConfigProvider;

public class MicroProfileSettings
implements Settings {
    private final Config config = ConfigProvider.getConfig();

    public int size() {
        return (int)StreamSupport.stream(this.config.getPropertyNames().spliterator(), false).count();
    }

    public boolean isEmpty() {
        return this.size() == 0;
    }

    public boolean containsKey(String key) {
        return this.get(key).isPresent();
    }

    public Optional<Object> get(String key) {
        Objects.requireNonNull(key, "key is required");
        return this.config.getOptionalValue(key, String.class).map(Object.class::cast);
    }

    public Optional<Object> get(Supplier<String> supplier) {
        Objects.requireNonNull(supplier, "supplier is required");
        return this.get(supplier.get());
    }

    public Optional<Object> getSupplier(Iterable<Supplier<String>> suppliers) {
        Objects.requireNonNull(suppliers, "supplier is required");
        List<String> keys = StreamSupport.stream(suppliers.spliterator(), false).map(Supplier::get).collect(Collectors.toUnmodifiableList());
        return this.get(keys);
    }

    public Optional<Object> get(Iterable<String> keys) {
        Objects.requireNonNull(keys, "keys is required");
        return StreamSupport.stream(keys.spliterator(), false).flatMap(k -> this.config.getOptionalValue(k, String.class).stream()).map(Object.class::cast).findFirst();
    }

    public List<Object> prefix(String prefix) {
        Objects.requireNonNull(prefix, "prefix is required");
        return StreamSupport.stream(this.config.getPropertyNames().spliterator(), false).filter(p -> p.startsWith(prefix)).map(p -> (String)this.config.getValue(p, String.class)).collect(Collectors.toUnmodifiableList());
    }

    public List<Object> prefix(Supplier<String> supplier) {
        Objects.requireNonNull(supplier, "supplier is required");
        return this.prefix(supplier.get());
    }

    public List<Object> prefixSupplier(Iterable<Supplier<String>> suppliers) {
        Objects.requireNonNull(suppliers, "suppliers is required");
        Iterable prefixes = StreamSupport.stream(suppliers.spliterator(), false).map(Supplier::get).collect(Collectors.toUnmodifiableList());
        return this.prefix(prefixes);
    }

    public List<Object> prefix(Iterable<String> prefixes) {
        Objects.requireNonNull(prefixes, "prefixes is required");
        List values = StreamSupport.stream(prefixes.spliterator(), false).collect(Collectors.toUnmodifiableList());
        if (values.isEmpty()) {
            return Collections.emptyList();
        }
        Predicate<String> prefixCondition = values.stream().map(prefix -> property -> property.startsWith((String)prefix)).reduce(Predicate::or).orElse(e -> false);
        return StreamSupport.stream(this.config.getPropertyNames().spliterator(), false).filter(prefixCondition).sorted().map(p -> (String)this.config.getValue(p, String.class)).collect(Collectors.toList());
    }

    public <T> Optional<T> get(String key, Class<T> type) {
        Objects.requireNonNull(key, "key is required");
        Objects.requireNonNull(type, "type is required");
        return this.config.getOptionalValue(key, type);
    }

    public <T> Optional<T> get(Supplier<String> supplier, Class<T> type) {
        Objects.requireNonNull(supplier, "supplier is required");
        Objects.requireNonNull(type, "type is required");
        return this.get(supplier.get(), type);
    }

    public <T> T getOrDefault(String key, T defaultValue) {
        Objects.requireNonNull(key, "key is required");
        Objects.requireNonNull(defaultValue, "defaultValue is required");
        Class<?> type = defaultValue.getClass();
        return (T)this.get(key, type).orElse(defaultValue);
    }

    public <T> T getOrDefault(Supplier<String> supplier, T defaultValue) {
        Objects.requireNonNull(supplier, "supplier is required");
        Objects.requireNonNull(defaultValue, "defaultValue is required");
        return this.getOrDefault(supplier.get(), defaultValue);
    }

    public Set<String> keySet() {
        return StreamSupport.stream(this.config.getPropertyNames().spliterator(), false).collect(Collectors.toUnmodifiableSet());
    }

    public Map<String, Object> toMap() {
        return this.keySet().stream().collect(Collectors.toMap(Function.identity(), k -> this.config.getValue(k, String.class)));
    }
}

