/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.langchain4j.azure.openai;

import dev.ai4j.openai4j.OpenAiClient;
import dev.ai4j.openai4j.chat.ChatCompletionChoice;
import dev.ai4j.openai4j.chat.ChatCompletionRequest;
import dev.ai4j.openai4j.chat.ChatCompletionResponse;
import dev.ai4j.openai4j.shared.Usage;
import dev.langchain4j.agent.tool.ToolSpecification;
import dev.langchain4j.data.message.AiMessage;
import dev.langchain4j.data.message.ChatMessage;
import dev.langchain4j.internal.RetryUtils;
import dev.langchain4j.internal.Utils;
import dev.langchain4j.internal.ValidationUtils;
import dev.langchain4j.model.Tokenizer;
import dev.langchain4j.model.chat.ChatLanguageModel;
import dev.langchain4j.model.chat.TokenCountEstimator;
import dev.langchain4j.model.chat.listener.ChatModelErrorContext;
import dev.langchain4j.model.chat.listener.ChatModelListener;
import dev.langchain4j.model.chat.listener.ChatModelRequest;
import dev.langchain4j.model.chat.listener.ChatModelRequestContext;
import dev.langchain4j.model.chat.listener.ChatModelResponse;
import dev.langchain4j.model.chat.listener.ChatModelResponseContext;
import dev.langchain4j.model.openai.InternalOpenAiHelper;
import dev.langchain4j.model.output.FinishReason;
import dev.langchain4j.model.output.Response;
import dev.langchain4j.model.output.TokenUsage;
import io.quarkiverse.langchain4j.openai.QuarkusOpenAiClient;
import java.net.Proxy;
import java.time.Duration;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import org.jboss.logging.Logger;

public class AzureOpenAiChatModel
implements ChatLanguageModel,
TokenCountEstimator {
    private static final Logger log = Logger.getLogger(AzureOpenAiChatModel.class);
    private final OpenAiClient client;
    private final Double temperature;
    private final Double topP;
    private final Integer maxTokens;
    private final Double presencePenalty;
    private final Double frequencyPenalty;
    private final Integer maxRetries;
    private final Tokenizer tokenizer;
    private final String responseFormat;
    private final List<ChatModelListener> listeners;

    public AzureOpenAiChatModel(String endpoint, String apiVersion, String apiKey, String adToken, Tokenizer tokenizer, Double temperature, Double topP, Integer maxTokens, Double presencePenalty, Double frequencyPenalty, Duration timeout, Integer maxRetries, Proxy proxy, String responseFormat, Boolean logRequests, Boolean logResponses, String configName, List<ChatModelListener> listeners) {
        this.listeners = listeners;
        timeout = (Duration)Utils.getOrDefault((Object)timeout, (Object)Duration.ofSeconds(60L));
        this.client = ((QuarkusOpenAiClient.Builder)OpenAiClient.builder().baseUrl(ValidationUtils.ensureNotBlank((String)endpoint, (String)"endpoint")).apiVersion(apiVersion).callTimeout(timeout).connectTimeout(timeout).readTimeout(timeout).writeTimeout(timeout).proxy(proxy).logRequests(logRequests).logResponses(logResponses)).userAgent("langchain4j-quarkus-azure-openai").azureAdToken(adToken).azureApiKey(apiKey).configName(configName).build();
        this.temperature = (Double)Utils.getOrDefault((Object)temperature, (Object)0.7);
        this.topP = topP;
        this.maxTokens = maxTokens;
        this.presencePenalty = presencePenalty;
        this.frequencyPenalty = frequencyPenalty;
        this.maxRetries = (Integer)Utils.getOrDefault((Object)maxRetries, (Object)1);
        if (this.maxRetries < 1) {
            throw new IllegalArgumentException("max-retries must be at least 1");
        }
        this.tokenizer = tokenizer;
        this.responseFormat = responseFormat;
    }

    public Response<AiMessage> generate(List<ChatMessage> messages) {
        return this.generate(messages, null, null);
    }

    public Response<AiMessage> generate(List<ChatMessage> messages, List<ToolSpecification> toolSpecifications) {
        return this.generate(messages, toolSpecifications, null);
    }

    public Response<AiMessage> generate(List<ChatMessage> messages, ToolSpecification toolSpecification) {
        return this.generate(messages, Collections.singletonList(toolSpecification), toolSpecification);
    }

    private Response<AiMessage> generate(List<ChatMessage> messages, List<ToolSpecification> toolSpecifications, ToolSpecification toolThatMustBeExecuted) {
        ChatCompletionRequest.Builder requestBuilder = ChatCompletionRequest.builder().messages(InternalOpenAiHelper.toOpenAiMessages(messages)).temperature(this.temperature).topP(this.topP).maxTokens(this.maxTokens).presencePenalty(this.presencePenalty).frequencyPenalty(this.frequencyPenalty).responseFormat(this.responseFormat);
        if (toolSpecifications != null && !toolSpecifications.isEmpty()) {
            requestBuilder.functions(InternalOpenAiHelper.toFunctions(toolSpecifications));
        }
        if (toolThatMustBeExecuted != null) {
            requestBuilder.functionCall(toolThatMustBeExecuted.name());
        }
        ChatCompletionRequest request = requestBuilder.build();
        ChatModelRequest modelListenerRequest = this.createModelListenerRequest(request, messages, toolSpecifications);
        ConcurrentHashMap attributes = new ConcurrentHashMap();
        ChatModelRequestContext requestContext = new ChatModelRequestContext(modelListenerRequest, attributes);
        this.listeners.forEach(listener -> {
            try {
                listener.onRequest(requestContext);
            }
            catch (Exception e) {
                log.warn((Object)"Exception while calling model listener", (Throwable)e);
            }
        });
        try {
            ChatCompletionResponse chatCompletionResponse = (ChatCompletionResponse)RetryUtils.withRetry(() -> (ChatCompletionResponse)this.client.chatCompletion(request).execute(), (int)this.maxRetries);
            Response response = Response.from((Object)InternalOpenAiHelper.aiMessageFrom((ChatCompletionResponse)chatCompletionResponse), (TokenUsage)InternalOpenAiHelper.tokenUsageFrom((Usage)chatCompletionResponse.usage()), (FinishReason)InternalOpenAiHelper.finishReasonFrom((String)((ChatCompletionChoice)chatCompletionResponse.choices().get(0)).finishReason()));
            ChatModelResponse modelListenerResponse = this.createModelListenerResponse(chatCompletionResponse.id(), chatCompletionResponse.model(), (Response<AiMessage>)response);
            ChatModelResponseContext responseContext = new ChatModelResponseContext(modelListenerResponse, modelListenerRequest, attributes);
            this.listeners.forEach(listener -> {
                try {
                    listener.onResponse(responseContext);
                }
                catch (Exception e) {
                    log.warn((Object)"Exception while calling model listener", (Throwable)e);
                }
            });
            return response;
        }
        catch (Exception e) {
            ChatModelErrorContext errorContext = new ChatModelErrorContext((Throwable)e, modelListenerRequest, null, attributes);
            this.listeners.forEach(listener -> {
                try {
                    listener.onError(errorContext);
                }
                catch (Exception e2) {
                    log.warn((Object)"Exception while calling model listener", (Throwable)e2);
                }
            });
            throw e;
        }
    }

    public int estimateTokenCount(List<ChatMessage> messages) {
        return this.tokenizer.estimateTokenCountInMessages(messages);
    }

    private ChatModelRequest createModelListenerRequest(ChatCompletionRequest request, List<ChatMessage> messages, List<ToolSpecification> toolSpecifications) {
        return ChatModelRequest.builder().model(request.model()).temperature(request.temperature()).topP(request.topP()).maxTokens(request.maxTokens()).messages(messages).toolSpecifications(toolSpecifications).build();
    }

    private ChatModelResponse createModelListenerResponse(String responseId, String responseModel, Response<AiMessage> response) {
        if (response == null) {
            return null;
        }
        return ChatModelResponse.builder().id(responseId).model(responseModel).tokenUsage(response.tokenUsage()).finishReason(response.finishReason()).aiMessage((AiMessage)response.content()).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private String endpoint;
        private String apiVersion;
        private String apiKey;
        private String adToken;
        private Tokenizer tokenizer;
        private Double temperature;
        private Double topP;
        private Integer maxTokens;
        private Double presencePenalty;
        private Double frequencyPenalty;
        private Duration timeout;
        private Integer maxRetries;
        private Proxy proxy;
        private String responseFormat;
        private Boolean logRequests;
        private Boolean logResponses;
        private String configName;
        private List<ChatModelListener> listeners = Collections.emptyList();

        public Builder endpoint(String endpoint) {
            this.endpoint = endpoint;
            return this;
        }

        public Builder apiVersion(String apiVersion) {
            this.apiVersion = apiVersion;
            return this;
        }

        public Builder configName(String configName) {
            this.configName = configName;
            return this;
        }

        public Builder apiKey(String apiKey) {
            this.apiKey = apiKey;
            return this;
        }

        public Builder adToken(String adToken) {
            this.adToken = adToken;
            return this;
        }

        public Builder tokenizer(Tokenizer tokenizer) {
            this.tokenizer = tokenizer;
            return this;
        }

        public Builder temperature(Double temperature) {
            this.temperature = temperature;
            return this;
        }

        public Builder topP(Double topP) {
            this.topP = topP;
            return this;
        }

        public Builder maxTokens(Integer maxTokens) {
            this.maxTokens = maxTokens;
            return this;
        }

        public Builder presencePenalty(Double presencePenalty) {
            this.presencePenalty = presencePenalty;
            return this;
        }

        public Builder frequencyPenalty(Double frequencyPenalty) {
            this.frequencyPenalty = frequencyPenalty;
            return this;
        }

        public Builder timeout(Duration timeout) {
            this.timeout = timeout;
            return this;
        }

        public Builder maxRetries(Integer maxRetries) {
            this.maxRetries = maxRetries;
            return this;
        }

        public Builder proxy(Proxy proxy) {
            this.proxy = proxy;
            return this;
        }

        public Builder responseFormat(String responseFormat) {
            this.responseFormat = responseFormat;
            return this;
        }

        public Builder logRequests(Boolean logRequests) {
            this.logRequests = logRequests;
            return this;
        }

        public Builder logResponses(Boolean logResponses) {
            this.logResponses = logResponses;
            return this;
        }

        public Builder listeners(List<ChatModelListener> listeners) {
            this.listeners = listeners;
            return this;
        }

        public AzureOpenAiChatModel build() {
            return new AzureOpenAiChatModel(this.endpoint, this.apiVersion, this.apiKey, this.adToken, this.tokenizer, this.temperature, this.topP, this.maxTokens, this.presencePenalty, this.frequencyPenalty, this.timeout, this.maxRetries, this.proxy, this.responseFormat, this.logRequests, this.logResponses, this.configName, this.listeners);
        }
    }
}

