/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.langchain4j.runtime;

import dev.langchain4j.agent.tool.ToolSpecification;
import dev.langchain4j.service.tool.ToolExecutor;
import io.quarkiverse.langchain4j.runtime.tool.QuarkusToolExecutor;
import io.quarkiverse.langchain4j.runtime.tool.QuarkusToolExecutorFactory;
import io.quarkiverse.langchain4j.runtime.tool.ToolMethodCreateInfo;
import io.quarkus.arc.Arc;
import io.quarkus.runtime.annotations.Recorder;
import java.lang.annotation.Annotation;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.jboss.logging.Logger;

@Recorder
public class ToolsRecorder {
    private static final Logger log = Logger.getLogger(ToolsRecorder.class);
    private static final Map<String, List<ToolMethodCreateInfo>> metadata = new ConcurrentHashMap<String, List<ToolMethodCreateInfo>>();

    public void setMetadata(Map<String, List<ToolMethodCreateInfo>> metadata) {
        ToolsRecorder.metadata.putAll(metadata);
    }

    public static Map<String, List<ToolMethodCreateInfo>> getMetadata() {
        return metadata;
    }

    public static void clearMetadata() {
        metadata.clear();
    }

    public static void populateToolMetadata(List<Object> objectsWithTools, List<ToolSpecification> toolSpecifications, Map<String, ToolExecutor> toolExecutors) {
        for (Object objectWithTool : objectsWithTools) {
            List<ToolMethodCreateInfo> methodCreateInfos = ToolsRecorder.fromObject(objectWithTool);
            if (methodCreateInfos == null || methodCreateInfos.isEmpty()) continue;
            QuarkusToolExecutorFactory toolExecutorFactory = (QuarkusToolExecutorFactory)Arc.container().instance(QuarkusToolExecutorFactory.class, new Annotation[0]).get();
            for (ToolMethodCreateInfo methodCreateInfo : methodCreateInfos) {
                String invokerClassName = methodCreateInfo.invokerClassName();
                ToolSpecification toolSpecification = methodCreateInfo.toolSpecification();
                toolSpecifications.add(toolSpecification);
                QuarkusToolExecutor.Context executorContext = new QuarkusToolExecutor.Context(objectWithTool, invokerClassName, methodCreateInfo.methodName(), methodCreateInfo.argumentMapperClassName());
                toolExecutors.put(toolSpecification.name(), toolExecutorFactory.create(executorContext));
            }
        }
    }

    private static List<ToolMethodCreateInfo> fromObject(Object obj) {
        String className = obj.getClass().getName();
        List<ToolMethodCreateInfo> fast = metadata.get(className);
        if (fast != null) {
            return fast;
        }
        try {
            for (Map.Entry<String, List<ToolMethodCreateInfo>> entry : metadata.entrySet()) {
                String targetClassName = entry.getKey();
                Class<?> targetClass = Class.forName(targetClassName, false, Thread.currentThread().getContextClassLoader());
                if (!targetClass.isAssignableFrom(obj.getClass())) continue;
                metadata.put(targetClassName, entry.getValue());
                return entry.getValue();
            }
            return Collections.emptyList();
        }
        catch (ClassNotFoundException e) {
            log.error((Object)e);
            return Collections.emptyList();
        }
    }
}

