/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.langchain4j.runtime.devui;

import dev.langchain4j.data.document.Metadata;
import dev.langchain4j.data.embedding.Embedding;
import dev.langchain4j.data.segment.TextSegment;
import dev.langchain4j.model.embedding.EmbeddingModel;
import dev.langchain4j.store.embedding.EmbeddingMatch;
import dev.langchain4j.store.embedding.EmbeddingStore;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import jakarta.enterprise.inject.Default;
import jakarta.enterprise.inject.spi.CDI;
import jakarta.enterprise.util.TypeLiteral;
import java.lang.annotation.Annotation;
import java.util.regex.Pattern;

public class EmbeddingStoreJsonRPCService {
    EmbeddingStore<TextSegment> embeddingStore;
    EmbeddingModel embeddingModel = (EmbeddingModel)CDI.current().select(EmbeddingModel.class, new Annotation[]{new Default.Literal()}).get();
    private static final Pattern COMMA_OR_NEWLINE = Pattern.compile(",|\\r?\\n");

    public EmbeddingStoreJsonRPCService() {
        TypeLiteral<EmbeddingStore<TextSegment>> embeddingStoreType = new TypeLiteral<EmbeddingStore<TextSegment>>(){};
        this.embeddingStore = (EmbeddingStore)CDI.current().select((TypeLiteral)embeddingStoreType, new Annotation[]{new Default.Literal()}).get();
    }

    public String add(String id, String text, String metadata) {
        if (id == null || id.isEmpty()) {
            return this.embeddingStore.add((Embedding)this.embeddingModel.embed(text).content(), (Object)TextSegment.from((String)text, (Metadata)this.parseMetadata(metadata)));
        }
        this.embeddingStore.add(id, (Embedding)this.embeddingModel.embed(TextSegment.from((String)text, (Metadata)this.parseMetadata(metadata))).content());
        return id;
    }

    private Metadata parseMetadata(String metadata) {
        Metadata metadataObject = new Metadata();
        for (String metadataField : COMMA_OR_NEWLINE.split(metadata)) {
            String[] keyValue = metadataField.split("=");
            if (keyValue.length != 2) continue;
            metadataObject.add(keyValue[0].trim(), keyValue[1].trim());
        }
        return metadataObject;
    }

    public JsonArray findRelevant(String text, String limit) {
        int limitInt = Integer.parseInt(limit);
        JsonArray result = new JsonArray();
        for (EmbeddingMatch match : this.embeddingStore.findRelevant((Embedding)this.embeddingModel.embed(text).content(), limitInt)) {
            JsonObject matchJson = new JsonObject();
            matchJson.put("embeddingId", (Object)match.embeddingId());
            matchJson.put("score", (Object)match.score());
            matchJson.put("embedded", match.embedded() != null ? ((TextSegment)match.embedded()).text() : null);
            JsonArray metadata = new JsonArray();
            if (match.embedded() != null && ((TextSegment)match.embedded()).metadata() != null) {
                for (String key : ((TextSegment)match.embedded()).metadata().asMap().keySet()) {
                    JsonObject metadataEntry = new JsonObject();
                    metadataEntry.put("key", (Object)key);
                    metadataEntry.put("value", (Object)((TextSegment)match.embedded()).metadata().get(key));
                    metadata.add((Object)metadataEntry);
                }
            }
            matchJson.put("metadata", (Object)metadata);
            result.add((Object)matchJson);
        }
        return result;
    }
}

