/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.langchain4j.runtime.devui;

import com.github.dockerjava.api.command.CreateContainerResponse;
import com.github.dockerjava.api.command.InspectContainerResponse;
import com.github.dockerjava.api.exception.NotFoundException;
import com.github.dockerjava.api.model.Bind;
import com.github.dockerjava.api.model.Container;
import com.github.dockerjava.api.model.DeviceRequest;
import com.github.dockerjava.api.model.HostConfig;
import com.github.dockerjava.api.model.PortBinding;
import com.github.dockerjava.api.model.Volume;
import jakarta.enterprise.context.control.ActivateRequestContext;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.eclipse.microprofile.config.ConfigProvider;
import org.testcontainers.DockerClientFactory;

@ActivateRequestContext
public class OpenWebUIJsonRPCService {
    public static final Runnable CLOSE_TASK = () -> {
        OpenWebUIJsonRPCService service = new OpenWebUIJsonRPCService();
        service.stopOpenWebUI();
    };
    private static final String CONTAINER_NAME_PREFIX = "quarkus-open-webui-";

    public boolean isOpenWebUIRunning() {
        InspectContainerResponse container = this.inspectOpenWebUIContainer();
        return container != null && container.getState().getRunning() != false;
    }

    public String getOpenWebUIUrl() {
        InspectContainerResponse container = this.inspectOpenWebUIContainer();
        if (container != null) {
            return container.getNetworkSettings().getPorts().getBindings().values().stream().flatMap(Arrays::stream).map(p -> "http://localhost:" + p.getHostPortSpec()).findFirst().orElse(null);
        }
        return null;
    }

    public InspectContainerResponse inspectOpenWebUIContainer() {
        return ((List)DockerClientFactory.lazyClient().listContainersCmd().exec()).stream().filter(OpenWebUIJsonRPCService::isOpenWebUIContainer).findFirst().map(c -> c.getId()).map(id -> DockerClientFactory.lazyClient().inspectContainerCmd(id).exec()).orElse(null);
    }

    public CreateContainerResponse startOpenWebUI(String image, boolean requestGpu, Map<Integer, Integer> portBindings, Map<String, String> envVars, Map<String, String> volumes) {
        if (!this.isOpenWebUIRunning()) {
            ArrayList<PortBinding> allPortBindings = new ArrayList<PortBinding>();
            ArrayList<CallSite> allEnvVars = new ArrayList<CallSite>();
            ArrayList<Bind> allBinds = new ArrayList<Bind>();
            ArrayList<Volume> allVolumes = new ArrayList<Volume>();
            ArrayList<DeviceRequest> allDeviceRequests = new ArrayList<DeviceRequest>();
            try {
                List images = (List)DockerClientFactory.lazyClient().listImagesCmd().exec();
                if (images.stream().filter(i -> i.getRepoTags() != null).noneMatch(i -> Arrays.asList(i.getRepoTags()).contains(image))) {
                    DockerClientFactory.lazyClient().pullImageCmd(image).start().awaitCompletion();
                }
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
            for (Map.Entry<Integer, Integer> entry : portBindings.entrySet()) {
                allPortBindings.add(PortBinding.parse((String)(entry.getKey() + ":" + entry.getValue())));
            }
            for (Map.Entry<Object, Object> entry : envVars.entrySet()) {
                allEnvVars.add((CallSite)((Object)((String)entry.getKey() + "=" + (String)entry.getValue())));
            }
            for (Map.Entry<Object, Object> entry : volumes.entrySet()) {
                String path = (String)entry.getKey();
                Volume volume = new Volume((String)entry.getValue());
                allBinds.add(new Bind(path, volume));
                allVolumes.add(volume);
                try {
                    DockerClientFactory.lazyClient().inspectVolumeCmd(path).exec();
                }
                catch (NotFoundException nfe) {
                    DockerClientFactory.lazyClient().createVolumeCmd().withName(path).exec();
                }
            }
            if (requestGpu) {
                DeviceRequest gpu = new DeviceRequest().withCount(Integer.valueOf(-1)).withCapabilities(List.of(List.of("gpu")));
                allDeviceRequests.add(gpu);
            }
            HostConfig hostConfig = new HostConfig().withBinds(allBinds).withPortBindings(allPortBindings).withExtraHosts(new String[]{"host.docker.internal:host-gateway"}).withDeviceRequests(allDeviceRequests);
            CreateContainerResponse createContainerResponse = DockerClientFactory.lazyClient().createContainerCmd(image).withEnv(allEnvVars).withVolumes(allVolumes).withName(CONTAINER_NAME_PREFIX + System.currentTimeMillis()).withHostConfig(hostConfig).exec();
            DockerClientFactory.lazyClient().startContainerCmd(createContainerResponse.getId()).exec();
            return createContainerResponse;
        }
        return null;
    }

    public boolean stopOpenWebUI() {
        InspectContainerResponse container = this.inspectOpenWebUIContainer();
        if (container != null) {
            DockerClientFactory.lazyClient().stopContainerCmd(container.getId()).exec();
            DockerClientFactory.lazyClient().removeContainerCmd(container.getId()).exec();
            return true;
        }
        return false;
    }

    public String getConfigValue(String key) {
        try {
            return (String)ConfigProvider.getConfig().getValue(key, String.class);
        }
        catch (Exception e) {
            return null;
        }
    }

    private static boolean isOpenWebUIContainer(Container c) {
        return Arrays.stream(c.getNames()).anyMatch(n -> n.startsWith("/quarkus-open-webui-"));
    }
}

