/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.langchain4j.runtime.jackson;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import dev.langchain4j.data.embedding.Embedding;
import dev.langchain4j.data.segment.TextSegment;
import dev.langchain4j.store.embedding.inmemory.InMemoryEmbeddingStore;
import java.io.IOException;
import java.util.List;

public class InMemoryEmbeddingStoreDeserializer
extends StdDeserializer<InMemoryEmbeddingStore<TextSegment>> {
    public InMemoryEmbeddingStoreDeserializer() {
        super(InMemoryEmbeddingStore.class);
    }

    public InMemoryEmbeddingStoreDeserializer(Class<?> vc) {
        super(vc);
    }

    public InMemoryEmbeddingStore<TextSegment> deserialize(JsonParser p, DeserializationContext ctxt) throws IOException {
        return ((InMemoryEmbeddingStoreMirror)ctxt.readValue(p, InMemoryEmbeddingStoreMirror.class)).toInMemoryEmbeddingStore();
    }

    private static class InMemoryEmbeddingStoreMirror {
        public List<InMemoryEmbeddingStoreEntryMirror> entries;

        private InMemoryEmbeddingStoreMirror() {
        }

        public InMemoryEmbeddingStore<TextSegment> toInMemoryEmbeddingStore() {
            InMemoryEmbeddingStore result = new InMemoryEmbeddingStore();
            for (InMemoryEmbeddingStoreEntryMirror entry : this.entries) {
                result.add(entry.id, entry.embedding, (Object)entry.embedded);
            }
            return result;
        }
    }

    private static class InMemoryEmbeddingStoreEntryMirror {
        public String id;
        public Embedding embedding;
        public TextSegment embedded;

        private InMemoryEmbeddingStoreEntryMirror() {
        }
    }
}

