/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.langchain4j.runtime.listeners;

import dev.langchain4j.data.message.AiMessage;
import dev.langchain4j.model.chat.listener.ChatModelErrorContext;
import dev.langchain4j.model.chat.listener.ChatModelListener;
import dev.langchain4j.model.chat.listener.ChatModelRequest;
import dev.langchain4j.model.chat.listener.ChatModelRequestContext;
import dev.langchain4j.model.chat.listener.ChatModelResponse;
import dev.langchain4j.model.chat.listener.ChatModelResponseContext;
import dev.langchain4j.model.output.TokenUsage;
import io.micrometer.core.instrument.Clock;
import io.micrometer.core.instrument.Counter;
import io.micrometer.core.instrument.Meter;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Metrics;
import io.micrometer.core.instrument.Tag;
import io.micrometer.core.instrument.Tags;
import io.micrometer.core.instrument.Timer;
import java.util.concurrent.TimeUnit;
import org.jboss.logging.Logger;

public class MetricsChatModelListener
implements ChatModelListener {
    private static final Logger log = Logger.getLogger(MetricsChatModelListener.class);
    public static final String START_TIME_KEY_NAME = "startTime";
    private final Meter.MeterProvider<Counter> inputTokenUsage = Counter.builder((String)"gen_ai.client.token.usage").description("Measures number of input tokens used").tag("gen_ai.operation.name", "completion").tag("gen_ai.token.type", "input").withRegistry((MeterRegistry)Metrics.globalRegistry);
    private final Meter.MeterProvider<Counter> outputTokenUsage = Counter.builder((String)"gen_ai.client.token.usage").description("Measures number of output tokens used").tag("gen_ai.operation.name", "completion").tag("gen_ai.token.type", "output").withRegistry((MeterRegistry)Metrics.globalRegistry);
    private final Meter.MeterProvider<Timer> duration = Timer.builder((String)"gen_ai.client.operation.duration").description("GenAI operation duration").tag("gen_ai.operation.name", "completion").withRegistry((MeterRegistry)Metrics.globalRegistry);

    public void onRequest(ChatModelRequestContext requestContext) {
        long startTime = Clock.SYSTEM.monotonicTime();
        requestContext.attributes().put(START_TIME_KEY_NAME, startTime);
    }

    public void onResponse(ChatModelResponseContext responseContext) {
        long endTime = Clock.SYSTEM.monotonicTime();
        ChatModelRequest request = responseContext.request();
        ChatModelResponse response = responseContext.response();
        Tags tags = Tags.of((Tag[])new Tag[]{Tag.of((String)"gen_ai.request.model", (String)request.model()), Tag.of((String)"gen_ai.response.model", (String)response.model())});
        this.recordTokenUsage(responseContext, tags);
        this.recordDuration(responseContext, endTime, tags);
    }

    public void onError(ChatModelErrorContext errorContext) {
        long endTime = Clock.SYSTEM.monotonicTime();
        Long startTime = (Long)errorContext.attributes().get(START_TIME_KEY_NAME);
        if (startTime == null) {
            log.warn((Object)"No start time found in response");
            return;
        }
        AiMessage aiMessage = errorContext.partialResponse().aiMessage();
        if (aiMessage == null) {
            return;
        }
        Tags tags = Tags.of((Tag[])new Tag[]{Tag.of((String)"gen_ai.request.model", (String)errorContext.request().model()), Tag.of((String)"gen_ai.response.model", (String)errorContext.partialResponse().model()), Tag.of((String)"error.type", (String)aiMessage.text())});
        ((Timer)this.duration.withTags((Iterable)tags)).record(endTime - startTime, TimeUnit.NANOSECONDS);
    }

    private void recordTokenUsage(ChatModelResponseContext responseContext, Tags tags) {
        Integer outputTokenCount;
        TokenUsage tokenUsage = responseContext.response().tokenUsage();
        if (tokenUsage == null) {
            return;
        }
        Integer inputTokenCount = tokenUsage.inputTokenCount();
        if (inputTokenCount != null) {
            ((Counter)this.inputTokenUsage.withTags((Iterable)tags)).increment((double)inputTokenCount.intValue());
        }
        if ((outputTokenCount = tokenUsage.outputTokenCount()) != null) {
            ((Counter)this.outputTokenUsage.withTags((Iterable)tags)).increment((double)outputTokenCount.intValue());
        }
    }

    private void recordDuration(ChatModelResponseContext responseContext, long endTime, Tags tags) {
        Long startTime = (Long)responseContext.attributes().get(START_TIME_KEY_NAME);
        if (startTime == null) {
            log.warn((Object)"No start time found in response");
            return;
        }
        ((Timer)this.duration.withTags((Iterable)tags)).record(endTime - startTime, TimeUnit.NANOSECONDS);
    }
}

