/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.langchain4j.runtime.tool;

import com.fasterxml.jackson.core.JsonProcessingException;
import dev.langchain4j.agent.tool.ToolExecutionRequest;
import dev.langchain4j.internal.Json;
import dev.langchain4j.service.tool.ToolExecutor;
import io.quarkiverse.langchain4j.QuarkusJsonCodecFactory;
import io.quarkiverse.langchain4j.runtime.prompt.Mappable;
import io.quarkiverse.langchain4j.runtime.tool.ToolInvoker;
import java.lang.reflect.InvocationTargetException;
import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import java.util.function.BiFunction;
import org.jboss.logging.Logger;

public class QuarkusToolExecutor
implements ToolExecutor {
    private static final Logger log = Logger.getLogger(QuarkusToolExecutor.class);
    private final Context context;

    public QuarkusToolExecutor(Context context) {
        this.context = context;
    }

    public String execute(ToolExecutionRequest toolExecutionRequest, Object memoryId) {
        log.debugv("About to execute {0}", (Object)toolExecutionRequest);
        ToolInvoker invokerInstance = this.createInvokerInstance();
        Object[] params = this.prepareArguments(toolExecutionRequest, invokerInstance.methodMetadata(), memoryId);
        try {
            if (log.isDebugEnabled()) {
                log.debugv("Attempting to invoke tool {0} with parameters {1}", this.context.tool, (Object)Arrays.toString(params));
            }
            Object invocationResult = invokerInstance.invoke(this.context.tool, params);
            String result = QuarkusToolExecutor.handleResult(invokerInstance, invocationResult);
            log.debugv("Tool execution result: {0}", (Object)result);
            return result;
        }
        catch (Exception e) {
            if (e instanceof IllegalArgumentException) {
                throw (IllegalArgumentException)e;
            }
            log.error((Object)("Error while executing tool '" + this.context.tool.getClass() + "'"), (Throwable)e);
            return e.getMessage();
        }
    }

    private static String handleResult(ToolInvoker invokerInstance, Object invocationResult) {
        if (invokerInstance.methodMetadata().isReturnsVoid()) {
            return "Success";
        }
        return Json.toJson((Object)invocationResult);
    }

    private ToolInvoker createInvokerInstance() {
        ToolInvoker invokerInstance;
        try {
            invokerInstance = (ToolInvoker)Class.forName(this.context.toolInvokerName, true, Thread.currentThread().getContextClassLoader()).getConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            throw new IllegalStateException("Unable to create instance of '" + this.context.toolInvokerName + "'. Please report this issue to the maintainers", e);
        }
        return invokerInstance;
    }

    private Object[] prepareArguments(ToolExecutionRequest toolExecutionRequest, ToolInvoker.MethodMetadata methodMetadata, Object memoryId) {
        Map<String, Object> argumentsFromRequest;
        String argumentsJsonStr = toolExecutionRequest.arguments();
        try {
            log.debugv("Attempting to convert {0} JSON string into args map", (Object)argumentsJsonStr);
            argumentsFromRequest = this.convertJsonToArguments(argumentsJsonStr);
            log.debugv("Converted {0} JSON string into args map {1}", (Object)argumentsJsonStr, argumentsFromRequest);
        }
        catch (JsonProcessingException e) {
            log.error((Object)e);
            this.invalidMethodParams(argumentsJsonStr);
            return null;
        }
        if (argumentsFromRequest.size() != methodMetadata.getNameToParamPosition().size()) {
            this.invalidMethodParams(argumentsJsonStr);
        }
        Object[] finalArgs = new Object[argumentsFromRequest.size()];
        for (Map.Entry<String, Object> entry : argumentsFromRequest.entrySet()) {
            Integer pos = methodMetadata.getNameToParamPosition().get(entry.getKey());
            if (pos == null) {
                this.invalidMethodParams(argumentsJsonStr);
                continue;
            }
            finalArgs[pos.intValue()] = entry.getValue();
        }
        if (memoryId != null && methodMetadata.getMemoryIdParamPosition() != null) {
            finalArgs[methodMetadata.getMemoryIdParamPosition().intValue()] = memoryId;
        }
        return finalArgs;
    }

    private Map<String, Object> convertJsonToArguments(String argumentsJsonStr) throws JsonProcessingException {
        if (argumentsJsonStr == null || argumentsJsonStr.isEmpty()) {
            return Collections.emptyMap();
        }
        Mappable mappable = (Mappable)QuarkusJsonCodecFactory.ObjectMapperHolder.MAPPER.readValue(argumentsJsonStr, this.loadMapperClass());
        return mappable.obtainFieldValuesMap();
    }

    private Class<? extends Mappable> loadMapperClass() {
        try {
            return Class.forName(this.context.argumentMapperClassName, true, Thread.currentThread().getContextClassLoader());
        }
        catch (ClassNotFoundException e) {
            throw new IllegalStateException("Unable to load argument mapper of '" + this.context.toolInvokerName + "'. Please report this issue to the maintainers", e);
        }
    }

    private void invalidMethodParams(String argumentsJsonStr) {
        throw new IllegalArgumentException("params '" + argumentsJsonStr + "' from request do not map onto the parameters needed by '" + this.context.tool.getClass().getName() + "#" + this.context.methodName + "'");
    }

    public record Context(Object tool, String toolInvokerName, String methodName, String argumentMapperClassName) {
    }

    public static interface Wrapper {
        public String wrap(ToolExecutionRequest var1, Object var2, BiFunction<ToolExecutionRequest, Object, String> var3);
    }
}

