/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.langchain4j.runtime.aiservice;

import dev.langchain4j.agent.tool.ToolSpecification;
import dev.langchain4j.service.tool.ToolExecutor;
import io.quarkiverse.langchain4j.runtime.ResponseSchemaUtil;
import io.quarkiverse.langchain4j.runtime.types.TypeSignatureParser;
import io.quarkus.arc.impl.LazyValue;
import io.quarkus.runtime.annotations.RecordableConstructor;
import java.lang.reflect.Type;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.function.Supplier;

public final class AiServiceMethodCreateInfo {
    private final String interfaceName;
    private final String methodName;
    private final Optional<TemplateInfo> systemMessageInfo;
    private final UserMessageInfo userMessageInfo;
    private final Optional<Integer> memoryIdParamPosition;
    private final boolean requiresModeration;
    private final String returnTypeSignature;
    private final transient LazyValue<Type> returnTypeVal;
    private final Optional<MetricsTimedInfo> metricsTimedInfo;
    private final Optional<MetricsCountedInfo> metricsCountedInfo;
    private final Optional<SpanInfo> spanInfo;
    private final List<String> toolClassNames;
    private final ResponseSchemaInfo responseSchemaInfo;
    private final transient List<ToolSpecification> toolSpecifications = new CopyOnWriteArrayList<ToolSpecification>();
    private final transient Map<String, ToolExecutor> toolExecutors = new ConcurrentHashMap<String, ToolExecutor>();

    @RecordableConstructor
    public AiServiceMethodCreateInfo(String interfaceName, String methodName, Optional<TemplateInfo> systemMessageInfo, UserMessageInfo userMessageInfo, Optional<Integer> memoryIdParamPosition, boolean requiresModeration, final String returnTypeSignature, Optional<MetricsTimedInfo> metricsTimedInfo, Optional<MetricsCountedInfo> metricsCountedInfo, Optional<SpanInfo> spanInfo, ResponseSchemaInfo responseSchemaInfo, List<String> toolClassNames) {
        this.interfaceName = interfaceName;
        this.methodName = methodName;
        this.systemMessageInfo = systemMessageInfo;
        this.userMessageInfo = userMessageInfo;
        this.memoryIdParamPosition = memoryIdParamPosition;
        this.requiresModeration = requiresModeration;
        this.returnTypeSignature = returnTypeSignature;
        this.returnTypeVal = new LazyValue((Supplier)new Supplier<Type>(){

            @Override
            public Type get() {
                return TypeSignatureParser.parse(returnTypeSignature);
            }
        });
        this.metricsTimedInfo = metricsTimedInfo;
        this.metricsCountedInfo = metricsCountedInfo;
        this.spanInfo = spanInfo;
        this.responseSchemaInfo = responseSchemaInfo;
        this.toolClassNames = toolClassNames;
    }

    public String getInterfaceName() {
        return this.interfaceName;
    }

    public String getMethodName() {
        return this.methodName;
    }

    public Optional<TemplateInfo> getSystemMessageInfo() {
        return this.systemMessageInfo;
    }

    public UserMessageInfo getUserMessageInfo() {
        return this.userMessageInfo;
    }

    public Optional<Integer> getMemoryIdParamPosition() {
        return this.memoryIdParamPosition;
    }

    public boolean isRequiresModeration() {
        return this.requiresModeration;
    }

    public String getReturnTypeSignature() {
        return this.returnTypeSignature;
    }

    public Type getReturnType() {
        return (Type)this.returnTypeVal.get();
    }

    public Optional<MetricsTimedInfo> getMetricsTimedInfo() {
        return this.metricsTimedInfo;
    }

    public Optional<MetricsCountedInfo> getMetricsCountedInfo() {
        return this.metricsCountedInfo;
    }

    public Optional<SpanInfo> getSpanInfo() {
        return this.spanInfo;
    }

    public ResponseSchemaInfo getResponseSchemaInfo() {
        return this.responseSchemaInfo;
    }

    public List<String> getToolClassNames() {
        return this.toolClassNames;
    }

    public List<ToolSpecification> getToolSpecifications() {
        return this.toolSpecifications;
    }

    public Map<String, ToolExecutor> getToolExecutors() {
        return this.toolExecutors;
    }

    public record UserMessageInfo(Optional<TemplateInfo> template, Optional<Integer> paramPosition, Optional<Integer> userNameParamPosition) {
        public static UserMessageInfo fromMethodParam(int paramPosition, Optional<Integer> userNameParamPosition) {
            return new UserMessageInfo(Optional.empty(), Optional.of(paramPosition), userNameParamPosition);
        }

        public static UserMessageInfo fromTemplate(TemplateInfo templateInfo, Optional<Integer> userNameParamPosition) {
            return new UserMessageInfo(Optional.of(templateInfo), Optional.empty(), userNameParamPosition);
        }
    }

    public record ResponseSchemaInfo(boolean enabled, boolean isInSystemMessage, Optional<Boolean> isInUserMessage, String outputFormatInstructions) {
        public static ResponseSchemaInfo of(boolean enabled, Optional<TemplateInfo> systemMessageInfo, Optional<TemplateInfo> userMessageInfo, String outputFormatInstructions) {
            boolean systemMessage = systemMessageInfo.flatMap(TemplateInfo::text).map(text -> text.contains(ResponseSchemaUtil.placeholder())).orElse(false);
            Optional<Boolean> userMessage = Optional.empty();
            if (userMessageInfo.isPresent() && userMessageInfo.get().text.isPresent()) {
                userMessage = Optional.of(userMessageInfo.get().text.get().contains(ResponseSchemaUtil.placeholder()));
            }
            return new ResponseSchemaInfo(enabled, systemMessage, userMessage, outputFormatInstructions);
        }
    }

    public record SpanInfo(String name) {
    }

    public record MetricsCountedInfo(String name, String[] extraTags, boolean recordFailuresOnly, String description) {

        public static class Builder {
            private final String name;
            private String[] extraTags = new String[0];
            private boolean recordFailuresOnly = false;
            private String description = "";

            public Builder(String name) {
                this.name = name;
            }

            public Builder setExtraTags(String[] extraTags) {
                this.extraTags = extraTags;
                return this;
            }

            public Builder setRecordFailuresOnly(boolean recordFailuresOnly) {
                this.recordFailuresOnly = recordFailuresOnly;
                return this;
            }

            public Builder setDescription(String description) {
                this.description = description;
                return this;
            }

            public MetricsCountedInfo build() {
                return new MetricsCountedInfo(this.name, this.extraTags, this.recordFailuresOnly, this.description);
            }
        }
    }

    public record MetricsTimedInfo(String name, boolean longTask, String[] extraTags, double[] percentiles, boolean histogram, String description) {

        public static class Builder {
            private final String name;
            private boolean longTask = false;
            private String[] extraTags = new String[0];
            private double[] percentiles = new double[0];
            private boolean histogram = false;
            private String description = "";

            public Builder(String name) {
                this.name = name;
            }

            public Builder setLongTask(boolean longTask) {
                this.longTask = longTask;
                return this;
            }

            public Builder setExtraTags(String[] extraTags) {
                this.extraTags = extraTags;
                return this;
            }

            public Builder setPercentiles(double[] percentiles) {
                this.percentiles = percentiles;
                return this;
            }

            public Builder setHistogram(boolean histogram) {
                this.histogram = histogram;
                return this;
            }

            public Builder setDescription(String description) {
                this.description = description;
                return this;
            }

            public MetricsTimedInfo build() {
                return new MetricsTimedInfo(this.name, this.longTask, this.extraTags, this.percentiles, this.histogram, this.description);
            }
        }
    }

    public record TemplateInfo(Optional<String> text, Map<String, Integer> nameToParamPosition, Optional<Integer> methodParamPosition) {
        public static TemplateInfo fromText(String text, Map<String, Integer> nameToParamPosition) {
            return new TemplateInfo(Optional.of(text), nameToParamPosition, Optional.empty());
        }

        public static TemplateInfo fromMethodParam(Integer methodParamPosition, Map<String, Integer> nameToParamPosition) {
            return new TemplateInfo(Optional.empty(), nameToParamPosition, Optional.of(methodParamPosition));
        }
    }
}

