/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.langchain4j.guardrails;

import com.fasterxml.jackson.core.type.TypeReference;
import dev.langchain4j.data.message.AiMessage;
import io.quarkiverse.langchain4j.guardrails.JsonGuardrailsUtils;
import io.quarkiverse.langchain4j.guardrails.OutputGuardrail;
import io.quarkiverse.langchain4j.guardrails.OutputGuardrailResult;
import jakarta.inject.Inject;
import org.jboss.logging.Logger;

public abstract class AbstractJsonExtractorOutputGuardrail
implements OutputGuardrail {
    @Inject
    Logger logger;
    @Inject
    JsonGuardrailsUtils jsonGuardrailsUtils;

    protected AbstractJsonExtractorOutputGuardrail() {
        if (this.getOutputClass() == null && this.getOutputType() == null) {
            throw new IllegalArgumentException("Either getOutputClass() or getOutputType() must be implemented");
        }
    }

    @Override
    public OutputGuardrailResult validate(AiMessage responseFromLLM) {
        String llmResponse = responseFromLLM.text();
        this.logger.debugf("LLM output: %s", (Object)llmResponse);
        Object result = this.deserialize(llmResponse);
        if (result != null) {
            return this.successWith(llmResponse, result);
        }
        String json = this.jsonGuardrailsUtils.trimNonJson(llmResponse);
        if (json != null && (result = this.deserialize(json)) != null) {
            return this.successWith(json, result);
        }
        return this.reprompt("Invalid JSON", "Make sure you return a valid JSON object following the specified format");
    }

    protected Object deserialize(String llmResponse) {
        return this.getOutputClass() != null ? this.jsonGuardrailsUtils.deserialize(llmResponse, this.getOutputClass()) : this.jsonGuardrailsUtils.deserialize(llmResponse, this.getOutputType());
    }

    protected Class<?> getOutputClass() {
        return null;
    }

    protected TypeReference<?> getOutputType() {
        return null;
    }
}

