/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.langchain4j.cost;

import dev.langchain4j.model.chat.listener.ChatModelResponseContext;
import dev.langchain4j.model.output.TokenUsage;
import io.quarkiverse.langchain4j.cost.Cost;
import io.quarkiverse.langchain4j.cost.CostEstimator;
import io.quarkus.arc.All;
import io.smallrye.common.annotation.Experimental;
import jakarta.inject.Singleton;
import java.math.BigDecimal;
import java.util.Collections;
import java.util.List;

@Singleton
@Experimental(value="This feature is experimental and the API is subject to change")
public class CostEstimatorService {
    private final List<CostEstimator> costEstimators;

    public CostEstimatorService(@All List<CostEstimator> costEstimators) {
        this.costEstimators = costEstimators != null ? Collections.unmodifiableList(costEstimators) : Collections.emptyList();
    }

    public Cost estimate(ChatModelResponseContext response) {
        TokenUsage tokenUsage = response.response().tokenUsage();
        MyCostContext costContext = new MyCostContext(tokenUsage, response);
        for (CostEstimator costEstimator : this.costEstimators) {
            CostEstimator.CostResult costResult;
            if (!costEstimator.supports(costContext) || (costResult = costEstimator.estimate(costContext)) == null) continue;
            BigDecimal totalCost = costResult.inputTokensCost().add(costResult.outputTokensCost());
            return new Cost(totalCost, costResult.currency());
        }
        return null;
    }

    private record MyCostContext(TokenUsage tokenUsage, ChatModelResponseContext response) implements CostEstimator.CostContext
    {
        @Override
        public Integer inputTokens() {
            return this.tokenUsage != null ? this.tokenUsage.inputTokenCount() : 0;
        }

        @Override
        public Integer outputTokens() {
            return this.tokenUsage != null ? this.tokenUsage.outputTokenCount() : 0;
        }

        @Override
        public String model() {
            return this.response.request().model();
        }
    }
}

