/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.langchain4j.guardrails;

import dev.langchain4j.data.message.Content;
import dev.langchain4j.data.message.ContentType;
import dev.langchain4j.data.message.TextContent;
import dev.langchain4j.data.message.UserMessage;
import dev.langchain4j.memory.ChatMemory;
import dev.langchain4j.rag.AugmentationResult;
import io.quarkiverse.langchain4j.guardrails.GuardrailParams;
import java.util.List;
import java.util.Map;
import java.util.Optional;

public record InputGuardrailParams(UserMessage userMessage, ChatMemory memory, AugmentationResult augmentationResult, String userMessageTemplate, Map<String, Object> variables) implements GuardrailParams
{
    public static InputGuardrailParams from(UserMessage userMessage) {
        return InputGuardrailParams.from(userMessage, null);
    }

    public static InputGuardrailParams from(UserMessage userMessage, Map<String, Object> variables) {
        return new InputGuardrailParams(userMessage, null, null, null, Optional.ofNullable(variables).orElseGet(Map::of));
    }

    @Override
    public InputGuardrailParams withText(String text) {
        return new InputGuardrailParams(InputGuardrailParams.rewriteUserMessage(this.userMessage, text), this.memory, this.augmentationResult, this.userMessageTemplate, this.variables);
    }

    public static UserMessage rewriteUserMessage(UserMessage userMessage, String text) {
        List<Content> rewrittenContent = userMessage.contents().stream().map(c -> c.type() == ContentType.TEXT ? new TextContent(text) : c).toList();
        return userMessage.name() == null ? new UserMessage(rewrittenContent) : new UserMessage(userMessage.name(), rewrittenContent);
    }
}

