/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.langchain4j.runtime.aiservice;

import dev.langchain4j.agent.tool.ToolExecutionRequest;
import dev.langchain4j.agent.tool.ToolSpecification;
import dev.langchain4j.data.image.Image;
import dev.langchain4j.data.message.AiMessage;
import dev.langchain4j.data.message.ChatMessage;
import dev.langchain4j.data.message.ImageContent;
import dev.langchain4j.data.message.SystemMessage;
import dev.langchain4j.data.message.TextContent;
import dev.langchain4j.data.message.ToolExecutionResultMessage;
import dev.langchain4j.data.message.UserMessage;
import dev.langchain4j.internal.Exceptions;
import dev.langchain4j.memory.ChatMemory;
import dev.langchain4j.model.chat.Capability;
import dev.langchain4j.model.chat.ChatLanguageModel;
import dev.langchain4j.model.chat.request.ChatRequest;
import dev.langchain4j.model.chat.request.ResponseFormat;
import dev.langchain4j.model.chat.request.ResponseFormatType;
import dev.langchain4j.model.chat.request.json.JsonSchema;
import dev.langchain4j.model.chat.response.ChatResponse;
import dev.langchain4j.model.input.Prompt;
import dev.langchain4j.model.input.PromptTemplate;
import dev.langchain4j.model.input.structured.StructuredPrompt;
import dev.langchain4j.model.input.structured.StructuredPromptProcessor;
import dev.langchain4j.model.moderation.Moderation;
import dev.langchain4j.model.output.FinishReason;
import dev.langchain4j.model.output.Response;
import dev.langchain4j.model.output.TokenUsage;
import dev.langchain4j.rag.AugmentationRequest;
import dev.langchain4j.rag.AugmentationResult;
import dev.langchain4j.rag.content.Content;
import dev.langchain4j.rag.query.Metadata;
import dev.langchain4j.service.AiServiceContext;
import dev.langchain4j.service.AiServiceTokenStream;
import dev.langchain4j.service.AiServices;
import dev.langchain4j.service.Result;
import dev.langchain4j.service.TokenStream;
import dev.langchain4j.service.output.ServiceOutputParser;
import dev.langchain4j.service.tool.ToolExecutor;
import dev.langchain4j.service.tool.ToolProviderRequest;
import dev.langchain4j.service.tool.ToolProviderResult;
import dev.langchain4j.spi.ServiceHelper;
import io.quarkiverse.langchain4j.audit.Audit;
import io.quarkiverse.langchain4j.audit.AuditService;
import io.quarkiverse.langchain4j.guardrails.OutputGuardrailParams;
import io.quarkiverse.langchain4j.guardrails.OutputGuardrailResult;
import io.quarkiverse.langchain4j.response.ResponseAugmenterParams;
import io.quarkiverse.langchain4j.runtime.ContextLocals;
import io.quarkiverse.langchain4j.runtime.QuarkusServiceOutputParser;
import io.quarkiverse.langchain4j.runtime.ResponseSchemaUtil;
import io.quarkiverse.langchain4j.runtime.aiservice.AiServiceMethodCreateInfo;
import io.quarkiverse.langchain4j.runtime.aiservice.ChatMemorySeeder;
import io.quarkiverse.langchain4j.runtime.aiservice.CommittableChatMemory;
import io.quarkiverse.langchain4j.runtime.aiservice.DefaultCommittableChatMemory;
import io.quarkiverse.langchain4j.runtime.aiservice.GuardrailException;
import io.quarkiverse.langchain4j.runtime.aiservice.GuardrailsSupport;
import io.quarkiverse.langchain4j.runtime.aiservice.NoopChatMemory;
import io.quarkiverse.langchain4j.runtime.aiservice.QuarkusAiServiceContext;
import io.quarkiverse.langchain4j.runtime.aiservice.QuarkusAiServiceTokenStream;
import io.quarkiverse.langchain4j.runtime.aiservice.ResponseAugmenterSupport;
import io.quarkiverse.langchain4j.runtime.types.TypeUtil;
import io.quarkiverse.langchain4j.spi.DefaultMemoryIdProvider;
import io.smallrye.common.vertx.VertxContext;
import io.smallrye.mutiny.Multi;
import io.smallrye.mutiny.infrastructure.Infrastructure;
import io.smallrye.mutiny.operators.AbstractMulti;
import io.smallrye.mutiny.operators.multi.processors.UnicastProcessor;
import io.smallrye.mutiny.subscription.MultiSubscriber;
import io.vertx.core.Context;
import java.lang.reflect.Array;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.Callable;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Flow;
import java.util.concurrent.Future;
import java.util.function.Function;
import java.util.function.Supplier;
import org.eclipse.microprofile.config.ConfigProvider;
import org.jboss.logging.Logger;

public class AiServiceMethodImplementationSupport {
    private static final Logger log = Logger.getLogger(AiServiceMethodImplementationSupport.class);
    private static final int DEFAULT_MAX_SEQUENTIAL_TOOL_EXECUTIONS = 10;
    private static final List<DefaultMemoryIdProvider> DEFAULT_MEMORY_ID_PROVIDERS;
    private static final ServiceOutputParser SERVICE_OUTPUT_PARSER;

    public Object implement(Input input) {
        if (ContextLocals.duplicatedContextActive()) {
            ContextLocals.put("aiservice.classname", input.context.aiServiceClass.getName());
            ContextLocals.put("aiservice.methodname", input.createInfo.getMethodName());
        }
        QuarkusAiServiceContext context = input.context;
        AiServiceMethodCreateInfo createInfo = input.createInfo;
        Object[] methodArgs = input.methodArgs;
        AuditService auditService = context.auditService;
        Audit audit = null;
        if (auditService != null) {
            audit = auditService.create(new Audit.CreateInfo(createInfo.getInterfaceName(), createInfo.getMethodName(), methodArgs, createInfo.getMemoryIdParamPosition()));
        }
        try {
            Object result = AiServiceMethodImplementationSupport.doImplement(createInfo, methodArgs, context, audit);
            if (audit != null) {
                audit.onCompletion(result);
                auditService.complete(audit);
            }
            return result;
        }
        catch (Exception e) {
            if (audit != null) {
                audit.onFailure(e);
                auditService.complete(audit);
            }
            throw e;
        }
    }

    private static Object doImplement(final AiServiceMethodCreateInfo methodCreateInfo, Object[] methodArgs, final QuarkusAiServiceContext context, Audit audit) {
        int maxSequentialToolExecutions;
        List<ChatMessage> messagesToSend;
        Object chatMemory;
        HashMap<String, ToolExecutor> toolExecutors;
        final boolean isRunningOnWorkerThread = !Context.isOnEventLoopThread();
        final Object memoryId = AiServiceMethodImplementationSupport.memoryId(methodCreateInfo, methodArgs, context.chatMemoryProvider != null);
        final Optional<SystemMessage> systemMessage = AiServiceMethodImplementationSupport.prepareSystemMessage(methodCreateInfo, methodArgs, context.hasChatMemory() ? context.chatMemory(memoryId).messages() : Collections.emptyList());
        boolean supportsJsonSchema = AiServiceMethodImplementationSupport.supportsJsonSchema(context);
        UserMessage userMessage = AiServiceMethodImplementationSupport.prepareUserMessage(context, methodCreateInfo, methodArgs, supportsJsonSchema);
        final Map<String, Object> templateVariables = AiServiceMethodImplementationSupport.getTemplateVariables(methodArgs, methodCreateInfo.getUserMessageInfo());
        Type returnType = methodCreateInfo.getReturnType();
        if (TypeUtil.isImage(returnType) || TypeUtil.isResultImage(returnType)) {
            return AiServiceMethodImplementationSupport.doImplementGenerateImage(methodCreateInfo, context, audit, systemMessage, userMessage, memoryId, returnType, templateVariables);
        }
        if (audit != null) {
            audit.initialMessages(systemMessage, userMessage);
        }
        final boolean needsMemorySeed = AiServiceMethodImplementationSupport.needsMemorySeed(context, memoryId);
        boolean hasMethodSpecificTools = methodCreateInfo.getToolClassNames() != null && !methodCreateInfo.getToolClassNames().isEmpty();
        ArrayList<ToolSpecification> toolSpecifications = hasMethodSpecificTools ? methodCreateInfo.getToolSpecifications() : context.toolService.toolSpecifications();
        HashMap<String, ToolExecutor> hashMap = toolExecutors = hasMethodSpecificTools ? methodCreateInfo.getToolExecutors() : context.toolService.toolExecutors();
        if (context.toolService.toolProvider() != null) {
            toolSpecifications = new ArrayList<ToolSpecification>();
            toolExecutors = new HashMap<String, ToolExecutor>();
            ToolProviderRequest request = new ToolProviderRequest(memoryId, userMessage);
            ToolProviderResult result = context.toolService.toolProvider().provideTools(request);
            for (ToolSpecification specification : result.tools().keySet()) {
                toolSpecifications.add(specification);
                toolExecutors.put(specification.name(), (ToolExecutor)result.tools().get(specification));
            }
        }
        final ArrayList<ToolSpecification> effectiveToolSpecifications = toolSpecifications;
        final HashMap<String, ToolExecutor> finalToolExecutors = toolExecutors;
        AugmentationResult augmentationResult = null;
        if (context.retrievalAugmentor != null) {
            chatMemory = context.hasChatMemory() ? context.chatMemory(memoryId).messages() : null;
            Metadata metadata = Metadata.from((UserMessage)userMessage, (Object)memoryId, (List)chatMemory);
            final AugmentationRequest augmentationRequest = new AugmentationRequest((ChatMessage)userMessage, metadata);
            if (!TypeUtil.isMulti(returnType)) {
                augmentationResult = context.retrievalAugmentor.augment(augmentationRequest);
                userMessage = (UserMessage)augmentationResult.chatMessage();
            } else {
                CompletableFuture<AugmentationResult> augmentationResultCF = CompletableFuture.supplyAsync(new Supplier<AugmentationResult>(){

                    @Override
                    public AugmentationResult get() {
                        return context.retrievalAugmentor.augment(augmentationRequest);
                    }
                }, Infrastructure.getDefaultWorkerPool());
                return Multi.createFrom().completionStage(augmentationResultCF).flatMap((Function)new Function<AugmentationResult, Flow.Publisher<? extends Object>>(){

                    @Override
                    public Flow.Publisher<?> apply(AugmentationResult ar) {
                        ChatMessage augmentedUserMessage = ar.chatMessage();
                        ChatMemory memory = context.chatMemory(memoryId);
                        UserMessage guardrailsMessage = GuardrailsSupport.invokeInputGuardrails(methodCreateInfo, (UserMessage)augmentedUserMessage, memory, ar, templateVariables);
                        List<ChatMessage> messagesToSend = this.messagesToSend(guardrailsMessage, needsMemorySeed);
                        TokenStreamMulti stream = new TokenStreamMulti(messagesToSend, effectiveToolSpecifications, finalToolExecutors, ar.contents(), context, memoryId, methodCreateInfo.isSwitchToWorkerThreadForToolExecution(), isRunningOnWorkerThread);
                        return stream.plug(m -> ResponseAugmenterSupport.apply(m, methodCreateInfo, new ResponseAugmenterParams((UserMessage)augmentedUserMessage, memory, ar, methodCreateInfo.getUserMessageTemplate(), templateVariables)));
                    }

                    private List<ChatMessage> messagesToSend(UserMessage augmentedUserMessage, boolean needsMemorySeed2) {
                        return context.hasChatMemory() ? AiServiceMethodImplementationSupport.createMessagesToSendForExistingMemory(systemMessage, (ChatMessage)augmentedUserMessage, context.chatMemory(memoryId), needsMemorySeed2, context, methodCreateInfo) : AiServiceMethodImplementationSupport.createMessagesToSendForNoMemory(systemMessage, (ChatMessage)augmentedUserMessage, needsMemorySeed2, context, methodCreateInfo);
                    }
                });
            }
        }
        userMessage = GuardrailsSupport.invokeInputGuardrails(methodCreateInfo, userMessage, context.hasChatMemory() ? context.chatMemory(memoryId) : null, augmentationResult, templateVariables);
        if (context.hasChatMemory()) {
            chatMemory = new DefaultCommittableChatMemory(context.chatMemory(memoryId));
            messagesToSend = AiServiceMethodImplementationSupport.createMessagesToSendForExistingMemory(systemMessage, (ChatMessage)userMessage, (ChatMemory)chatMemory, needsMemorySeed, context, methodCreateInfo);
        } else {
            chatMemory = new NoopChatMemory();
            messagesToSend = AiServiceMethodImplementationSupport.createMessagesToSendForNoMemory(systemMessage, (ChatMessage)userMessage, needsMemorySeed, context, methodCreateInfo);
        }
        if (TypeUtil.isTokenStream(returnType)) {
            chatMemory.commit();
            return new AiServiceTokenStream(messagesToSend, toolSpecifications, toolExecutors, augmentationResult != null ? augmentationResult.contents() : null, (AiServiceContext)context, memoryId);
        }
        AugmentationResult actualAugmentationResult = augmentationResult;
        UserMessage actualUserMessage = userMessage;
        if (TypeUtil.isMulti(returnType)) {
            chatMemory.commit();
            if (methodCreateInfo.getOutputGuardrailsClassNames().isEmpty()) {
                TokenStreamMulti stream = new TokenStreamMulti(messagesToSend, toolSpecifications, toolExecutors, augmentationResult != null ? augmentationResult.contents() : null, context, memoryId, methodCreateInfo.isSwitchToWorkerThreadForToolExecution(), isRunningOnWorkerThread);
                return stream.plug(arg_0 -> AiServiceMethodImplementationSupport.lambda$doImplement$0(methodCreateInfo, actualUserMessage, (CommittableChatMemory)chatMemory, actualAugmentationResult, templateVariables, arg_0));
            }
            return new TokenStreamMulti(messagesToSend, toolSpecifications, toolExecutors, augmentationResult != null ? augmentationResult.contents() : null, context, memoryId, methodCreateInfo.isSwitchToWorkerThreadForToolExecution(), isRunningOnWorkerThread).plug(s -> GuardrailsSupport.accumulate((Multi<String>)s, methodCreateInfo)).map(arg_0 -> AiServiceMethodImplementationSupport.lambda$doImplement$2(methodCreateInfo, (CommittableChatMemory)chatMemory, actualAugmentationResult, templateVariables, arg_0)).onFailure(GuardrailsSupport.GuardrailRetryException.class).retry().atMost((long)methodCreateInfo.getGuardrailsMaxRetry()).onFailure(GuardrailsSupport.GuardrailRetryException.class).transform(t -> new GuardrailException("Output validation failed. The guardrails have reached the maximum number of retries")).plug(arg_0 -> AiServiceMethodImplementationSupport.lambda$doImplement$4(methodCreateInfo, actualUserMessage, (CommittableChatMemory)chatMemory, actualAugmentationResult, templateVariables, arg_0));
        }
        Future<Moderation> moderationFuture = AiServiceMethodImplementationSupport.triggerModerationIfNeeded(context, methodCreateInfo, messagesToSend);
        log.debug((Object)"Attempting to obtain AI response");
        Response response = AiServiceMethodImplementationSupport.executeRequest(context, methodCreateInfo, messagesToSend, toolSpecifications);
        log.debug((Object)"AI response obtained");
        if (audit != null) {
            audit.addLLMToApplicationMessage(response);
        }
        TokenUsage tokenUsageAccumulator = response.tokenUsage();
        AiServices.verifyModerationIfNeeded(moderationFuture);
        int executionsLeft = maxSequentialToolExecutions = AiServiceMethodImplementationSupport.getMaxSequentialToolExecutions();
        while (true) {
            if (executionsLeft-- == 0) {
                throw Exceptions.runtime((String)"Something is wrong, exceeded %s sequential tool executions", (Object[])new Object[]{maxSequentialToolExecutions});
            }
            AiMessage aiMessage = (AiMessage)response.content();
            chatMemory.add((ChatMessage)aiMessage);
            if (!aiMessage.hasToolExecutionRequests()) break;
            for (ToolExecutionRequest toolExecutionRequest : aiMessage.toolExecutionRequests()) {
                log.debugv("Attempting to execute tool {0}", (Object)toolExecutionRequest);
                ToolExecutor toolExecutor = (ToolExecutor)toolExecutors.get(toolExecutionRequest.name());
                if (toolExecutor == null) {
                    throw Exceptions.runtime((String)"Tool executor %s not found", (Object[])new Object[]{toolExecutionRequest.name()});
                }
                String toolExecutionResult = toolExecutor.execute(toolExecutionRequest, memoryId);
                log.debugv("Result of {0} is '{1}'", (Object)toolExecutionRequest, (Object)toolExecutionResult);
                ToolExecutionResultMessage toolExecutionResultMessage = ToolExecutionResultMessage.from((ToolExecutionRequest)toolExecutionRequest, (String)toolExecutionResult);
                if (audit != null) {
                    audit.addApplicationToLLMMessage(toolExecutionResultMessage);
                }
                chatMemory.add((ChatMessage)toolExecutionResultMessage);
            }
            log.debug((Object)"Attempting to obtain AI response");
            response = context.chatModel.generate(chatMemory.messages(), toolSpecifications);
            log.debug((Object)"AI response obtained");
            if (audit != null) {
                audit.addLLMToApplicationMessage(response);
            }
            tokenUsageAccumulator = TokenUsage.sum((TokenUsage)tokenUsageAccumulator, (TokenUsage)response.tokenUsage());
        }
        String userMessageTemplate = methodCreateInfo.getUserMessageTemplate();
        response = GuardrailsSupport.invokeOutputGuardrails(methodCreateInfo, (ChatMemory)chatMemory, context.chatModel, (Response<AiMessage>)response, toolSpecifications, new OutputGuardrailParams((AiMessage)response.content(), (ChatMemory)chatMemory, augmentationResult, userMessageTemplate, Collections.unmodifiableMap(templateVariables)));
        chatMemory.commit();
        Object guardrailResult = response.metadata().get(OutputGuardrailResult.class.getName());
        if (guardrailResult != null && TypeUtil.isTypeOf(returnType, guardrailResult.getClass())) {
            return guardrailResult;
        }
        response = Response.from((Object)((AiMessage)response.content()), (TokenUsage)tokenUsageAccumulator, (FinishReason)response.finishReason(), (Map)response.metadata());
        ResponseAugmenterParams responseAugmenterParam = new ResponseAugmenterParams(userMessage, (ChatMemory)chatMemory, augmentationResult, userMessageTemplate, templateVariables);
        if (TypeUtil.isResult(returnType)) {
            Object parsedResponse = SERVICE_OUTPUT_PARSER.parse(response, TypeUtil.resultTypeParam((ParameterizedType)returnType));
            parsedResponse = ResponseAugmenterSupport.invoke(parsedResponse, methodCreateInfo, responseAugmenterParam);
            return Result.builder().content(parsedResponse).tokenUsage(tokenUsageAccumulator).sources(augmentationResult == null ? null : augmentationResult.contents()).finishReason(response.finishReason()).build();
        }
        return ResponseAugmenterSupport.invoke(SERVICE_OUTPUT_PARSER.parse(response, returnType), methodCreateInfo, responseAugmenterParam);
    }

    private static Response<AiMessage> executeRequest(JsonSchema jsonSchema, List<ChatMessage> messagesToSend, ChatLanguageModel chatModel, List<ToolSpecification> toolSpecifications) {
        ChatRequest chatRequest = ChatRequest.builder().messages(messagesToSend).toolSpecifications(toolSpecifications).responseFormat(ResponseFormat.builder().type(ResponseFormatType.JSON).jsonSchema(jsonSchema).build()).build();
        ChatResponse response = chatModel.chat(chatRequest);
        return new Response((Object)response.aiMessage(), response.tokenUsage(), response.finishReason());
    }

    private static Response<AiMessage> executeRequest(List<ChatMessage> messagesToSend, ChatLanguageModel chatModel, List<ToolSpecification> toolSpecifications) {
        return toolSpecifications == null ? chatModel.generate(messagesToSend) : chatModel.generate(messagesToSend, toolSpecifications);
    }

    static Response<AiMessage> executeRequest(AiServiceMethodCreateInfo methodCreateInfo, List<ChatMessage> messagesToSend, ChatLanguageModel chatModel, List<ToolSpecification> toolSpecifications) {
        Optional jsonSchema = AiServiceMethodImplementationSupport.supportsJsonSchema(chatModel) ? methodCreateInfo.getResponseSchemaInfo().structuredOutputSchema() : Optional.empty();
        return jsonSchema.isPresent() ? AiServiceMethodImplementationSupport.executeRequest((JsonSchema)jsonSchema.get(), messagesToSend, chatModel, toolSpecifications) : AiServiceMethodImplementationSupport.executeRequest(messagesToSend, chatModel, toolSpecifications);
    }

    static Response<AiMessage> executeRequest(QuarkusAiServiceContext context, AiServiceMethodCreateInfo methodCreateInfo, List<ChatMessage> messagesToSend, List<ToolSpecification> toolSpecifications) {
        return AiServiceMethodImplementationSupport.executeRequest(methodCreateInfo, messagesToSend, context.chatModel, toolSpecifications);
    }

    private static Object doImplementGenerateImage(AiServiceMethodCreateInfo methodCreateInfo, QuarkusAiServiceContext context, Audit audit, Optional<SystemMessage> systemMessage, UserMessage userMessage, Object memoryId, Type returnType, Map<String, Object> templateVariables) {
        Object imagePrompt = systemMessage.isPresent() ? systemMessage.get().text() + "\n" + userMessage.singleText() : userMessage.singleText();
        if (audit != null) {
            audit.initialMessages(systemMessage, userMessage);
        }
        AugmentationResult augmentationResult = null;
        GuardrailsSupport.invokeInputGuardrails(methodCreateInfo, userMessage, context.hasChatMemory() ? context.chatMemory(memoryId) : null, augmentationResult, templateVariables);
        Response imageResponse = context.imageModel.generate((String)imagePrompt);
        if (audit != null) {
            audit.onCompletion(imageResponse.content());
        }
        if (TypeUtil.isImage(returnType)) {
            return imageResponse.content();
        }
        if (TypeUtil.isResultImage(returnType)) {
            return Result.builder().content((Object)imageResponse).tokenUsage(imageResponse.tokenUsage()).sources(augmentationResult == null ? null : augmentationResult.contents()).finishReason(imageResponse.finishReason()).build();
        }
        throw new IllegalStateException("Unsupported return type: " + String.valueOf(returnType));
    }

    private static boolean needsMemorySeed(QuarkusAiServiceContext context, Object memoryId) {
        if (context.chatMemorySeeder == null) {
            return false;
        }
        if (!context.hasChatMemory()) {
            return false;
        }
        ChatMemory chatMemory = context.chatMemory(memoryId);
        return chatMemory.messages().isEmpty();
    }

    private static List<ChatMessage> createMessagesToSendForExistingMemory(Optional<SystemMessage> systemMessage, ChatMessage userMessage, ChatMemory chatMemory, boolean needsMemorySeed, QuarkusAiServiceContext context, AiServiceMethodCreateInfo methodCreateInfo) {
        if (systemMessage.isPresent()) {
            chatMemory.add((ChatMessage)systemMessage.get());
        }
        if (needsMemorySeed) {
            List<ChatMessage> seedChatMessages = context.chatMemorySeeder.seed(new ChatMemorySeeder.Context(methodCreateInfo.getMethodName()));
            for (ChatMessage seedChatMessage : seedChatMessages) {
                chatMemory.add(seedChatMessage);
            }
        }
        chatMemory.add(userMessage);
        return chatMemory.messages();
    }

    private static List<ChatMessage> createMessagesToSendForNoMemory(Optional<SystemMessage> systemMessage, ChatMessage userMessage, boolean needsMemorySeed, QuarkusAiServiceContext context, AiServiceMethodCreateInfo methodCreateInfo) {
        ArrayList<ChatMessage> result = new ArrayList<ChatMessage>();
        if (systemMessage.isPresent()) {
            result.add((ChatMessage)systemMessage.get());
        }
        if (needsMemorySeed) {
            result.addAll(context.chatMemorySeeder.seed(new ChatMemorySeeder.Context(methodCreateInfo.getMethodName())));
        }
        result.add(userMessage);
        return result;
    }

    private static boolean supportsJsonSchema(ChatLanguageModel chatModel) {
        return chatModel != null && chatModel.supportedCapabilities().contains(Capability.RESPONSE_FORMAT_JSON_SCHEMA);
    }

    private static boolean supportsJsonSchema(AiServiceContext context) {
        return AiServiceMethodImplementationSupport.supportsJsonSchema(context.chatModel);
    }

    private static Future<Moderation> triggerModerationIfNeeded(final AiServiceContext context, AiServiceMethodCreateInfo createInfo, final List<ChatMessage> messages) {
        Future<Moderation> moderationFuture = null;
        if (createInfo.isRequiresModeration()) {
            log.debug((Object)"Moderation is required and it will be executed in the background");
            ExecutorService defaultExecutor = (ExecutorService)Infrastructure.getDefaultExecutor();
            moderationFuture = defaultExecutor.submit(new Callable<Moderation>(){

                @Override
                public Moderation call() {
                    List messagesToModerate = AiServices.removeToolMessages((List)messages);
                    log.debug((Object)"Attempting to moderate messages");
                    Moderation result = (Moderation)context.moderationModel.moderate(messagesToModerate).content();
                    log.debug((Object)"Moderation completed");
                    return result;
                }
            });
        }
        return moderationFuture;
    }

    private static Optional<SystemMessage> prepareSystemMessage(AiServiceMethodCreateInfo createInfo, Object[] methodArgs, List<ChatMessage> previousChatMessages) {
        if (createInfo.getSystemMessageInfo().isEmpty()) {
            return Optional.empty();
        }
        AiServiceMethodCreateInfo.TemplateInfo systemMessageInfo = createInfo.getSystemMessageInfo().get();
        HashMap<String, Object> templateParams = new HashMap<String, Object>();
        Map<String, Integer> nameToParamPosition = systemMessageInfo.nameToParamPosition();
        for (Map.Entry<String, Integer> entry : nameToParamPosition.entrySet()) {
            templateParams.put(entry.getKey(), methodArgs[entry.getValue()]);
        }
        templateParams.put(ResponseSchemaUtil.templateParam(), createInfo.getResponseSchemaInfo().outputFormatInstructions());
        templateParams.put("chat_memory", previousChatMessages);
        Prompt prompt = PromptTemplate.from((String)systemMessageInfo.text().get()).apply(templateParams);
        return Optional.of(prompt.toSystemMessage());
    }

    private static UserMessage prepareUserMessage(AiServiceContext context, AiServiceMethodCreateInfo createInfo, Object[] methodArgs, boolean supportsJsonSchema) {
        AiServiceMethodCreateInfo.UserMessageInfo userMessageInfo = createInfo.getUserMessageInfo();
        String userName = null;
        ImageContent imageContent = null;
        if (userMessageInfo.userNameParamPosition().isPresent()) {
            userName = methodArgs[userMessageInfo.userNameParamPosition().get()].toString();
        }
        if (userMessageInfo.imageParamPosition().isPresent()) {
            Object imageParamValue = methodArgs[userMessageInfo.imageParamPosition().get()];
            if (imageParamValue instanceof String) {
                String s = (String)imageParamValue;
                imageContent = ImageContent.from((String)s);
            } else if (imageParamValue instanceof URI) {
                URI u = (URI)imageParamValue;
                imageContent = ImageContent.from((URI)u);
            } else if (imageParamValue instanceof URL) {
                URL u = (URL)imageParamValue;
                try {
                    imageContent = ImageContent.from((URI)u.toURI());
                }
                catch (URISyntaxException e) {
                    throw new RuntimeException(e);
                }
            } else if (imageParamValue instanceof Image) {
                Image i = (Image)imageParamValue;
                imageContent = ImageContent.from((Image)i);
            } else {
                throw new IllegalStateException("Unsupported parameter type '" + String.valueOf(imageParamValue.getClass()) + "' annotated with @ImageUrl. Offending AiService is '" + createInfo.getInterfaceName() + "#" + createInfo.getMethodName());
            }
        }
        if (userMessageInfo.template().isPresent()) {
            boolean hasResponseSchema;
            AiServiceMethodCreateInfo.TemplateInfo templateInfo = userMessageInfo.template().get();
            Map<String, Object> templateVariables = AiServiceMethodImplementationSupport.getTemplateVariables(methodArgs, userMessageInfo);
            String templateText = templateInfo.text().isPresent() ? templateInfo.text().get() : (String)methodArgs[templateInfo.methodParamPosition().get()];
            boolean bl = hasResponseSchema = createInfo.getResponseSchemaInfo().isInUserMessage().orElse(false) != false || ResponseSchemaUtil.hasResponseSchema(templateText);
            if (hasResponseSchema && !createInfo.getResponseSchemaInfo().enabled()) {
                throw new RuntimeException("The %s placeholder cannot be used if the property quarkus.langchain4j.response-schema is set to false. Found in: %s".formatted(ResponseSchemaUtil.placeholder(), createInfo.getInterfaceName()));
            }
            if (createInfo.getResponseSchemaInfo().enabled()) {
                if (!(createInfo.getResponseSchemaInfo().isInSystemMessage() || hasResponseSchema || supportsJsonSchema)) {
                    templateText = templateText.concat(ResponseSchemaUtil.placeholder());
                }
                templateVariables.put(ResponseSchemaUtil.templateParam(), createInfo.getResponseSchemaInfo().outputFormatInstructions());
            }
            Prompt prompt = PromptTemplate.from((String)templateText).apply(templateVariables);
            return AiServiceMethodImplementationSupport.createUserMessage(userName, imageContent, prompt.text());
        }
        if (userMessageInfo.paramPosition().isPresent()) {
            Integer paramIndex = userMessageInfo.paramPosition().get();
            Object argValue = methodArgs[paramIndex];
            if (argValue == null) {
                throw new IllegalArgumentException("Unable to construct UserMessage for class '" + context.aiServiceClass.getName() + "' because parameter with index " + paramIndex + " is null");
            }
            String text = AiServiceMethodImplementationSupport.toString(argValue);
            return AiServiceMethodImplementationSupport.createUserMessage(userName, imageContent, text.concat(supportsJsonSchema || !createInfo.getResponseSchemaInfo().enabled() ? "" : createInfo.getResponseSchemaInfo().outputFormatInstructions()));
        }
        throw new IllegalStateException("Unable to construct UserMessage for class '" + context.aiServiceClass.getName() + "'. Please contact the maintainers");
    }

    private static Map<String, Object> getTemplateVariables(Object[] methodArgs, AiServiceMethodCreateInfo.UserMessageInfo userMessageInfo) {
        HashMap<String, Object> variables = new HashMap<String, Object>();
        if (userMessageInfo.template().isPresent()) {
            AiServiceMethodCreateInfo.TemplateInfo templateInfo = userMessageInfo.template().get();
            Map<String, Integer> nameToParamPosition = templateInfo.nameToParamPosition();
            for (Map.Entry<String, Integer> entry : nameToParamPosition.entrySet()) {
                Object value = AiServiceMethodImplementationSupport.transformTemplateParamValue(methodArgs[entry.getValue()]);
                variables.put(entry.getKey(), value);
            }
        }
        return variables;
    }

    private static UserMessage createUserMessage(String name, ImageContent imageContent, String text) {
        if (name == null) {
            if (imageContent == null) {
                return UserMessage.userMessage((String)text);
            }
            return UserMessage.userMessage(List.of(TextContent.from((String)text), imageContent));
        }
        if (imageContent == null) {
            return UserMessage.userMessage((String)name, (String)text);
        }
        return UserMessage.userMessage((String)name, List.of(TextContent.from((String)text), imageContent));
    }

    private static Object transformTemplateParamValue(Object value) {
        if (value == null) {
            return "";
        }
        if (value.getClass().isArray()) {
            return Arrays.toString((Object[])value);
        }
        return value;
    }

    private static Object memoryId(AiServiceMethodCreateInfo createInfo, Object[] methodArgs, boolean hasChatMemoryProvider) {
        if (createInfo.getMemoryIdParamPosition().isPresent()) {
            return methodArgs[createInfo.getMemoryIdParamPosition().get()];
        }
        if (hasChatMemoryProvider) {
            for (DefaultMemoryIdProvider provider : DEFAULT_MEMORY_ID_PROVIDERS) {
                Object memoryId = provider.getMemoryId();
                if (memoryId == null) continue;
                String perServiceSuffix = "#" + createInfo.getInterfaceName() + "." + createInfo.getMethodName();
                return String.valueOf(memoryId) + perServiceSuffix;
            }
        }
        return "default";
    }

    private static String toString(Object arg) {
        if (arg.getClass().isArray()) {
            return AiServiceMethodImplementationSupport.arrayToString(arg);
        }
        if (arg.getClass().isAnnotationPresent(StructuredPrompt.class)) {
            return StructuredPromptProcessor.toPrompt((Object)arg).text();
        }
        return arg.toString();
    }

    private static String arrayToString(Object arg) {
        StringBuilder sb = new StringBuilder("[");
        int length = Array.getLength(arg);
        for (int i = 0; i < length; ++i) {
            sb.append(AiServiceMethodImplementationSupport.toString(Array.get(arg, i)));
            if (i >= length - 1) continue;
            sb.append(", ");
        }
        sb.append("]");
        return sb.toString();
    }

    private static int getMaxSequentialToolExecutions() {
        return ConfigProvider.getConfig().getOptionalValue("quarkus.langchain4j.ai-service.max-tool-executions", Integer.class).orElse(10);
    }

    private static /* synthetic */ Multi lambda$doImplement$4(AiServiceMethodCreateInfo methodCreateInfo, UserMessage actualUserMessage, CommittableChatMemory chatMemory, AugmentationResult actualAugmentationResult, Map templateVariables, Multi m) {
        return ResponseAugmenterSupport.apply(m, methodCreateInfo, new ResponseAugmenterParams(actualUserMessage, chatMemory, actualAugmentationResult, methodCreateInfo.getUserMessageTemplate(), Collections.unmodifiableMap(templateVariables)));
    }

    private static /* synthetic */ String lambda$doImplement$2(AiServiceMethodCreateInfo methodCreateInfo, CommittableChatMemory chatMemory, AugmentationResult actualAugmentationResult, Map templateVariables, String chunk) {
        OutputGuardrailResult result;
        try {
            result = GuardrailsSupport.invokeOutputGuardrailsForStream(methodCreateInfo, new OutputGuardrailParams(AiMessage.from((String)chunk), chatMemory, actualAugmentationResult, methodCreateInfo.getUserMessageTemplate(), Collections.unmodifiableMap(templateVariables)));
        }
        catch (Exception e) {
            throw new GuardrailException(e.getMessage(), e);
        }
        if (!result.isSuccess()) {
            if (!result.isRetry()) {
                throw new GuardrailException(result.toString(), result.getFirstFailureException());
            }
            if (result.getReprompt() != null) {
                chatMemory.add((ChatMessage)new UserMessage(result.getReprompt()));
                throw new GuardrailsSupport.GuardrailRetryException();
            }
            throw new GuardrailsSupport.GuardrailRetryException();
        }
        if (result.hasRewrittenResult()) {
            throw new GuardrailException("Attempting to rewrite the LLM output while streaming is not allowed");
        }
        return chunk;
    }

    private static /* synthetic */ Multi lambda$doImplement$0(AiServiceMethodCreateInfo methodCreateInfo, UserMessage actualUserMessage, CommittableChatMemory chatMemory, AugmentationResult actualAugmentationResult, Map templateVariables, Multi m) {
        return ResponseAugmenterSupport.apply(m, methodCreateInfo, new ResponseAugmenterParams(actualUserMessage, chatMemory, actualAugmentationResult, methodCreateInfo.getUserMessageTemplate(), Collections.unmodifiableMap(templateVariables)));
    }

    static {
        SERVICE_OUTPUT_PARSER = new QuarkusServiceOutputParser();
        Collection defaultMemoryIdProviders = ServiceHelper.loadFactories(DefaultMemoryIdProvider.class);
        if (defaultMemoryIdProviders.isEmpty()) {
            DEFAULT_MEMORY_ID_PROVIDERS = Collections.emptyList();
        } else {
            DEFAULT_MEMORY_ID_PROVIDERS = new ArrayList<DefaultMemoryIdProvider>(defaultMemoryIdProviders);
            DEFAULT_MEMORY_ID_PROVIDERS.sort(new Comparator<DefaultMemoryIdProvider>(){

                @Override
                public int compare(DefaultMemoryIdProvider o1, DefaultMemoryIdProvider o2) {
                    return Integer.compare(o1.priority(), o2.priority());
                }
            });
        }
    }

    public static class Input {
        final QuarkusAiServiceContext context;
        final AiServiceMethodCreateInfo createInfo;
        final Object[] methodArgs;

        public Input(QuarkusAiServiceContext context, AiServiceMethodCreateInfo createInfo, Object[] methodArgs) {
            this.context = context;
            this.createInfo = createInfo;
            this.methodArgs = methodArgs;
        }
    }

    private static class TokenStreamMulti
    extends AbstractMulti<String>
    implements Multi<String> {
        private final List<ChatMessage> messagesToSend;
        private final List<ToolSpecification> toolSpecifications;
        private final Map<String, ToolExecutor> toolsExecutors;
        private final List<Content> contents;
        private final QuarkusAiServiceContext context;
        private final Object memoryId;
        private final boolean switchToWorkerThreadForToolExecution;
        private final boolean isCallerRunningOnWorkerThread;

        public TokenStreamMulti(List<ChatMessage> messagesToSend, List<ToolSpecification> toolSpecifications, Map<String, ToolExecutor> toolExecutors, List<Content> contents, QuarkusAiServiceContext context, Object memoryId, boolean switchToWorkerThreadForToolExecution, boolean isCallerRunningOnWorkerThread) {
            this.messagesToSend = messagesToSend;
            this.toolSpecifications = toolSpecifications;
            this.toolsExecutors = toolExecutors;
            this.contents = contents;
            this.context = context;
            this.memoryId = memoryId;
            this.switchToWorkerThreadForToolExecution = switchToWorkerThreadForToolExecution;
            this.isCallerRunningOnWorkerThread = isCallerRunningOnWorkerThread;
        }

        public void subscribe(MultiSubscriber<? super String> subscriber) {
            UnicastProcessor processor = UnicastProcessor.create();
            processor.subscribe(subscriber);
            this.createTokenStream((UnicastProcessor<String>)processor);
        }

        private void createTokenStream(UnicastProcessor<String> processor) {
            Context ctxt = null;
            if (this.switchToWorkerThreadForToolExecution || this.isCallerRunningOnWorkerThread) {
                ctxt = VertxContext.getOrCreateDuplicatedContext();
            }
            QuarkusAiServiceTokenStream stream = new QuarkusAiServiceTokenStream(this.messagesToSend, this.toolSpecifications, this.toolsExecutors, this.contents, this.context, this.memoryId, ctxt, this.switchToWorkerThreadForToolExecution, this.isCallerRunningOnWorkerThread);
            final TokenStream tokenStream = stream.onNext(arg_0 -> processor.onNext(arg_0)).onComplete(message -> processor.onComplete()).onError(arg_0 -> processor.onError(arg_0));
            if (this.switchToWorkerThreadForToolExecution && Context.isOnEventLoopThread()) {
                ctxt.executeBlocking((Callable)new Callable<Void>(){
                    final /* synthetic */ TokenStreamMulti this$0;
                    {
                        this.this$0 = this$0;
                    }

                    @Override
                    public Void call() {
                        tokenStream.start();
                        return null;
                    }
                });
            } else {
                tokenStream.start();
            }
        }
    }

    public static interface Wrapper {
        public Object wrap(Input var1, Function<Input, Object> var2);
    }
}

