/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.langchain4j.runtime.aiservice;

import dev.langchain4j.data.message.ChatMessage;
import dev.langchain4j.data.message.SystemMessage;
import dev.langchain4j.memory.ChatMemory;
import io.quarkiverse.langchain4j.runtime.aiservice.CommittableChatMemory;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;

class DefaultCommittableChatMemory
implements CommittableChatMemory {
    private final ChatMemory delegate;
    private final List<ChatMessage> newMessages;

    public DefaultCommittableChatMemory(ChatMemory delegate) {
        this.delegate = delegate;
        this.newMessages = new ArrayList<ChatMessage>(delegate.messages());
    }

    public Object id() {
        return this.delegate.id();
    }

    public void add(ChatMessage message) {
        if (message instanceof SystemMessage) {
            Optional<SystemMessage> systemMessage = DefaultCommittableChatMemory.findSystemMessage(this.newMessages);
            if (systemMessage.isPresent()) {
                if (systemMessage.get().equals((Object)message)) {
                    return;
                }
                this.newMessages.remove(systemMessage.get());
            }
            this.newMessages.add(0, message);
        } else {
            this.newMessages.add(message);
        }
    }

    private static Optional<SystemMessage> findSystemMessage(List<ChatMessage> messages) {
        return messages.stream().filter(message -> message instanceof SystemMessage).map(message -> (SystemMessage)message).findAny();
    }

    public List<ChatMessage> messages() {
        return new ArrayList<ChatMessage>(this.newMessages);
    }

    public void clear() {
        this.newMessages.clear();
        this.delegate.clear();
    }

    @Override
    public void commit() {
        this.delegate.clear();
        for (ChatMessage newMessage : this.newMessages) {
            this.delegate.add(newMessage);
        }
    }
}

