/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.langchain4j.runtime.aiservice;

import io.opentelemetry.api.trace.Span;
import io.opentelemetry.api.trace.Tracer;
import io.opentelemetry.context.Scope;
import io.quarkiverse.langchain4j.runtime.aiservice.AiServiceMethodCreateInfo;
import io.quarkiverse.langchain4j.runtime.aiservice.AiServiceMethodImplementationSupport;
import jakarta.inject.Inject;
import java.util.Optional;
import java.util.function.Function;

public class SpanWrapper
implements AiServiceMethodImplementationSupport.Wrapper {
    private final Tracer tracer;

    @Inject
    public SpanWrapper(Tracer tracer) {
        this.tracer = tracer;
    }

    @Override
    public Object wrap(AiServiceMethodImplementationSupport.Input input, Function<AiServiceMethodImplementationSupport.Input, Object> fun) {
        Optional<AiServiceMethodCreateInfo.SpanInfo> spanInfoOpt = input.createInfo.getSpanInfo();
        if (spanInfoOpt.isEmpty()) {
            return fun.apply(input);
        }
        Span span = this.tracer.spanBuilder(spanInfoOpt.get().name()).startSpan();
        try {
            Object object;
            block12: {
                Scope scope = span.makeCurrent();
                try {
                    object = fun.apply(input);
                    if (scope == null) break block12;
                }
                catch (Throwable throwable) {
                    try {
                        if (scope != null) {
                            try {
                                scope.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (Throwable t) {
                        span.recordException(t);
                        throw t;
                    }
                }
                scope.close();
            }
            return object;
        }
        finally {
            span.end();
        }
    }
}

