/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.langchain4j;

import dev.langchain4j.model.image.ImageModel;
import dev.langchain4j.service.AiServiceContext;
import dev.langchain4j.service.AiServices;
import dev.langchain4j.service.IllegalConfigurationException;
import dev.langchain4j.spi.services.AiServicesFactory;
import io.quarkiverse.langchain4j.runtime.AiServicesRecorder;
import io.quarkiverse.langchain4j.runtime.ToolsRecorder;
import io.quarkiverse.langchain4j.runtime.aiservice.AiServiceClassCreateInfo;
import io.quarkiverse.langchain4j.runtime.aiservice.AiServiceMethodCreateInfo;
import io.quarkiverse.langchain4j.runtime.aiservice.ChatMemorySeeder;
import io.quarkiverse.langchain4j.runtime.aiservice.QuarkusAiServiceContext;
import java.util.Collection;

public class QuarkusAiServicesFactory
implements AiServicesFactory {
    public <T> QuarkusAiServices<T> create(AiServiceContext context) {
        if (context instanceof QuarkusAiServiceContext) {
            return new QuarkusAiServices(context);
        }
        return new QuarkusAiServices(new QuarkusAiServiceContext(context.aiServiceClass));
    }

    public static class QuarkusAiServices<T>
    extends AiServices<T> {
        public QuarkusAiServices(AiServiceContext context) {
            super(context);
        }

        public AiServices<T> tools(Collection<Object> objectsWithTools) {
            this.context.toolService.initTools();
            ToolsRecorder.populateToolMetadata(objectsWithTools, this.context.toolService.toolSpecifications(), this.context.toolService.toolExecutors());
            return this;
        }

        public AiServices<T> chatMemorySeeder(ChatMemorySeeder chatMemorySeeder) {
            this.quarkusAiServiceContext().chatMemorySeeder = chatMemorySeeder;
            return this;
        }

        public AiServices<T> imageModel(ImageModel imageModel) {
            this.quarkusAiServiceContext().imageModel = imageModel;
            return this;
        }

        public T build() {
            Class aiServiceClass = this.context.aiServiceClass;
            AiServiceClassCreateInfo classCreateInfo = AiServicesRecorder.getMetadata().get(aiServiceClass.getName());
            if (classCreateInfo == null) {
                throw new RuntimeException("Quarkus was not able to determine class '" + aiServiceClass.getName() + "' as an AiService at build time. Consider annotating the class with '@CreatedAware'");
            }
            this.performBasicValidation();
            Collection<AiServiceMethodCreateInfo> methodCreateInfos = classCreateInfo.methodMap().values();
            for (AiServiceMethodCreateInfo methodCreateInfo : methodCreateInfos) {
                if (!methodCreateInfo.isRequiresModeration() || this.context.moderationModel != null) continue;
                throw IllegalConfigurationException.illegalConfiguration((String)"The @Moderate annotation is present, but the moderationModel is not set up. Please ensure a valid moderationModel is configured before using the @Moderate annotation.");
            }
            try {
                return (T)Class.forName(classCreateInfo.implClassName(), true, Thread.currentThread().getContextClassLoader()).getConstructor(QuarkusAiServiceContext.class).newInstance(new Object[]{this.quarkusAiServiceContext()});
            }
            catch (Exception e) {
                throw new IllegalStateException("Unable to create class '" + classCreateInfo.implClassName(), e);
            }
        }

        private QuarkusAiServiceContext quarkusAiServiceContext() {
            return (QuarkusAiServiceContext)this.context;
        }
    }

    public static class InstanceHolder {
        public static final QuarkusAiServicesFactory INSTANCE = new QuarkusAiServicesFactory();
    }
}

