/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.langchain4j.guardrails;

import io.quarkiverse.langchain4j.guardrails.Guardrail;
import io.quarkiverse.langchain4j.guardrails.GuardrailResult;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;

public record InputGuardrailResult(GuardrailResult.Result result, String successfulText, List<Failure> failures) implements GuardrailResult<InputGuardrailResult>
{
    private static final InputGuardrailResult SUCCESS = new InputGuardrailResult();

    private InputGuardrailResult() {
        this(GuardrailResult.Result.SUCCESS, null, Collections.emptyList());
    }

    private InputGuardrailResult(String successfulText) {
        this(GuardrailResult.Result.SUCCESS_WITH_RESULT, successfulText, Collections.emptyList());
    }

    InputGuardrailResult(List<Failure> failures, boolean fatal) {
        this(fatal ? GuardrailResult.Result.FATAL : GuardrailResult.Result.FAILURE, null, failures);
    }

    public static InputGuardrailResult success() {
        return SUCCESS;
    }

    public static InputGuardrailResult successWith(String successfulText) {
        return new InputGuardrailResult(successfulText);
    }

    public static InputGuardrailResult failure(List<? extends GuardrailResult.Failure> failures) {
        return new InputGuardrailResult(failures, false);
    }

    @Override
    public GuardrailResult.Result getResult() {
        return this.result;
    }

    @Override
    public boolean isFatal() {
        return this.result == GuardrailResult.Result.FATAL;
    }

    @Override
    public InputGuardrailResult validatedBy(Class<? extends Guardrail> guardrailClass) {
        if (!this.isSuccess()) {
            if (this.failures.size() != 1) {
                throw new IllegalArgumentException();
            }
            this.failures.set(0, (Failure)this.failures.get(0).withGuardrailClass((Class)guardrailClass));
        }
        return this;
    }

    @Override
    public String toString() {
        if (this.isSuccess()) {
            return this.hasRewrittenResult() ? "Success with '" + this.successfulText + "'" : "Success";
        }
        return this.failures.stream().map(Failure::toString).collect(Collectors.joining(", "));
    }

    public record Failure(String message, Throwable cause, Class<? extends Guardrail> guardrailClass) implements GuardrailResult.Failure
    {
        public Failure(String message) {
            this(message, null);
        }

        public Failure(String message, Throwable cause) {
            this(message, cause, null);
        }

        @Override
        public Failure withGuardrailClass(Class<? extends Guardrail> guardrailClass) {
            return new Failure(this.message, this.cause, guardrailClass);
        }

        @Override
        public String toString() {
            return "The guardrail " + this.guardrailClass.getName() + " failed with this message: " + this.message;
        }
    }
}

