/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.langchain4j.guardrails;

import io.quarkiverse.langchain4j.guardrails.Guardrail;
import io.quarkiverse.langchain4j.guardrails.GuardrailResult;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;

public record OutputGuardrailResult(GuardrailResult.Result result, String successfulText, Object successfulResult, List<Failure> failures) implements GuardrailResult<OutputGuardrailResult>
{
    private static final OutputGuardrailResult SUCCESS = new OutputGuardrailResult();

    private OutputGuardrailResult() {
        this(GuardrailResult.Result.SUCCESS, null, null, Collections.emptyList());
    }

    private OutputGuardrailResult(String successfulText) {
        this(GuardrailResult.Result.SUCCESS_WITH_RESULT, successfulText, null, Collections.emptyList());
    }

    private OutputGuardrailResult(String successfulText, Object successfulResult) {
        this(GuardrailResult.Result.SUCCESS_WITH_RESULT, successfulText, successfulResult, Collections.emptyList());
    }

    OutputGuardrailResult(List<Failure> failures, boolean fatal) {
        this(fatal ? GuardrailResult.Result.FATAL : GuardrailResult.Result.FAILURE, null, null, failures);
    }

    public static OutputGuardrailResult success() {
        return SUCCESS;
    }

    public static OutputGuardrailResult successWith(String successfulText) {
        return new OutputGuardrailResult(successfulText);
    }

    public static OutputGuardrailResult successWith(String successfulText, Object successfulResult) {
        return new OutputGuardrailResult(successfulText, successfulResult);
    }

    public static OutputGuardrailResult failure(List<? extends GuardrailResult.Failure> failures) {
        return new OutputGuardrailResult(failures, false);
    }

    @Override
    public GuardrailResult.Result getResult() {
        return this.result;
    }

    public boolean isRetry() {
        return !this.isSuccess() && this.failures.stream().anyMatch(Failure::retry);
    }

    public OutputGuardrailResult blockRetry() {
        this.failures().set(0, this.failures().get(0).blockRetry());
        return this;
    }

    public String getReprompt() {
        if (!this.isSuccess()) {
            for (Failure failure : this.failures) {
                if (failure.reprompt() == null) continue;
                return failure.reprompt();
            }
        }
        return null;
    }

    @Override
    public boolean isFatal() {
        return this.result == GuardrailResult.Result.FATAL;
    }

    @Override
    public OutputGuardrailResult validatedBy(Class<? extends Guardrail> guardrailClass) {
        if (!this.isSuccess()) {
            if (this.failures.size() != 1) {
                throw new IllegalArgumentException();
            }
            this.failures.set(0, (Failure)this.failures.get(0).withGuardrailClass((Class)guardrailClass));
        }
        return this;
    }

    @Override
    public String toString() {
        if (this.isSuccess()) {
            return this.hasRewrittenResult() ? "Success with '" + this.successfulText + "'" : "Success";
        }
        return this.failures.stream().map(Failure::toString).collect(Collectors.joining(", "));
    }

    public record Failure(String message, Throwable cause, Class<? extends Guardrail> guardrailClass, boolean retry, String reprompt) implements GuardrailResult.Failure
    {
        public Failure(String message) {
            this(message, null);
        }

        public Failure(String message, Throwable cause) {
            this(message, cause, false);
        }

        public Failure(String message, Throwable cause, boolean retry) {
            this(message, cause, null, retry, null);
        }

        public Failure(String message, Throwable cause, boolean retry, String reprompt) {
            this(message, cause, null, retry, reprompt);
        }

        @Override
        public Failure withGuardrailClass(Class<? extends Guardrail> guardrailClass) {
            return new Failure(this.message(), this.cause(), guardrailClass, this.retry, this.reprompt);
        }

        public Failure blockRetry() {
            return this.retry ? new Failure("Retry or reprompt is not allowed after a rewritten output", this.cause(), this.guardrailClass, false, this.reprompt) : this;
        }

        @Override
        public String toString() {
            return "The guardrail " + this.guardrailClass.getName() + " failed with this message: " + this.message;
        }
    }
}

