/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.langchain4j.runtime;

import io.smallrye.common.constraint.Assert;
import io.smallrye.common.vertx.VertxContext;
import io.vertx.core.Context;
import io.vertx.core.Vertx;

public final class ContextLocals {
    private ContextLocals() {
    }

    public static <T> T get(String key) {
        Context current = ContextLocals.duplicatedContextOrNull();
        if (current == null) {
            return null;
        }
        return (T)current.getLocal(Assert.checkNotNullParam((String)"key", (Object)key));
    }

    public static <T> void put(String key, T value) {
        Context current = ContextLocals.duplicatedContextOrNull();
        if (current == null) {
            return;
        }
        current.putLocal(Assert.checkNotNullParam((String)"key", (Object)key), Assert.checkNotNullParam((String)"value", value));
    }

    public static boolean remove(String key) {
        Context current = ContextLocals.duplicatedContextOrNull();
        if (current == null) {
            return false;
        }
        return current.removeLocal(Assert.checkNotNullParam((String)"key", (Object)key));
    }

    public static boolean duplicatedContextActive() {
        return ContextLocals.duplicatedContextOrNull() != null;
    }

    private static Context duplicatedContextOrNull() {
        Context current = Vertx.currentContext();
        if (current == null || !VertxContext.isDuplicatedContext((Context)current)) {
            return null;
        }
        return current;
    }
}

