/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.langchain4j.runtime.template;

import dev.langchain4j.data.message.AiMessage;
import dev.langchain4j.data.message.ChatMessage;
import io.quarkus.qute.TemplateExtension;
import java.util.List;
import java.util.StringJoiner;

@TemplateExtension
public class ChatMessageTemplateExtension {
    static String extractDialogue(List<ChatMessage> chatMessages, String userPrefix, String assistantPrefix, String delimiter) {
        if (chatMessages == null || chatMessages.isEmpty()) {
            return "";
        }
        StringJoiner joiner = new StringJoiner(delimiter == null ? "\n" : delimiter);
        userPrefix = userPrefix == null ? "User: " : userPrefix;
        assistantPrefix = assistantPrefix == null ? "Assistant: " : assistantPrefix;
        block5: for (ChatMessage chatMessage : chatMessages) {
            switch (chatMessage.type()) {
                case AI: {
                    AiMessage aiMessage = (AiMessage)chatMessage;
                    if (aiMessage.hasToolExecutionRequests()) continue block5;
                    joiner.add("%s%s".formatted(assistantPrefix, aiMessage.text()));
                    break;
                }
                case USER: {
                    joiner.add("%s%s".formatted(userPrefix, chatMessage.text()));
                    break;
                }
                case SYSTEM: 
                case TOOL_EXECUTION_RESULT: 
                case CUSTOM: {
                    continue block5;
                }
                default: {
                    continue block5;
                }
            }
        }
        return joiner.toString();
    }

    static String extractDialogue(List<ChatMessage> chatMessages, String delimiter) {
        return ChatMessageTemplateExtension.extractDialogue(chatMessages, null, null, delimiter);
    }

    static String extractDialogue(List<ChatMessage> chatMessages) {
        return ChatMessageTemplateExtension.extractDialogue(chatMessages, null, null, null);
    }
}

