/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.langchain4j.runtime.types;

import dev.langchain4j.data.image.Image;
import dev.langchain4j.service.Result;
import dev.langchain4j.service.TokenStream;
import io.smallrye.mutiny.Multi;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;

public final class TypeUtil {
    private TypeUtil() {
    }

    public static boolean isTokenStream(Type returnType) {
        return TypeUtil.isTypeOf(returnType, TokenStream.class);
    }

    public static boolean isMulti(Type returnType) {
        return TypeUtil.isTypeOf(returnType, Multi.class);
    }

    public static boolean isResult(Type returnType) {
        return TypeUtil.isTypeOf(returnType, Result.class);
    }

    public static Type resultTypeParam(ParameterizedType returnType) {
        if (!TypeUtil.isTypeOf(returnType, Result.class)) {
            throw new IllegalStateException("Can only be called with Result<T> type");
        }
        return returnType.getActualTypeArguments()[0];
    }

    public static boolean isImage(Type returnType) {
        return TypeUtil.isTypeOf(returnType, Image.class);
    }

    public static boolean isResultImage(Type returnType) {
        if (!TypeUtil.isImage(returnType)) {
            return false;
        }
        return TypeUtil.isImage(TypeUtil.resultTypeParam((ParameterizedType)returnType));
    }

    public static boolean isTypeOf(Type type, Class<?> clazz) {
        if (type instanceof Class) {
            return type.equals(clazz);
        }
        if (type instanceof ParameterizedType) {
            ParameterizedType pt = (ParameterizedType)type;
            return TypeUtil.isTypeOf(pt.getRawType(), clazz);
        }
        throw new IllegalStateException("Unsupported return type " + String.valueOf(type));
    }
}

