/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.langchain4j.easyrag.runtime;

import dev.langchain4j.data.segment.TextSegment;
import dev.langchain4j.model.embedding.EmbeddingModel;
import dev.langchain4j.rag.RetrievalAugmentor;
import dev.langchain4j.store.embedding.EmbeddingStore;
import dev.langchain4j.store.embedding.inmemory.InMemoryEmbeddingStore;
import io.quarkiverse.langchain4j.easyrag.runtime.EasyRagConfig;
import io.quarkiverse.langchain4j.easyrag.runtime.EasyRagIngestor;
import io.quarkiverse.langchain4j.easyrag.runtime.EasyRetrievalAugmentor;
import io.quarkiverse.langchain4j.easyrag.runtime.IngestionStrategy;
import io.quarkus.arc.SyntheticCreationalContext;
import io.quarkus.arc.runtime.BeanContainer;
import io.quarkus.runtime.annotations.Recorder;
import jakarta.enterprise.inject.Default;
import java.lang.annotation.Annotation;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.function.Function;
import java.util.function.Supplier;
import org.jboss.logging.Logger;

@Recorder
public class EasyRagRecorder {
    private static final Logger LOGGER = Logger.getLogger(EasyRagRecorder.class);
    public static EasyRagConfig easyRagConfig;

    public void ingest(EasyRagConfig config, BeanContainer beanContainer) {
        easyRagConfig = config;
        if (config.ingestionStrategy() == IngestionStrategy.OFF) {
            LOGGER.info((Object)"Skipping document ingestion as per configuration");
            return;
        }
        if (config.ingestionStrategy() == IngestionStrategy.MANUAL) {
            LOGGER.info((Object)"Not ingesting documents for now because ingestion strategy is set to MANUAL");
            return;
        }
        EmbeddingStore embeddingStore = (EmbeddingStore)beanContainer.beanInstance(EmbeddingStore.class, new Annotation[0]);
        EmbeddingModel embeddingModel = (EmbeddingModel)beanContainer.beanInstance(EmbeddingModel.class, new Annotation[0]);
        new EasyRagIngestor(embeddingModel, (EmbeddingStore<TextSegment>)embeddingStore, config).ingest();
    }

    public Supplier<InMemoryEmbeddingStore<TextSegment>> inMemoryEmbeddingStoreSupplier(final EasyRagConfig config) {
        return new Supplier<InMemoryEmbeddingStore<TextSegment>>(){

            @Override
            public InMemoryEmbeddingStore<TextSegment> get() {
                Path embeddingsFile;
                if (config.ingestionStrategy() == IngestionStrategy.ON && config.reuseEmbeddings().enabled() && Files.isRegularFile(embeddingsFile = Path.of(config.reuseEmbeddings().file(), new String[0]).toAbsolutePath(), new LinkOption[0])) {
                    LOGGER.infof("Reading embeddings from %s", (Object)embeddingsFile);
                    return InMemoryEmbeddingStore.fromFile((Path)embeddingsFile);
                }
                return new InMemoryEmbeddingStore();
            }
        };
    }

    public Function<SyntheticCreationalContext<RetrievalAugmentor>, RetrievalAugmentor> easyRetrievalAugmentorFunction(final EasyRagConfig config) {
        return new Function<SyntheticCreationalContext<RetrievalAugmentor>, RetrievalAugmentor>(){

            @Override
            public RetrievalAugmentor apply(SyntheticCreationalContext<RetrievalAugmentor> context) {
                EmbeddingModel model = (EmbeddingModel)context.getInjectedReference(EmbeddingModel.class, new Annotation[]{Default.Literal.INSTANCE});
                EmbeddingStore store = (EmbeddingStore)context.getInjectedReference(EmbeddingStore.class, new Annotation[]{Default.Literal.INSTANCE});
                return new EasyRetrievalAugmentor(config.maxResults(), model, store);
            }
        };
    }
}

