/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.langchain4j.mistralai;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectReader;
import dev.langchain4j.model.mistralai.internal.api.MistralAiChatCompletionRequest;
import dev.langchain4j.model.mistralai.internal.api.MistralAiChatCompletionResponse;
import dev.langchain4j.model.mistralai.internal.api.MistralAiEmbeddingRequest;
import dev.langchain4j.model.mistralai.internal.api.MistralAiEmbeddingResponse;
import dev.langchain4j.model.mistralai.internal.api.MistralAiModelResponse;
import io.quarkiverse.langchain4j.QuarkusJsonCodecFactory;
import io.quarkus.rest.client.reactive.NotBody;
import io.smallrye.mutiny.Multi;
import jakarta.annotation.Priority;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.WebApplicationException;
import jakarta.ws.rs.core.MediaType;
import jakarta.ws.rs.core.MultivaluedMap;
import jakarta.ws.rs.ext.MessageBodyWriter;
import jakarta.ws.rs.ext.WriterInterceptor;
import jakarta.ws.rs.ext.WriterInterceptorContext;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.function.Predicate;
import org.eclipse.microprofile.rest.client.annotation.ClientHeaderParam;
import org.eclipse.microprofile.rest.client.annotation.RegisterProvider;
import org.eclipse.microprofile.rest.client.annotation.RegisterProviders;
import org.jboss.resteasy.reactive.RestStreamElementType;
import org.jboss.resteasy.reactive.client.SseEvent;
import org.jboss.resteasy.reactive.client.SseEventFilter;
import org.jboss.resteasy.reactive.common.providers.serialisers.AbstractJsonMessageBodyReader;

@Path(value="")
@ClientHeaderParam(name="Authorization", value={"Bearer {token}"})
@Consumes(value={"application/json"})
@Produces(value={"application/json"})
@RegisterProviders(value={@RegisterProvider(value=MistralAiRestApiJacksonReader.class), @RegisterProvider(value=MistralAiRestApiJacksonWriter.class), @RegisterProvider(value=MistralAiRestApiWriterInterceptor.class)})
public interface MistralAiRestApi {
    @Path(value="chat/completions")
    @POST
    public MistralAiChatCompletionResponse blockingChatCompletion(MistralAiChatCompletionRequest var1, @NotBody String var2);

    @Path(value="chat/completions")
    @POST
    @RestStreamElementType(value="application/json")
    @SseEventFilter(value=DoneFilter.class)
    public Multi<MistralAiChatCompletionResponse> streamingChatCompletion(MistralAiChatCompletionRequest var1, @NotBody String var2);

    @Path(value="embeddings")
    @POST
    public MistralAiEmbeddingResponse embedding(MistralAiEmbeddingRequest var1, @NotBody String var2);

    @Path(value="models")
    @GET
    public MistralAiModelResponse models(@NotBody String var1);

    public static class ObjectMapperHolder {
        public static final ObjectMapper MAPPER = QuarkusJsonCodecFactory.SnakeCaseObjectMapperHolder.MAPPER;
        private static final ObjectReader READER = MAPPER.reader();
    }

    @Priority(value=5100)
    public static class MistralAiRestApiJacksonWriter
    implements MessageBodyWriter<Object> {
        public boolean isWriteable(Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
            return true;
        }

        public void writeTo(Object o, Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, Object> httpHeaders, OutputStream entityStream) throws IOException, WebApplicationException {
            entityStream.write(ObjectMapperHolder.MAPPER.writeValueAsString(o).getBytes(StandardCharsets.UTF_8));
        }
    }

    @Priority(value=4900)
    public static class MistralAiRestApiJacksonReader
    extends AbstractJsonMessageBodyReader {
        public Object readFrom(Class<Object> type, Type genericType, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, String> httpHeaders, InputStream entityStream) throws IOException, WebApplicationException {
            return ObjectMapperHolder.READER.forType(ObjectMapperHolder.READER.getTypeFactory().constructType(genericType != null ? genericType : type)).readValue(entityStream);
        }
    }

    public static class DoneFilter
    implements Predicate<SseEvent<String>> {
        @Override
        public boolean test(SseEvent<String> event) {
            return !"[DONE]".equals(event.data());
        }
    }

    public static class MistralAiRestApiWriterInterceptor
    implements WriterInterceptor {
        public void aroundWriteTo(WriterInterceptorContext context) throws IOException, WebApplicationException {
            Object entity = context.getEntity();
            if (entity instanceof MistralAiChatCompletionRequest) {
                MistralAiChatCompletionRequest request = (MistralAiChatCompletionRequest)entity;
                MultivaluedMap headers = context.getHeaders();
                List acceptList = (List)headers.get((Object)"Accept");
                if (acceptList != null && acceptList.size() == 1) {
                    String accept = (String)acceptList.get(0);
                    if ("application/json".equals(accept)) {
                        if (Boolean.TRUE.equals(request.getStream())) {
                            context.setEntity((Object)this.from(request).stream(null).build());
                        }
                    } else if ("text/event-stream".equals(accept) && !Boolean.TRUE.equals(request.getStream())) {
                        context.setEntity((Object)this.from(request).stream(Boolean.valueOf(true)).build());
                    }
                }
            }
            context.proceed();
        }

        private MistralAiChatCompletionRequest.MistralAiChatCompletionRequestBuilder from(MistralAiChatCompletionRequest request) {
            MistralAiChatCompletionRequest.MistralAiChatCompletionRequestBuilder builder = MistralAiChatCompletionRequest.builder();
            builder.model(request.getModel());
            builder.messages(request.getMessages());
            builder.temperature(request.getTemperature());
            builder.topP(request.getTopP());
            builder.maxTokens(request.getMaxTokens());
            builder.stream(request.getStream());
            builder.safePrompt(request.getSafePrompt());
            builder.randomSeed(request.getRandomSeed());
            return builder;
        }
    }
}

