/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.qute.web.runtime;

import io.quarkiverse.qute.web.DataInitializer;
import io.quarkiverse.qute.web.runtime.ContentType;
import io.quarkiverse.qute.web.runtime.PathUtils;
import io.quarkus.arc.Arc;
import io.quarkus.arc.ArcContainer;
import io.quarkus.arc.InjectableContext;
import io.quarkus.arc.InstanceHandle;
import io.quarkus.arc.ManagedContext;
import io.quarkus.arc.impl.LazyValue;
import io.quarkus.qute.Template;
import io.quarkus.qute.TemplateInstance;
import io.quarkus.qute.Variant;
import io.quarkus.qute.runtime.QuteRecorder;
import io.quarkus.qute.runtime.TemplateProducer;
import io.quarkus.security.identity.CurrentIdentityAssociation;
import io.quarkus.security.identity.SecurityIdentity;
import io.quarkus.vertx.http.runtime.CurrentVertxRequest;
import io.quarkus.vertx.http.runtime.HttpBuildTimeConfig;
import io.quarkus.vertx.http.runtime.security.QuarkusHttpUser;
import io.vertx.core.AsyncResult;
import io.vertx.core.Handler;
import io.vertx.core.http.HttpHeaders;
import io.vertx.ext.web.MIMEHeader;
import io.vertx.ext.web.ParsedHeaderValue;
import io.vertx.ext.web.RoutingContext;
import jakarta.enterprise.event.Event;
import java.lang.annotation.Annotation;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import org.jboss.logging.Logger;

public class QuteWebHandler
implements Handler<RoutingContext> {
    private static final Logger LOG = Logger.getLogger(QuteWebHandler.class);
    private static final String FRAGMENT_PARAM = "frag";
    private final String rootPath;
    private final Set<String> templatePaths;
    private final String webTemplatesPath;
    private final List<String> compressMediaTypes;
    private final Map<String, String> extractedPaths;
    private final Event<SecurityIdentity> securityIdentityEvent;
    private final CurrentIdentityAssociation currentIdentity;
    private final CurrentVertxRequest currentVertxRequest;
    private final ManagedContext requestContext;
    private final LazyValue<TemplateProducer> templateProducer;
    private final QuteRecorder.QuteContext quteContext;
    private final Map<String, String> templateLinks;
    private final List<DataInitializer> dataInitializers;

    public QuteWebHandler(String rootPath, String publicDir, Set<String> templatePaths, Map<String, String> templateLinks, HttpBuildTimeConfig httpBuildTimeConfig) {
        this.rootPath = rootPath;
        this.templatePaths = templatePaths;
        this.webTemplatesPath = publicDir.equals("/") || publicDir.isBlank() ? "" : (publicDir.startsWith("/") ? publicDir.substring(1) : publicDir);
        this.templateLinks = templateLinks;
        this.compressMediaTypes = httpBuildTimeConfig.enableCompression ? httpBuildTimeConfig.compressMediaTypes.orElse(List.of()) : null;
        this.extractedPaths = new ConcurrentHashMap<String, String>();
        ArcContainer container = Arc.container();
        this.securityIdentityEvent = container.beanManager().getEvent().select(SecurityIdentity.class, new Annotation[0]);
        this.currentVertxRequest = (CurrentVertxRequest)container.instance(CurrentVertxRequest.class, new Annotation[0]).get();
        this.requestContext = container.requestContext();
        this.currentIdentity = (CurrentIdentityAssociation)container.instance(CurrentIdentityAssociation.class, new Annotation[0]).get();
        this.templateProducer = new LazyValue(() -> (TemplateProducer)Arc.container().instance(TemplateProducer.class, new Annotation[0]).get());
        this.quteContext = (QuteRecorder.QuteContext)Arc.container().instance(QuteRecorder.QuteContext.class, new Annotation[0]).get();
        this.dataInitializers = container.listAll(DataInitializer.class, new Annotation[0]).stream().map(InstanceHandle::get).toList();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handle(RoutingContext rc) {
        QuarkusHttpUser user = (QuarkusHttpUser)rc.user();
        if (this.requestContext.isActive()) {
            this.processCurrentIdentity(rc, user);
            this.handlePage(rc);
        } else {
            try {
                this.requestContext.activate();
                this.currentVertxRequest.setCurrent(rc);
                this.processCurrentIdentity(rc, user);
                final InjectableContext.ContextState endState = this.requestContext.getState();
                rc.addEndHandler((Handler)new Handler<AsyncResult<Void>>(){

                    public void handle(AsyncResult<Void> result) {
                        QuteWebHandler.this.requestContext.destroy(endState);
                    }
                });
                this.handlePage(rc);
            }
            finally {
                this.requestContext.deactivate();
            }
        }
    }

    private void processCurrentIdentity(RoutingContext rc, QuarkusHttpUser user) {
        if (this.currentIdentity != null) {
            if (user != null) {
                SecurityIdentity identity = user.getSecurityIdentity();
                this.currentIdentity.setIdentity(identity);
            } else {
                this.currentIdentity.setIdentity(QuarkusHttpUser.getSecurityIdentity((RoutingContext)rc, null));
            }
        }
        if (user != null) {
            this.securityIdentityEvent.fire((Object)user.getSecurityIdentity());
        }
    }

    private void handlePage(RoutingContext rc) {
        String requestPath = rc.request().path();
        LOG.debugf("Handle page: %s", (Object)requestPath);
        String path = this.extractedPaths.computeIfAbsent(requestPath, this::extractTemplatePath);
        if (path != null) {
            List acceptableTypes;
            Variant selected;
            TemplateInstance originalInstance;
            Template template = ((TemplateProducer)this.templateProducer.get()).getInjectableTemplate(path);
            TemplateInstance instance = originalInstance = template.instance();
            String fragmentId = rc.request().getParam(FRAGMENT_PARAM);
            if (fragmentId != null) {
                Template.Fragment fragment = originalInstance.getTemplate().getFragment(fragmentId);
                if (fragment == null) {
                    LOG.errorf("Fragment [%s] not found: %s", (Object)fragmentId, (Object)rc.request().path());
                    rc.response().setStatusCode(404).end();
                    return;
                }
                instance = fragment.instance();
            }
            if ((selected = this.trySelectVariant(rc, originalInstance, acceptableTypes = rc.parsedHeaders().accept())) != null) {
                String contentEncoding;
                instance.setAttribute("selectedVariant", (Object)selected);
                rc.response().putHeader(HttpHeaders.CONTENT_TYPE, (CharSequence)selected.getContentType());
                if (this.compressMediaTypes != null && this.compressMediaTypes.contains(selected.getContentType()) && (contentEncoding = rc.response().headers().get(HttpHeaders.CONTENT_ENCODING)) != null && HttpHeaders.IDENTITY.toString().equals(contentEncoding)) {
                    rc.response().headers().remove(HttpHeaders.CONTENT_ENCODING);
                }
            }
            if (selected == null && !acceptableTypes.isEmpty()) {
                LOG.errorf("Appropriate template variant not found %s: %s", acceptableTypes.stream().map(ParsedHeaderValue::rawValue).collect(Collectors.toList()), (Object)rc.request().path());
                rc.response().setStatusCode(406).end();
            } else {
                if (!this.dataInitializers.isEmpty()) {
                    DataInitializer.InitContext ctx = new DataInitializer.InitContext(path, instance, rc.request());
                    for (DataInitializer initializer : this.dataInitializers) {
                        try {
                            initializer.initialize(ctx);
                        }
                        catch (Exception e) {
                            LOG.errorf((Throwable)e, "Error initializing page [%s] with %s", (Object)path, (Object)initializer.getClass().getName());
                        }
                    }
                }
                instance.renderAsync().whenComplete((r, t) -> {
                    if (t != null) {
                        Throwable rootCause = this.rootCause((Throwable)t);
                        LOG.errorf("Error occured while rendering the template [%s]: %s", (Object)path, (Object)rootCause.toString());
                        rc.fail(rootCause);
                    } else {
                        rc.response().setStatusCode(200).end(r);
                    }
                });
            }
        } else {
            LOG.debugf("Template page not found: %s", (Object)rc.request().path());
            rc.next();
        }
    }

    private Throwable rootCause(Throwable t) {
        Throwable root = t;
        while (root.getCause() != null) {
            root = root.getCause();
        }
        return root;
    }

    private Variant trySelectVariant(RoutingContext rc, TemplateInstance instance, List<MIMEHeader> acceptableTypes) {
        Object variantsAttr = instance.getAttribute("variants");
        if (variantsAttr != null) {
            List variants = (List)variantsAttr;
            if (!acceptableTypes.isEmpty()) {
                for (MIMEHeader accept : acceptableTypes) {
                    accept.value();
                    for (Variant variant : variants) {
                        if (!new ContentType(variant.getContentType()).matches(accept.component(), accept.subComponent())) continue;
                        return variant;
                    }
                }
            }
        }
        return null;
    }

    private String extractTemplatePath(String path) {
        if (((String)path).length() >= this.rootPath.length()) {
            path = ((String)path).substring(this.rootPath.length());
            String link = this.templateLinks.get(PathUtils.removeTrailingSlash((String)(path = PathUtils.removeLeadingSlash((String)path))));
            if (link != null) {
                path = link;
            } else {
                if (((String)path).isEmpty()) {
                    path = "index";
                } else if (((String)path).endsWith("/")) {
                    path = (String)path + "index";
                }
                if (!this.webTemplatesPath.isEmpty()) {
                    path = this.webTemplatesPath + "/" + (String)path;
                }
                if (!this.templatePaths.contains(path)) {
                    return null;
                }
            }
            return this.pathFromVariant((String)path);
        }
        return null;
    }

    private String pathFromVariant(String path) {
        if (path.contains(".")) {
            for (Map.Entry e : this.quteContext.getVariants().entrySet()) {
                if (!((List)e.getValue()).contains(path)) continue;
                return (String)e.getKey();
            }
        }
        return path;
    }
}

