/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.qute.web.deployment.devui;

import io.quarkiverse.qute.web.deployment.QuteWebTemplateBuildItem;
import io.quarkiverse.qute.web.runtime.PathUtils;
import io.quarkiverse.qute.web.runtime.QuteWebBuildTimeConfig;
import io.quarkus.builder.item.BuildItem;
import io.quarkus.deployment.IsDevelopment;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.devui.spi.page.CardPageBuildItem;
import io.quarkus.devui.spi.page.Page;
import io.quarkus.devui.spi.page.PageBuilder;
import io.quarkus.devui.spi.page.WebComponentPageBuilder;
import io.quarkus.vertx.http.deployment.HttpRootPathBuildItem;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import java.util.Comparator;
import java.util.List;

public class QuteWebDevUIProcessor {
    @BuildStep(onlyIf={IsDevelopment.class})
    public void pages(List<QuteWebTemplateBuildItem> templatePaths, HttpRootPathBuildItem httpRootPath, QuteWebBuildTimeConfig config, BuildProducer<CardPageBuildItem> cardPages) {
        CardPageBuildItem pageBuildItem = new CardPageBuildItem();
        String publicDir = config.publicDir();
        JsonArray paths = new JsonArray();
        for (QuteWebTemplateBuildItem item : templatePaths.stream().sorted(Comparator.comparing(p -> p.templatePath().toLowerCase())).toList()) {
            String link = item.link() == null ? PathUtils.removeLeadingSlash((String)item.templatePath().replace(publicDir, "")) : item.link();
            link = PathUtils.join((String)httpRootPath.relativePath(config.rootPath()), (String)link);
            paths.add((Object)new JsonObject().put("templateId", (Object)item.templatePath()).put("link", (Object)link));
        }
        pageBuildItem.addBuildTimeData("paths", (Object)paths);
        pageBuildItem.addPage((PageBuilder)((WebComponentPageBuilder)((WebComponentPageBuilder)Page.webComponentPageBuilder().title("Pages")).icon("font-awesome-solid:file-code")).componentLink("qwc-qsp-paths.js").staticLabel(String.valueOf(paths.size())));
        cardPages.produce((BuildItem)pageBuildItem);
    }
}

