/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.qute;

import io.quarkus.qute.EvalContext;
import io.quarkus.qute.Resolver;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.function.Function;

public interface NamespaceResolver
extends Resolver {
    public static Builder builder(String namespace) {
        return new Builder(namespace);
    }

    public String getNamespace();

    public static final class Builder {
        private final String namespace;
        private Function<EvalContext, CompletionStage<Object>> resolve;

        Builder(String namespace) {
            this.namespace = namespace;
        }

        public Builder resolve(Function<EvalContext, Object> func) {
            this.resolve = ctx -> CompletableFuture.completedFuture(func.apply((EvalContext)ctx));
            return this;
        }

        public Builder resolveAsync(Function<EvalContext, CompletionStage<Object>> func) {
            this.resolve = func;
            return this;
        }

        public NamespaceResolver build() {
            Objects.requireNonNull(this.resolve);
            return new NamespaceResolver(){

                @Override
                public CompletionStage<Object> resolve(EvalContext context) {
                    return (CompletionStage)resolve.apply(context);
                }

                @Override
                public String getNamespace() {
                    return namespace;
                }
            };
        }
    }
}

