/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.qute;

import io.quarkus.qute.ExpressionNode;
import io.quarkus.qute.ResultMapper;
import io.quarkus.qute.ResultNode;
import java.util.function.Consumer;

public class SingleResultNode
implements ResultNode {
    private final Object value;
    private final ExpressionNode expressionNode;

    public SingleResultNode(Object value, ExpressionNode expressionNode) {
        this.value = value;
        this.expressionNode = expressionNode.getEngine().getResultMappers().isEmpty() ? null : expressionNode;
    }

    @Override
    public void process(Consumer<String> consumer) {
        if (this.value != null) {
            String result = null;
            if (this.expressionNode != null) {
                for (ResultMapper mapper : this.expressionNode.getEngine().getResultMappers()) {
                    if (!mapper.appliesTo(this.expressionNode.expression.getOrigin(), this.value)) continue;
                    result = mapper.map(this.value, this.expressionNode.expression);
                    break;
                }
            }
            if (result == null) {
                result = this.value.toString();
            }
            consumer.accept(result);
        }
    }
}

