/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.qute;

import io.quarkus.qute.Booleans;
import io.quarkus.qute.Expression;
import io.quarkus.qute.ImmutableList;
import io.quarkus.qute.Parser;
import io.quarkus.qute.ResultNode;
import io.quarkus.qute.Results;
import io.quarkus.qute.Scope;
import io.quarkus.qute.SectionBlock;
import io.quarkus.qute.SectionHelper;
import io.quarkus.qute.SectionHelperFactory;
import io.quarkus.qute.TemplateException;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;

public class IfSectionHelper
implements SectionHelper {
    private static final String ELSE = "else";
    private static final String IF = "if";
    private static final String LOGICAL_COMPLEMENT = "!";
    private final List<IfBlock> blocks;

    IfSectionHelper(SectionHelperFactory.SectionInitContext context) {
        ImmutableList.Builder<IfBlock> builder = ImmutableList.builder();
        for (SectionBlock part : context.getBlocks()) {
            if (!"$main".equals(part.label) && !ELSE.equals(part.label)) continue;
            builder.add(new IfBlock(part, context));
        }
        this.blocks = builder.build();
    }

    @Override
    public CompletionStage<ResultNode> resolve(SectionHelper.SectionResolutionContext context) {
        if (this.blocks.size() == 1) {
            IfBlock block = this.blocks.get(0);
            return block.condition.evaluate(context).thenCompose(r -> {
                if (Booleans.isFalsy(r)) {
                    return ResultNode.NOOP;
                }
                return context.execute(block.block, context.resolutionContext());
            });
        }
        return this.resolveBlocks(context, this.blocks.iterator());
    }

    private CompletionStage<ResultNode> resolveBlocks(SectionHelper.SectionResolutionContext context, Iterator<IfBlock> blocks) {
        IfBlock block = blocks.next();
        if (block.condition.isEmpty()) {
            return context.execute(block.block, context.resolutionContext());
        }
        return block.condition.evaluate(context).thenCompose(r -> {
            if (Booleans.isFalsy(r)) {
                if (blocks.hasNext()) {
                    return this.resolveBlocks(context, blocks);
                }
                return ResultNode.NOOP;
            }
            return context.execute(block.block, context.resolutionContext());
        });
    }

    static List<Object> parseParams(List<Object> params, SectionHelperFactory.ParserDelegate parserDelegate) {
        IfSectionHelper.replaceOperatorsAndCompositeParams(params, parserDelegate);
        int highestPrecedence = IfSectionHelper.getHighestPrecedence(params);
        if (!IfSectionHelper.isGroupingNeeded(params)) {
            return params;
        }
        ArrayList<Object> highestGroup = null;
        ArrayList<Object> ret = new ArrayList<Object>();
        int lastGroupdIdx = 0;
        ListIterator<Object> iterator = params.listIterator();
        while (iterator.hasNext()) {
            int prevIdx = iterator.previousIndex();
            Object param = iterator.next();
            if (param instanceof Operator) {
                Operator op = (Operator)((Object)param);
                if (op.precedence == highestPrecedence) {
                    if (highestGroup == null) {
                        highestGroup = new ArrayList<Object>();
                        if (op.isBinary()) {
                            highestGroup.add(params.get(prevIdx));
                        }
                    }
                    highestGroup.add(param);
                    if (prevIdx <= lastGroupdIdx) continue;
                    int from = lastGroupdIdx > 0 ? lastGroupdIdx + 1 : 0;
                    int to = op.isBinary() ? prevIdx : prevIdx + 1;
                    params.subList(from, to).forEach(ret::add);
                    continue;
                }
                if (op.precedence < highestPrecedence) {
                    if (highestGroup == null) continue;
                    ret.add(highestGroup);
                    lastGroupdIdx = prevIdx;
                    highestGroup = null;
                    continue;
                }
                throw new IllegalStateException();
            }
            if (highestGroup == null) continue;
            highestGroup.add(param);
        }
        if (highestGroup != null) {
            ret.add(highestGroup);
        } else if (lastGroupdIdx + 1 != params.size()) {
            params.subList(lastGroupdIdx + 1, params.size()).forEach(ret::add);
        }
        return IfSectionHelper.parseParams(ret, parserDelegate);
    }

    private static boolean isGroupingNeeded(List<Object> params) {
        return params.stream().filter(p -> p instanceof Operator).map(p -> ((Operator)((Object)((Object)p))).getPrecedence()).distinct().count() > 1L;
    }

    private static void replaceOperatorsAndCompositeParams(List<Object> params, SectionHelperFactory.ParserDelegate parserDelegate) {
        ListIterator<Object> iterator = params.listIterator();
        while (iterator.hasNext()) {
            Object param = iterator.next();
            if (!(param instanceof String)) continue;
            String stringParam = param.toString();
            Operator operator = Operator.from(stringParam);
            if (operator != null) {
                if (operator.isBinary() && !iterator.hasNext()) {
                    throw parserDelegate.createParserError("binary operator [" + operator + "] set but the second operand not present for {#if} section");
                }
                iterator.set((Object)operator);
                continue;
            }
            if (stringParam.length() > 1 && stringParam.startsWith(LOGICAL_COMPLEMENT)) {
                iterator.set((Object)Operator.NOT);
                stringParam = stringParam.substring(1);
                if (stringParam.charAt(0) == '(') {
                    iterator.add(IfSectionHelper.processCompositeParam(stringParam, parserDelegate));
                    continue;
                }
                iterator.add(stringParam);
                continue;
            }
            if (stringParam.charAt(0) != '(') continue;
            iterator.set(IfSectionHelper.processCompositeParam(stringParam, parserDelegate));
        }
    }

    private static int getHighestPrecedence(List<Object> params) {
        int highestPrecedence = 0;
        for (Object param : params) {
            if (!(param instanceof Operator)) continue;
            Operator op = (Operator)((Object)param);
            if (op.precedence <= highestPrecedence) continue;
            highestPrecedence = op.precedence;
        }
        return highestPrecedence;
    }

    static List<Object> processCompositeParam(String stringParam, SectionHelperFactory.ParserDelegate parserDelegate) {
        if (!stringParam.endsWith(")")) {
            throw new TemplateException("Invalid composite parameter found: " + stringParam);
        }
        ArrayList<Object> split = new ArrayList<Object>();
        Parser.splitSectionParams(stringParam.substring(1, stringParam.length() - 1), TemplateException::new).forEachRemaining(split::add);
        return IfSectionHelper.parseParams(split, parserDelegate);
    }

    static Condition createCondition(Object param, SectionBlock block, Operator operator, SectionHelperFactory.SectionInitContext context) {
        Condition condition;
        if (param instanceof String) {
            Expression expr;
            String stringParam = param.toString();
            boolean logicalComplement = stringParam.startsWith(LOGICAL_COMPLEMENT);
            if (logicalComplement) {
                stringParam = stringParam.substring(1);
            }
            if ((expr = block.expressions.get(stringParam)) == null) {
                throw new TemplateException("Expression not found for param [" + stringParam + "]: " + block);
            }
            condition = new OperandCondition(operator, expr);
        } else if (param instanceof List) {
            List params = (List)param;
            if (params.size() == 1) {
                return IfSectionHelper.createCondition(params.get(0), block, operator, context);
            }
            ArrayList<Condition> conditions = new ArrayList<Condition>();
            Operator nextOperator = null;
            for (Object p : params) {
                if (p instanceof Operator) {
                    nextOperator = (Operator)((Object)p);
                    continue;
                }
                conditions.add(IfSectionHelper.createCondition(p, block, nextOperator, context));
                nextOperator = null;
            }
            condition = new CompositeCondition(operator, ImmutableList.copyOf(conditions));
        } else {
            throw new TemplateException("Unsupported param type: " + param);
        }
        return condition;
    }

    static enum Operator {
        EQ(2, "eq", "==", "is"),
        NE(2, "ne", "!="),
        GT(3, "gt", ">"),
        GE(3, "ge", ">="),
        LE(3, "le", "<="),
        LT(3, "lt", "<"),
        AND(1, "and", "&&"),
        OR(1, "or", "||"),
        NOT(4, "!");

        private final List<String> aliases;
        private final int precedence;

        private Operator(int precedence, String ... aliases) {
            this.aliases = Arrays.asList(aliases);
            this.precedence = precedence;
        }

        int getPrecedence() {
            return this.precedence;
        }

        boolean evaluate(Object op1, Object op2) {
            switch (this) {
                case EQ: {
                    return Objects.equals(op1, op2);
                }
                case NE: {
                    return !Objects.equals(op1, op2);
                }
                case GE: 
                case GT: 
                case LE: 
                case LT: {
                    return this.compare(op1, op2);
                }
                case AND: 
                case OR: {
                    return !Booleans.isFalsy(op2);
                }
            }
            throw new TemplateException("Not a binary operator: " + this);
        }

        boolean compare(Object op1, Object op2) {
            Comparable<BigDecimal> c2;
            Comparable<BigDecimal> c1;
            if (op1 == null || op2 == null) {
                throw new TemplateException("Unable to compare null operands [op1=" + op1 + ", op2=" + op2 + "]");
            }
            if (op1 instanceof Comparable && op1.getClass().equals(op2.getClass())) {
                c1 = (Comparable)op1;
                c2 = (Comparable)op2;
            } else {
                c1 = Operator.getDecimal(op1);
                c2 = Operator.getDecimal(op2);
            }
            int result = c1.compareTo((BigDecimal)c2);
            switch (this) {
                case GE: {
                    return result >= 0;
                }
                case GT: {
                    return result > 0;
                }
                case LE: {
                    return result <= 0;
                }
                case LT: {
                    return result < 0;
                }
            }
            return false;
        }

        Boolean evaluate(Object op1) {
            switch (this) {
                case AND: {
                    return Booleans.isFalsy(op1) ? Boolean.FALSE : null;
                }
                case OR: {
                    return Booleans.isFalsy(op1) ? null : Boolean.TRUE;
                }
            }
            throw new TemplateException("Not a short-circuiting operator: " + this);
        }

        boolean isShortCircuiting() {
            return AND.equals((Object)this) || OR.equals((Object)this);
        }

        boolean isBinary() {
            return !NOT.equals((Object)this);
        }

        static Operator from(String value) {
            if (value == null || value.isEmpty()) {
                return null;
            }
            for (Operator operator : Operator.values()) {
                if (!operator.aliases.contains(value)) continue;
                return operator;
            }
            return null;
        }

        static BigDecimal getDecimal(Object value) {
            BigDecimal decimal;
            if (value instanceof BigDecimal) {
                decimal = (BigDecimal)value;
            } else if (value instanceof BigInteger) {
                decimal = new BigDecimal((BigInteger)value);
            } else if (value instanceof Long) {
                decimal = new BigDecimal((Long)value);
            } else if (value instanceof Integer) {
                decimal = new BigDecimal((Integer)value);
            } else if (value instanceof Double) {
                decimal = new BigDecimal((Double)value);
            } else if (value instanceof Float) {
                decimal = new BigDecimal(((Float)value).floatValue());
            } else if (value instanceof String) {
                decimal = new BigDecimal(value.toString());
            } else {
                throw new TemplateException("Not a valid number: " + value);
            }
            return decimal;
        }
    }

    static class CompositeCondition
    implements Condition {
        final List<Condition> conditions;
        final Operator operator;

        public CompositeCondition(Operator operator, List<Condition> conditions) {
            this.operator = operator;
            this.conditions = conditions;
        }

        @Override
        public CompletionStage<Object> evaluate(SectionHelper.SectionResolutionContext context) {
            return CompositeCondition.evaluateNext(context, null, this.conditions.iterator());
        }

        static CompletionStage<Object> evaluateNext(SectionHelper.SectionResolutionContext context, Object value, Iterator<Condition> iter) {
            CompletableFuture<Object> result = new CompletableFuture<Object>();
            Condition next = iter.next();
            Boolean shortResult = null;
            Operator operator = next.getOperator();
            if (operator != null && operator.isShortCircuiting()) {
                shortResult = operator.evaluate(value);
            }
            if (shortResult != null) {
                result.complete(shortResult);
            } else {
                Object literalVal = next.getLiteralValue();
                if (literalVal != null) {
                    CompositeCondition.processConditionValue(context, next, operator, value, literalVal, result, iter);
                } else {
                    next.evaluate(context).whenComplete((r, t) -> {
                        if (t != null) {
                            result.completeExceptionally((Throwable)t);
                        } else {
                            CompositeCondition.processConditionValue(context, next, operator, value, r, result, iter);
                        }
                    });
                }
            }
            return result;
        }

        @Override
        public Operator getOperator() {
            return this.operator;
        }

        @Override
        public boolean isEmpty() {
            return this.conditions.isEmpty();
        }

        public String toString() {
            return "CompositeCondition [conditions=" + this.conditions.size() + ", operator=" + this.operator + "]";
        }

        static void processConditionValue(SectionHelper.SectionResolutionContext context, Condition condition, Operator operator, Object previousValue, Object conditionValue, CompletableFuture<Object> result, Iterator<Condition> iter) {
            Object val;
            if (condition.isLogicalComplement()) {
                Object object = conditionValue = Booleans.isFalsy(conditionValue) ? Boolean.TRUE : Boolean.FALSE;
            }
            if (operator == null || !operator.isBinary()) {
                val = conditionValue;
            } else {
                try {
                    Object localValue;
                    if (Results.isNotFound(conditionValue)) {
                        conditionValue = null;
                    }
                    if (Results.isNotFound(localValue = previousValue)) {
                        localValue = null;
                    }
                    val = operator.evaluate(localValue, conditionValue);
                }
                catch (Throwable e) {
                    result.completeExceptionally(e);
                    throw e;
                }
            }
            if (!iter.hasNext()) {
                result.complete(val);
            } else {
                CompositeCondition.evaluateNext(context, val, iter).whenComplete((r2, t2) -> {
                    if (t2 != null) {
                        result.completeExceptionally((Throwable)t2);
                    } else {
                        result.complete(r2);
                    }
                });
            }
        }
    }

    static class OperandCondition
    implements Condition {
        final Operator operator;
        final Expression expression;
        final Object literalValue;

        OperandCondition(Operator operator, Expression expression) {
            this.operator = operator;
            this.expression = expression;
            this.literalValue = expression.getLiteral();
        }

        @Override
        public CompletionStage<Object> evaluate(SectionHelper.SectionResolutionContext context) {
            return context.resolutionContext().evaluate(this.expression);
        }

        @Override
        public Operator getOperator() {
            return this.operator;
        }

        @Override
        public Object getLiteralValue() {
            return this.literalValue;
        }

        public String toString() {
            return "OperandCondition [operator=" + this.operator + ", expression=" + this.expression.toOriginalString() + "]";
        }
    }

    static interface Condition {
        public CompletionStage<Object> evaluate(SectionHelper.SectionResolutionContext var1);

        public Operator getOperator();

        default public boolean isLogicalComplement() {
            return Operator.NOT.equals((Object)this.getOperator());
        }

        default public boolean isEmpty() {
            return false;
        }

        default public Object getLiteralValue() {
            return null;
        }
    }

    static class IfBlock {
        final SectionBlock block;
        final Condition condition;

        public IfBlock(SectionBlock block, SectionHelperFactory.SectionInitContext context) {
            this.block = block;
            List<Object> params = IfSectionHelper.parseParams(new ArrayList<Object>(block.parameters.values()), context);
            if (!params.isEmpty() && !"$main".equals(block.label)) {
                params = params.subList(1, params.size());
            }
            this.condition = IfSectionHelper.createCondition(params, block, null, context);
        }
    }

    public static class Factory
    implements SectionHelperFactory<IfSectionHelper> {
        @Override
        public List<String> getDefaultAliases() {
            return ImmutableList.of(IfSectionHelper.IF);
        }

        @Override
        public SectionHelperFactory.ParametersInfo getParameters() {
            return SectionHelperFactory.ParametersInfo.builder().checkNumberOfParams(false).addParameter("condition").build();
        }

        @Override
        public List<String> getBlockLabels() {
            return ImmutableList.of(IfSectionHelper.ELSE);
        }

        @Override
        public IfSectionHelper initialize(SectionHelperFactory.SectionInitContext context) {
            return new IfSectionHelper(context);
        }

        @Override
        public Scope initializeBlock(Scope previousScope, SectionHelperFactory.BlockInfo block) {
            List<Object> params = null;
            if ("$main".equals(block.getLabel())) {
                params = IfSectionHelper.parseParams(new ArrayList<Object>(block.getParameters().values()), block);
            } else if (IfSectionHelper.ELSE.equals(block.getLabel()) && !(params = IfSectionHelper.parseParams(new ArrayList<Object>(block.getParameters().values()), block)).isEmpty()) {
                params.remove(0);
            }
            this.addExpressions(params, block);
            return previousScope;
        }

        private void addExpressions(List<Object> params, SectionHelperFactory.BlockInfo block) {
            if (params != null && !params.isEmpty()) {
                for (Object param : params) {
                    if (param instanceof String) {
                        block.addExpression(param.toString(), param.toString());
                        continue;
                    }
                    if (!(param instanceof List)) continue;
                    this.addExpressions((List)param, block);
                }
            }
        }
    }
}

