/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.qute;

import io.quarkus.qute.Expression;
import io.quarkus.qute.Futures;
import io.quarkus.qute.ImmutableList;
import io.quarkus.qute.Mapper;
import io.quarkus.qute.ResultNode;
import io.quarkus.qute.Results;
import io.quarkus.qute.Scope;
import io.quarkus.qute.SectionHelper;
import io.quarkus.qute.SectionHelperFactory;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;

public class SetSectionHelper
implements SectionHelper {
    private static final String SET = "set";
    private static final String LET = "let";
    private final Map<String, Expression> parameters;
    private final Map<String, Expression> defaultKeys;
    private final Map<String, Expression> overridingKeys;

    SetSectionHelper(Map<String, Expression> parameters, Map<String, Expression> keys) {
        this.parameters = parameters;
        if (keys != null) {
            this.defaultKeys = keys;
            this.overridingKeys = new HashMap<String, Expression>(parameters);
            this.overridingKeys.keySet().removeAll(this.defaultKeys.keySet());
        } else {
            this.defaultKeys = Collections.emptyMap();
            this.overridingKeys = null;
        }
    }

    @Override
    public CompletionStage<ResultNode> resolve(SectionHelper.SectionResolutionContext context) {
        CompletableFuture<ResultNode> result = new CompletableFuture<ResultNode>();
        if (this.defaultKeys.isEmpty()) {
            Futures.evaluateParams(this.parameters, context.resolutionContext()).whenComplete((r, t) -> {
                if (t != null) {
                    result.completeExceptionally((Throwable)t);
                } else {
                    context.execute(context.resolutionContext().createChild(Mapper.wrap(r), null)).whenComplete((r2, t2) -> {
                        if (t2 != null) {
                            result.completeExceptionally((Throwable)t2);
                        } else {
                            result.complete((ResultNode)r2);
                        }
                    });
                }
            });
        } else {
            Futures.evaluateParams(this.defaultKeys, context.resolutionContext()).whenComplete((r, t) -> {
                if (t != null) {
                    result.completeExceptionally((Throwable)t);
                } else {
                    HashMap<String, Expression> toEval = new HashMap<String, Expression>();
                    for (Map.Entry e : r.entrySet()) {
                        if (e.getValue() != null && !Results.isNotFound(e.getValue())) continue;
                        toEval.put((String)e.getKey(), this.parameters.get(e.getKey()));
                    }
                    toEval.putAll(this.overridingKeys);
                    if (toEval.isEmpty()) {
                        context.execute(context.resolutionContext()).whenComplete((r2, t2) -> {
                            if (t2 != null) {
                                result.completeExceptionally((Throwable)t2);
                            } else {
                                result.complete((ResultNode)r2);
                            }
                        });
                    } else {
                        Futures.evaluateParams(toEval, context.resolutionContext()).whenComplete((r2, t2) -> {
                            if (t2 != null) {
                                result.completeExceptionally((Throwable)t2);
                            } else {
                                context.execute(context.resolutionContext().createChild(Mapper.wrap(r2), null)).whenComplete((r3, t3) -> {
                                    if (t3 != null) {
                                        result.completeExceptionally((Throwable)t3);
                                    } else {
                                        result.complete((ResultNode)r3);
                                    }
                                });
                            }
                        });
                    }
                }
            });
        }
        return result;
    }

    public static class Factory
    implements SectionHelperFactory<SetSectionHelper> {
        public static final String HINT_PREFIX = "<set#";

        @Override
        public List<String> getDefaultAliases() {
            return ImmutableList.of(SetSectionHelper.SET, SetSectionHelper.LET);
        }

        @Override
        public SectionHelperFactory.ParametersInfo getParameters() {
            return SectionHelperFactory.ParametersInfo.EMPTY;
        }

        @Override
        public SectionHelperFactory.MissingEndTagStrategy missingEndTagStrategy() {
            return SectionHelperFactory.MissingEndTagStrategy.BIND_TO_PARENT;
        }

        @Override
        public SetSectionHelper initialize(SectionHelperFactory.SectionInitContext context) {
            HashMap<String, Expression> params = new HashMap<String, Expression>();
            HashMap<String, Expression> keys = null;
            for (Map.Entry<String, String> e : context.getParameters().entrySet()) {
                String key = e.getKey();
                if (key.endsWith("?")) {
                    key = key.substring(0, key.length() - 1);
                    if (keys == null) {
                        keys = new HashMap<String, Expression>();
                    }
                    keys.put(key, context.parseValue(key + "??"));
                }
                params.put(key, context.getExpression(key));
            }
            return new SetSectionHelper(params, keys);
        }

        @Override
        public Scope initializeBlock(Scope previousScope, SectionHelperFactory.BlockInfo block) {
            if (block.getLabel().equals("$main")) {
                Scope newScope = new Scope(previousScope);
                for (Map.Entry<String, String> e : block.getParameters().entrySet()) {
                    Expression expr;
                    String key = e.getKey();
                    boolean isDefaultValue = key.endsWith("?");
                    if (isDefaultValue) {
                        key = key.substring(0, key.length() - 1);
                    }
                    if ((expr = block.addExpression(key, e.getValue())).hasTypeInfo()) {
                        boolean add = !isDefaultValue || previousScope.getBinding(key) == null;
                        if (!add) continue;
                        newScope.putBinding(key, key + HINT_PREFIX + expr.getGeneratedId() + ">");
                        continue;
                    }
                    newScope.putBinding(key, null);
                }
                return newScope;
            }
            return previousScope;
        }
    }
}

