/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.qute;

import io.quarkus.qute.CharReplacementResultMapper;
import io.quarkus.qute.RawString;
import io.quarkus.qute.TemplateNode;
import io.quarkus.qute.Variant;
import java.util.Optional;

public class JsonEscaper
extends CharReplacementResultMapper {
    @Override
    public boolean appliesTo(TemplateNode.Origin origin, Object result) {
        String contentType;
        if (result instanceof RawString) {
            return false;
        }
        Optional<Variant> variant = origin.getVariant();
        if (variant.isPresent() && (contentType = variant.get().getContentType()) != null) {
            return contentType.startsWith("application/json");
        }
        return false;
    }

    @Override
    protected String replacementFor(char c) {
        switch (c) {
            case '\"': {
                return "\\\"";
            }
            case '\\': {
                return "\\\\";
            }
            case '\r': {
                return "\\r";
            }
            case '\b': {
                return "\\b";
            }
            case '\n': {
                return "\\n";
            }
            case '\t': {
                return "\\t";
            }
            case '\f': {
                return "\\f";
            }
            case '/': {
                return "\\/";
            }
        }
        return c < ' ' ? String.format("\\u%04x", c) : null;
    }
}

