/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.qute.generator;

import io.quarkus.gizmo.AssignableResultHandle;
import io.quarkus.gizmo.BranchResult;
import io.quarkus.gizmo.BytecodeCreator;
import io.quarkus.gizmo.CatchBlockCreator;
import io.quarkus.gizmo.ClassCreator;
import io.quarkus.gizmo.ClassOutput;
import io.quarkus.gizmo.FieldCreator;
import io.quarkus.gizmo.FieldDescriptor;
import io.quarkus.gizmo.FunctionCreator;
import io.quarkus.gizmo.Gizmo;
import io.quarkus.gizmo.MethodCreator;
import io.quarkus.gizmo.MethodDescriptor;
import io.quarkus.gizmo.ResultHandle;
import io.quarkus.gizmo.TryBlock;
import io.quarkus.qute.EvalContext;
import io.quarkus.qute.EvaluatedParams;
import io.quarkus.qute.NamespaceResolver;
import io.quarkus.qute.TemplateException;
import io.quarkus.qute.TemplateExtension;
import io.quarkus.qute.ValueResolver;
import io.quarkus.qute.generator.AbstractGenerator;
import io.quarkus.qute.generator.Descriptors;
import io.quarkus.qute.generator.DotNames;
import io.quarkus.qute.generator.ValueResolverGenerator;
import java.lang.reflect.Modifier;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.function.BiConsumer;
import java.util.regex.Pattern;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.AnnotationTarget;
import org.jboss.jandex.AnnotationValue;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.DotName;
import org.jboss.jandex.IndexView;
import org.jboss.jandex.MethodInfo;
import org.jboss.jandex.PrimitiveType;
import org.jboss.jandex.Type;

public class ExtensionMethodGenerator
extends AbstractGenerator {
    public static final DotName TEMPLATE_EXTENSION = DotName.createSimple((String)TemplateExtension.class.getName());
    public static final DotName TEMPLATE_ATTRIBUTE = DotName.createSimple((String)TemplateExtension.TemplateAttribute.class.getName());
    public static final String SUFFIX = "_Extension_ValueResolver";
    public static final String NAMESPACE_SUFFIX = "_Namespace_Extension_ValueResolver";
    public static final String MATCH_NAME = "matchName";
    public static final String MATCH_NAMES = "matchNames";
    public static final String MATCH_REGEX = "matchRegex";
    public static final String PRIORITY = "priority";
    public static final String NAMESPACE = "namespace";
    public static final String PATTERN = "pattern";

    public ExtensionMethodGenerator(IndexView index, ClassOutput classOutput) {
        super(index, classOutput);
    }

    @Override
    public Set<String> getGeneratedTypes() {
        return this.generatedTypes;
    }

    public static void validate(MethodInfo method, String namespace) {
        if (!Modifier.isStatic(method.flags())) {
            throw new IllegalStateException("Template extension method declared on " + String.valueOf(method.declaringClass().name()) + "  must be static: " + String.valueOf(method));
        }
        if (method.returnType().kind() == Type.Kind.VOID) {
            throw new IllegalStateException("Template extension method declared on " + String.valueOf(method.declaringClass().name()) + " must not return void: " + String.valueOf(method));
        }
        if (Modifier.isPrivate(method.flags())) {
            throw new IllegalStateException("Template extension method declared on " + String.valueOf(method.declaringClass().name()) + " must not be private: " + String.valueOf(method));
        }
    }

    public String generate(MethodInfo method, String matchName, List<String> matchNames, String matchRegex, Integer priority) {
        AnnotationValue matchRegexValue;
        AnnotationValue priorityValue;
        AnnotationValue matchNamesValue;
        AnnotationValue matchNameValue;
        AnnotationInstance extensionAnnotation = method.annotation(TEMPLATE_EXTENSION);
        List parameters = method.parameterTypes();
        ExtensionMethodGenerator.validate(method, null);
        ClassInfo declaringClass = method.declaringClass();
        if (matchName == null && extensionAnnotation != null && (matchNameValue = extensionAnnotation.value(MATCH_NAME)) != null) {
            matchName = matchNameValue.asString();
        }
        if (matchName == null || matchName.equals("<<method name>>")) {
            matchName = method.name();
        }
        if (matchNames == null && extensionAnnotation != null && (matchNamesValue = extensionAnnotation.value(MATCH_NAMES)) != null) {
            matchNames = new ArrayList<String>();
            for (String name : matchNamesValue.asStringArray()) {
                matchNames.add(name);
            }
        }
        if (priority == null && extensionAnnotation != null && (priorityValue = extensionAnnotation.value(PRIORITY)) != null) {
            priority = priorityValue.asInt();
        }
        if (priority == null) {
            priority = 5;
        }
        if (matchRegex == null && extensionAnnotation != null && (matchRegexValue = extensionAnnotation.value(MATCH_REGEX)) != null) {
            matchRegex = matchRegexValue.asString();
        }
        if (!(matchRegex == null && matchNames.isEmpty() && !matchName.equals("*") || parameters.size() >= 2 && ((Type)parameters.get(1)).name().equals((Object)DotNames.STRING))) {
            throw new TemplateException("A template extension method matching multiple names or a regular expression must declare at least two parameters and the second parameter must be string: " + String.valueOf(method));
        }
        Object baseName = declaringClass.enclosingClass() != null ? ValueResolverGenerator.simpleName(declaringClass.enclosingClass()) + "$_" + ValueResolverGenerator.simpleName(declaringClass) : ValueResolverGenerator.simpleName(declaringClass);
        String targetPackage = ValueResolverGenerator.packageName(declaringClass.name());
        String suffix = "_Extension_ValueResolver_" + method.name() + "_" + ExtensionMethodGenerator.sha1(parameters.toString());
        String generatedName = ValueResolverGenerator.generatedNameFromTarget(targetPackage, (String)baseName, suffix);
        this.generatedTypes.add(generatedName.replace('/', '.'));
        ClassCreator valueResolver = ClassCreator.builder().classOutput(this.classOutput).className(generatedName).interfaces(new Class[]{ValueResolver.class}).build();
        FieldDescriptor patternField = null;
        if (matchRegex != null && !matchRegex.isEmpty()) {
            patternField = ((FieldCreator)valueResolver.getFieldCreator(PATTERN, Pattern.class).setModifiers(18)).getFieldDescriptor();
            MethodCreator constructor = valueResolver.getMethodCreator("<init>", "V", new String[0]);
            constructor.invokeSpecialMethod(Descriptors.OBJECT_CONSTRUCTOR, constructor.getThis(), new ResultHandle[0]);
            constructor.writeInstanceField(patternField, constructor.getThis(), constructor.invokeStaticMethod(Descriptors.PATTERN_COMPILE, new ResultHandle[]{constructor.load(matchRegex)}));
            constructor.returnValue(null);
        }
        this.implementGetPriority(valueResolver, priority);
        Parameters params = new Parameters(method, patternField != null || !matchNames.isEmpty() || matchName.equals("*"), false);
        this.implementAppliesTo(valueResolver, method, matchName, matchNames, patternField, params);
        this.implementResolve(valueResolver, declaringClass, method, matchName, matchNames, patternField, params);
        valueResolver.close();
        return generatedName.replace('/', '.');
    }

    public NamespaceResolverCreator createNamespaceResolver(ClassInfo declaringClass, String namespace, int priority) {
        return new NamespaceResolverCreator(declaringClass, namespace, priority);
    }

    private void implementGetNamespace(ClassCreator namespaceResolver, String namespace) {
        MethodCreator getNamespace = (MethodCreator)namespaceResolver.getMethodCreator("getNamespace", String.class, new Class[0]).setModifiers(1);
        getNamespace.returnValue(getNamespace.load(namespace));
    }

    private void implementGetPriority(ClassCreator valueResolver, int priority) {
        MethodCreator getPriority = (MethodCreator)valueResolver.getMethodCreator("getPriority", Integer.TYPE, new Class[0]).setModifiers(1);
        getPriority.returnValue(getPriority.load(priority));
    }

    private void implementResolve(ClassCreator valueResolver, ClassInfo declaringClass, MethodInfo method, String matchName, List<String> matchNames, FieldDescriptor patternField, Parameters params) {
        ResultHandle ret;
        MethodCreator resolve = (MethodCreator)valueResolver.getMethodCreator("resolve", CompletionStage.class, new Class[]{EvalContext.class}).setModifiers(1);
        ResultHandle evalContext = resolve.getMethodParam(0);
        ResultHandle base = resolve.invokeInterfaceMethod(Descriptors.GET_BASE, evalContext, new ResultHandle[0]);
        boolean isNameParamRequired = patternField != null || !matchNames.isEmpty() || matchName.equals("*");
        boolean returnsCompletionStage = this.hasCompletionStage(method.returnType());
        if (!params.needsEvaluation()) {
            ResultHandle[] args = new ResultHandle[params.size()];
            for (int i = 0; i < params.size(); ++i) {
                Param param = params.get(i);
                if (param.kind == ParamKind.BASE) {
                    args[i] = base;
                    continue;
                }
                if (param.kind == ParamKind.NAME) {
                    args[i] = resolve.invokeInterfaceMethod(Descriptors.GET_NAME, evalContext, new ResultHandle[0]);
                    continue;
                }
                if (param.kind != ParamKind.ATTR) continue;
                args[i] = resolve.invokeInterfaceMethod(Descriptors.GET_ATTRIBUTE, evalContext, new ResultHandle[]{resolve.load(param.name)});
            }
            ResultHandle result = resolve.invokeStaticMethod(MethodDescriptor.ofMethod((String)declaringClass.name().toString(), (String)method.name(), (String)method.returnType().name().toString(), (String[])params.parameterTypesAsStringArray()), args);
            ret = returnsCompletionStage ? result : resolve.invokeStaticMethod(Descriptors.COMPLETED_STAGE_OF, new ResultHandle[]{result});
        } else {
            ret = resolve.newInstance(MethodDescriptor.ofConstructor(CompletableFuture.class, (Class[])new Class[0]), new ResultHandle[0]);
            ResultHandle name = resolve.invokeInterfaceMethod(Descriptors.GET_NAME, evalContext, new ResultHandle[0]);
            ResultHandle evaluatedParamsHandle = resolve.invokeStaticMethod(Descriptors.EVALUATED_PARAMS_EVALUATE, new ResultHandle[]{evalContext});
            ResultHandle paramsReadyHandle = resolve.readInstanceField(Descriptors.EVALUATED_PARAMS_STAGE, evaluatedParamsHandle);
            FunctionCreator whenCompleteFun = resolve.createFunction(BiConsumer.class);
            resolve.invokeInterfaceMethod(Descriptors.CF_WHEN_COMPLETE, paramsReadyHandle, new ResultHandle[]{whenCompleteFun.getInstance()});
            BytecodeCreator whenComplete = whenCompleteFun.getBytecode();
            AssignableResultHandle whenBase = whenComplete.createVariable(Object.class);
            whenComplete.assign(whenBase, base);
            AssignableResultHandle whenName = null;
            if (isNameParamRequired) {
                whenName = whenComplete.createVariable(String.class);
                whenComplete.assign(whenName, name);
            }
            AssignableResultHandle whenRet = whenComplete.createVariable(CompletableFuture.class);
            whenComplete.assign(whenRet, ret);
            AssignableResultHandle whenEvaluatedParams = whenComplete.createVariable(EvaluatedParams.class);
            whenComplete.assign(whenEvaluatedParams, evaluatedParamsHandle);
            AssignableResultHandle whenEvalContext = whenComplete.createVariable(EvalContext.class);
            whenComplete.assign(whenEvalContext, evalContext);
            BranchResult throwableIsNull = whenComplete.ifNull(whenComplete.getMethodParam(1));
            BytecodeCreator success = throwableIsNull.trueBranch();
            boolean isVarArgs = ValueResolverGenerator.isVarArgs(method);
            List<Param> evaluated = params.evaluated();
            ResultHandle paramTypesHandle = success.newArray(Class.class, evaluated.size());
            int idx = 0;
            for (Param p : evaluated) {
                success.writeArrayValue(paramTypesHandle, idx++, ValueResolverGenerator.loadParamType(success, p.type));
            }
            BytecodeCreator typeMatchFailed = success.ifNonZero(success.invokeVirtualMethod(Descriptors.EVALUATED_PARAMS_PARAM_TYPES_MATCH, (ResultHandle)whenEvaluatedParams, new ResultHandle[]{success.load(isVarArgs), paramTypesHandle})).falseBranch();
            typeMatchFailed.invokeVirtualMethod(Descriptors.COMPLETABLE_FUTURE_COMPLETE, (ResultHandle)whenRet, new ResultHandle[]{typeMatchFailed.invokeStaticMethod(Descriptors.NOT_FOUND_FROM_EC, new ResultHandle[]{whenEvalContext})});
            typeMatchFailed.returnValue(null);
            TryBlock tryCatch = success.tryBlock();
            CatchBlockCreator exception = tryCatch.addCatch(Throwable.class);
            exception.invokeVirtualMethod(Descriptors.COMPLETABLE_FUTURE_COMPLETE_EXCEPTIONALLY, (ResultHandle)whenRet, new ResultHandle[]{exception.getCaughtException()});
            ResultHandle[] args = new ResultHandle[params.size()];
            int evalIdx = 0;
            int lastIdx = params.size() - 1;
            for (int i = 0; i < params.size(); ++i) {
                Param param = params.get(i);
                if (param.kind == ParamKind.BASE) {
                    args[i] = whenBase;
                    continue;
                }
                if (param.kind == ParamKind.NAME) {
                    args[i] = whenName;
                    continue;
                }
                if (param.kind == ParamKind.ATTR) {
                    args[i] = tryCatch.invokeInterfaceMethod(Descriptors.GET_ATTRIBUTE, (ResultHandle)whenEvalContext, new ResultHandle[]{tryCatch.load(param.name)});
                    continue;
                }
                if (isVarArgs && i == lastIdx) {
                    ResultHandle varargsResults;
                    Type varargsParam = params.get((int)lastIdx).type;
                    ResultHandle componentType = tryCatch.loadClass(varargsParam.asArrayType().constituent().name().toString());
                    args[i] = varargsResults = tryCatch.invokeVirtualMethod(Descriptors.EVALUATED_PARAMS_GET_VARARGS_RESULTS, evaluatedParamsHandle, new ResultHandle[]{tryCatch.load(evaluated.size()), componentType});
                    continue;
                }
                args[i] = tryCatch.invokeVirtualMethod(Descriptors.EVALUATED_PARAMS_GET_RESULT, (ResultHandle)whenEvaluatedParams, new ResultHandle[]{tryCatch.load(evalIdx++)});
            }
            ResultHandle invokeRet = tryCatch.invokeStaticMethod(MethodDescriptor.ofMethod((String)declaringClass.name().toString(), (String)method.name(), (String)method.returnType().name().toString(), (String[])params.parameterTypesAsStringArray()), args);
            tryCatch.invokeVirtualMethod(Descriptors.COMPLETABLE_FUTURE_COMPLETE, (ResultHandle)whenRet, new ResultHandle[]{invokeRet});
            BytecodeCreator failure = throwableIsNull.falseBranch();
            failure.invokeVirtualMethod(Descriptors.COMPLETABLE_FUTURE_COMPLETE_EXCEPTIONALLY, (ResultHandle)whenRet, new ResultHandle[]{whenComplete.getMethodParam(1)});
            whenComplete.returnValue(null);
        }
        resolve.returnValue(ret);
    }

    private void implementAppliesTo(ClassCreator valueResolver, MethodInfo method, String matchName, List<String> matchNames, FieldDescriptor patternField, Parameters params) {
        MethodCreator appliesTo = (MethodCreator)valueResolver.getMethodCreator("appliesTo", Boolean.TYPE, new Class[]{EvalContext.class}).setModifiers(1);
        boolean matchAny = patternField == null && matchNames.isEmpty() && matchName.equals("*");
        boolean isVarArgs = ValueResolverGenerator.isVarArgs(method);
        ResultHandle evalContext = appliesTo.getMethodParam(0);
        ResultHandle base = appliesTo.invokeInterfaceMethod(Descriptors.GET_BASE, evalContext, new ResultHandle[0]);
        ResultHandle name = appliesTo.invokeInterfaceMethod(Descriptors.GET_NAME, evalContext, new ResultHandle[0]);
        BytecodeCreator baseNull = appliesTo.ifNull(base).trueBranch();
        baseNull.returnValue(baseNull.load(false));
        ResultHandle baseClass = appliesTo.invokeVirtualMethod(Descriptors.GET_CLASS, base, new ResultHandle[0]);
        ResultHandle testClass = appliesTo.loadClass(ExtensionMethodGenerator.box(params.getFirst((ParamKind)ParamKind.BASE).type).name().toString());
        ResultHandle baseClassTest = appliesTo.invokeVirtualMethod(Descriptors.IS_ASSIGNABLE_FROM, testClass, new ResultHandle[]{baseClass});
        BytecodeCreator baseNotAssignable = appliesTo.ifTrue(baseClassTest).falseBranch();
        baseNotAssignable.returnValue(baseNotAssignable.load(false));
        if (!matchAny) {
            if (patternField != null) {
                ResultHandle pattern = appliesTo.readInstanceField(patternField, appliesTo.getThis());
                ResultHandle matcher = appliesTo.invokeVirtualMethod(Descriptors.PATTERN_MATCHER, pattern, new ResultHandle[]{name});
                BytecodeCreator nameNotMatched = appliesTo.ifFalse(appliesTo.invokeVirtualMethod(Descriptors.MATCHER_MATCHES, matcher, new ResultHandle[0])).trueBranch();
                nameNotMatched.returnValue(appliesTo.load(false));
            } else if (!matchNames.isEmpty()) {
                BytecodeCreator namesMatch = appliesTo.createScope();
                for (String match : matchNames) {
                    ResultHandle nameTest = Gizmo.equals((BytecodeCreator)namesMatch, (ResultHandle)name, (ResultHandle)namesMatch.load(match));
                    namesMatch.ifTrue(nameTest).trueBranch().breakScope(namesMatch);
                }
                namesMatch.returnValue(namesMatch.load(false));
            } else {
                ResultHandle nameTest = Gizmo.equals((BytecodeCreator)appliesTo, (ResultHandle)name, (ResultHandle)appliesTo.load(matchName));
                BytecodeCreator nameNotMatched = appliesTo.ifFalse(nameTest).trueBranch();
                nameNotMatched.returnValue(nameNotMatched.load(false));
            }
        }
        int evaluatedParamsSize = params.evaluated().size();
        if (!isVarArgs || evaluatedParamsSize > 1) {
            ResultHandle paramsHandle = appliesTo.invokeInterfaceMethod(Descriptors.GET_PARAMS, evalContext, new ResultHandle[0]);
            ResultHandle paramsCount = appliesTo.invokeInterfaceMethod(Descriptors.COLLECTION_SIZE, paramsHandle, new ResultHandle[0]);
            BytecodeCreator paramsNotMatching = isVarArgs ? appliesTo.ifIntegerGreaterThan(appliesTo.load(evaluatedParamsSize - 1), paramsCount).trueBranch() : appliesTo.ifIntegerEqual(appliesTo.load(evaluatedParamsSize), paramsCount).falseBranch();
            paramsNotMatching.returnValue(paramsNotMatching.load(false));
        }
        appliesTo.returnValue(appliesTo.load(true));
    }

    private BytecodeCreator createNamespaceExtensionMatchScope(BytecodeCreator bytecodeCreator, MethodInfo method, int realParamSize, String matchName, List<String> matchNames, FieldDescriptor patternField, ResultHandle name, ResultHandle params, ResultHandle paramsCount) {
        boolean matchAny = patternField == null && matchNames.isEmpty() && matchName.equals("*");
        boolean isVarArgs = ValueResolverGenerator.isVarArgs(method);
        BytecodeCreator matchScope = bytecodeCreator.createScope();
        if (!matchAny) {
            if (patternField != null) {
                ResultHandle pattern = matchScope.readInstanceField(patternField, matchScope.getThis());
                ResultHandle matcher = matchScope.invokeVirtualMethod(Descriptors.PATTERN_MATCHER, pattern, new ResultHandle[]{name});
                matchScope.ifFalse(matchScope.invokeVirtualMethod(Descriptors.MATCHER_MATCHES, matcher, new ResultHandle[0])).trueBranch().breakScope(matchScope);
            } else if (!matchNames.isEmpty()) {
                BytecodeCreator namesMatch = matchScope.createScope();
                for (String match : matchNames) {
                    ResultHandle nameTest = Gizmo.equals((BytecodeCreator)namesMatch, (ResultHandle)name, (ResultHandle)namesMatch.load(match));
                    namesMatch.ifTrue(nameTest).trueBranch().breakScope(namesMatch);
                }
                namesMatch.breakScope(matchScope);
            } else {
                matchScope.ifTrue(Gizmo.equals((BytecodeCreator)matchScope, (ResultHandle)matchScope.load(matchName), (ResultHandle)name)).falseBranch().breakScope(matchScope);
            }
        }
        if (!isVarArgs || realParamSize > 1) {
            if (isVarArgs) {
                matchScope.ifIntegerLessEqual(matchScope.load(realParamSize - 1), paramsCount).falseBranch().breakScope(matchScope);
            } else {
                matchScope.ifIntegerEqual(matchScope.load(realParamSize), paramsCount).falseBranch().breakScope(matchScope);
            }
        }
        return matchScope;
    }

    static String sha1(String value) {
        try {
            MessageDigest md = MessageDigest.getInstance("SHA-1");
            byte[] digest = md.digest(value.getBytes(StandardCharsets.UTF_8));
            StringBuilder sb = new StringBuilder(40);
            for (int i = 0; i < digest.length; ++i) {
                sb.append(Integer.toHexString(digest[i] & 0xFF | 0x100).substring(1, 3));
            }
            return sb.toString();
        }
        catch (NoSuchAlgorithmException e) {
            throw new IllegalStateException(e);
        }
    }

    static Type box(Type type) {
        if (type.kind() == Type.Kind.PRIMITIVE) {
            return ExtensionMethodGenerator.box(type.asPrimitiveType().primitive());
        }
        return type;
    }

    static Type box(PrimitiveType.Primitive primitive) {
        switch (primitive) {
            case BOOLEAN: {
                return Type.create((DotName)DotNames.BOOLEAN, (Type.Kind)Type.Kind.CLASS);
            }
            case DOUBLE: {
                return Type.create((DotName)DotNames.DOUBLE, (Type.Kind)Type.Kind.CLASS);
            }
            case FLOAT: {
                return Type.create((DotName)DotNames.FLOAT, (Type.Kind)Type.Kind.CLASS);
            }
            case LONG: {
                return Type.create((DotName)DotNames.LONG, (Type.Kind)Type.Kind.CLASS);
            }
            case INT: {
                return Type.create((DotName)DotNames.INTEGER, (Type.Kind)Type.Kind.CLASS);
            }
            case BYTE: {
                return Type.create((DotName)DotNames.BYTE, (Type.Kind)Type.Kind.CLASS);
            }
            case CHAR: {
                return Type.create((DotName)DotNames.CHARACTER, (Type.Kind)Type.Kind.CLASS);
            }
            case SHORT: {
                return Type.create((DotName)DotNames.SHORT, (Type.Kind)Type.Kind.CLASS);
            }
        }
        throw new IllegalArgumentException("Unsupported primitive: " + String.valueOf(primitive));
    }

    public static final class Parameters
    implements Iterable<Param> {
        final List<Param> params;

        public Parameters(MethodInfo method, boolean isNameParameterRequired, boolean hasNamespace) {
            Param nameParam;
            List parameters = method.parameterTypes();
            HashMap<Integer, String> attributeParamNames = new HashMap<Integer, String>();
            for (AnnotationInstance annotation : method.annotations()) {
                String name;
                if (annotation.target().kind() != AnnotationTarget.Kind.METHOD_PARAMETER || !annotation.name().equals((Object)TEMPLATE_ATTRIBUTE)) continue;
                AnnotationValue value = annotation.value();
                short position = annotation.target().asMethodParameter().position();
                String string = name = value != null ? value.asString() : method.parameterName((int)position);
                if (name == null) {
                    throw new TemplateException("Parameter names not recorded for " + String.valueOf(method.declaringClass().name()) + ": compile the class with -parameters");
                }
                attributeParamNames.put(Integer.valueOf(position), name);
            }
            ArrayList<Param> params = new ArrayList<Param>(parameters.size());
            int indexed = 0;
            for (int i = 0; i < parameters.size(); ++i) {
                if (attributeParamNames.containsKey(i)) {
                    params.add(new Param((String)attributeParamNames.get(i), (Type)parameters.get(i), i, ParamKind.ATTR));
                    continue;
                }
                if (indexed == 0) {
                    ++indexed;
                    if (hasNamespace) {
                        if (isNameParameterRequired) {
                            params.add(new Param(method.parameterName(i), (Type)parameters.get(i), i, ParamKind.NAME));
                            continue;
                        }
                        params.add(new Param(method.parameterName(i), (Type)parameters.get(i), i, ParamKind.EVAL));
                        continue;
                    }
                    params.add(new Param(method.parameterName(i), (Type)parameters.get(i), i, ParamKind.BASE));
                    continue;
                }
                if (indexed == 1 && !hasNamespace && isNameParameterRequired) {
                    ++indexed;
                    params.add(new Param(method.parameterName(i), (Type)parameters.get(i), i, ParamKind.NAME));
                    continue;
                }
                ++indexed;
                params.add(new Param(method.parameterName(i), (Type)parameters.get(i), i, ParamKind.EVAL));
            }
            this.params = params;
            if (isNameParameterRequired && ((nameParam = this.getFirst(ParamKind.NAME)) == null || !nameParam.type.name().equals((Object)DotNames.STRING))) {
                throw new TemplateException("Template extension method declared on " + String.valueOf(method.declaringClass().name()) + " must accept at least one string parameter to match the name: " + String.valueOf(method));
            }
            if (!hasNamespace && this.getFirst(ParamKind.BASE) == null) {
                throw new TemplateException("Template extension method declared on " + String.valueOf(method.declaringClass().name()) + " must accept at least one parameter to match the base object: " + String.valueOf(method));
            }
            for (Param param : params) {
                if (param.kind != ParamKind.ATTR || param.type.name().equals((Object)DotNames.OBJECT)) continue;
                throw new TemplateException("Template extension method parameter annotated with @TemplateAttribute declared on " + String.valueOf(method.declaringClass().name()) + " must be of type java.lang.Object: " + String.valueOf(method));
            }
        }

        public String[] parameterTypesAsStringArray() {
            String[] types = new String[this.params.size()];
            for (int i = 0; i < this.params.size(); ++i) {
                types[i] = this.params.get((int)i).type.name().toString();
            }
            return types;
        }

        public Param getFirst(ParamKind kind) {
            for (Param param : this.params) {
                if (param.kind != kind) continue;
                return param;
            }
            return null;
        }

        public Param get(int index) {
            return this.params.get(index);
        }

        public int size() {
            return this.params.size();
        }

        public boolean needsEvaluation() {
            for (Param param : this.params) {
                if (param.kind != ParamKind.EVAL) continue;
                return true;
            }
            return false;
        }

        public List<Param> evaluated() {
            if (this.params.isEmpty()) {
                return Collections.emptyList();
            }
            ArrayList<Param> evaluated = new ArrayList<Param>();
            for (Param param : this.params) {
                if (param.kind != ParamKind.EVAL) continue;
                evaluated.add(param);
            }
            return evaluated;
        }

        @Override
        public Iterator<Param> iterator() {
            return this.params.iterator();
        }
    }

    public class NamespaceResolverCreator
    implements AutoCloseable {
        private final ClassCreator namespaceResolver;

        public NamespaceResolverCreator(ClassInfo declaringClass, String namespace, int priority) {
            Object baseName = declaringClass.enclosingClass() != null ? ValueResolverGenerator.simpleName(declaringClass.enclosingClass()) + "$_" + ValueResolverGenerator.simpleName(declaringClass) : ValueResolverGenerator.simpleName(declaringClass);
            String targetPackage = ValueResolverGenerator.packageName(declaringClass.name());
            String suffix = "_Namespace_Extension_ValueResolver_" + ExtensionMethodGenerator.sha1(namespace) + "_" + priority;
            String generatedName = ValueResolverGenerator.generatedNameFromTarget(targetPackage, (String)baseName, suffix);
            ExtensionMethodGenerator.this.generatedTypes.add(generatedName.replace('/', '.'));
            this.namespaceResolver = ClassCreator.builder().classOutput(ExtensionMethodGenerator.this.classOutput).className(generatedName).interfaces(new Class[]{NamespaceResolver.class}).build();
            ExtensionMethodGenerator.this.implementGetNamespace(this.namespaceResolver, namespace);
            ExtensionMethodGenerator.this.implementGetPriority(this.namespaceResolver, priority);
        }

        public String getClassName() {
            return this.namespaceResolver.getClassName().replace('/', '.');
        }

        public ResolveCreator implementResolve() {
            return new ResolveCreator();
        }

        @Override
        public void close() {
            this.namespaceResolver.close();
        }

        public class ResolveCreator
        implements AutoCloseable {
            private final MethodCreator resolve;
            private final MethodCreator constructor;
            private final ResultHandle evalContext;
            private final ResultHandle name;
            private final ResultHandle paramsHandle;
            private final ResultHandle paramsCount;

            public ResolveCreator() {
                this.resolve = (MethodCreator)NamespaceResolverCreator.this.namespaceResolver.getMethodCreator("resolve", CompletionStage.class, new Class[]{EvalContext.class}).setModifiers(1);
                this.evalContext = this.resolve.getMethodParam(0);
                this.name = this.resolve.invokeInterfaceMethod(Descriptors.GET_NAME, this.evalContext, new ResultHandle[0]);
                this.paramsHandle = this.resolve.invokeInterfaceMethod(Descriptors.GET_PARAMS, this.evalContext, new ResultHandle[0]);
                this.paramsCount = this.resolve.invokeInterfaceMethod(Descriptors.COLLECTION_SIZE, this.paramsHandle, new ResultHandle[0]);
                this.constructor = NamespaceResolverCreator.this.namespaceResolver.getMethodCreator("<init>", "V", new String[0]);
                this.constructor.invokeSpecialMethod(Descriptors.OBJECT_CONSTRUCTOR, this.constructor.getThis(), new ResultHandle[0]);
            }

            public void addMethod(MethodInfo method, String matchName, List<String> matchNames, String matchRegex) {
                FieldDescriptor patternField = null;
                if (matchRegex != null && !matchRegex.isEmpty()) {
                    patternField = ((FieldCreator)NamespaceResolverCreator.this.namespaceResolver.getFieldCreator("pattern_" + ExtensionMethodGenerator.sha1(method.toString()), Pattern.class).setModifiers(18)).getFieldDescriptor();
                    this.constructor.writeInstanceField(patternField, this.constructor.getThis(), this.constructor.invokeStaticMethod(Descriptors.PATTERN_COMPILE, new ResultHandle[]{this.constructor.load(matchRegex)}));
                }
                boolean isNameParamRequired = patternField != null || !matchNames.isEmpty() || matchName.equals("*");
                Parameters params = new Parameters(method, isNameParamRequired, true);
                BytecodeCreator matchScope = ExtensionMethodGenerator.this.createNamespaceExtensionMatchScope((BytecodeCreator)this.resolve, method, params.evaluated().size(), matchName, matchNames, patternField, this.name, this.paramsHandle, this.paramsCount);
                if (!params.needsEvaluation()) {
                    ResultHandle[] args = new ResultHandle[params.size()];
                    for (int i = 0; i < params.size(); ++i) {
                        Param param = params.get(i);
                        if (param.kind == ParamKind.NAME) {
                            args[i] = this.name;
                            continue;
                        }
                        if (param.kind != ParamKind.ATTR) continue;
                        args[i] = matchScope.invokeInterfaceMethod(Descriptors.GET_ATTRIBUTE, this.evalContext, new ResultHandle[]{matchScope.load(param.name)});
                    }
                    matchScope.returnValue(matchScope.invokeStaticMethod(Descriptors.COMPLETED_STAGE_OF, new ResultHandle[]{matchScope.invokeStaticMethod(MethodDescriptor.of((MethodInfo)method), args)}));
                } else {
                    ResultHandle ret = matchScope.newInstance(MethodDescriptor.ofConstructor(CompletableFuture.class, (Class[])new Class[0]), new ResultHandle[0]);
                    ResultHandle evaluatedParamsHandle = matchScope.invokeStaticMethod(Descriptors.EVALUATED_PARAMS_EVALUATE, new ResultHandle[]{this.evalContext});
                    ResultHandle paramsReadyHandle = matchScope.readInstanceField(Descriptors.EVALUATED_PARAMS_STAGE, evaluatedParamsHandle);
                    FunctionCreator whenCompleteFun = matchScope.createFunction(BiConsumer.class);
                    matchScope.invokeInterfaceMethod(Descriptors.CF_WHEN_COMPLETE, paramsReadyHandle, new ResultHandle[]{whenCompleteFun.getInstance()});
                    BytecodeCreator whenComplete = whenCompleteFun.getBytecode();
                    AssignableResultHandle whenName = null;
                    if (isNameParamRequired) {
                        whenName = whenComplete.createVariable(String.class);
                        whenComplete.assign(whenName, this.name);
                    }
                    AssignableResultHandle whenRet = whenComplete.createVariable(CompletableFuture.class);
                    whenComplete.assign(whenRet, ret);
                    AssignableResultHandle whenEvaluatedParams = whenComplete.createVariable(EvaluatedParams.class);
                    whenComplete.assign(whenEvaluatedParams, evaluatedParamsHandle);
                    AssignableResultHandle whenEvalContext = whenComplete.createVariable(EvalContext.class);
                    whenComplete.assign(whenEvalContext, this.evalContext);
                    BranchResult throwableIsNull = whenComplete.ifNull(whenComplete.getMethodParam(1));
                    BytecodeCreator success = throwableIsNull.trueBranch();
                    boolean isVarArgs = ValueResolverGenerator.isVarArgs(method);
                    List<Param> evaluated = params.evaluated();
                    ResultHandle paramTypesHandle = success.newArray(Class.class, evaluated.size());
                    int idx = 0;
                    for (Param p : evaluated) {
                        success.writeArrayValue(paramTypesHandle, idx++, ValueResolverGenerator.loadParamType(success, p.type));
                    }
                    BytecodeCreator typeMatchFailed = success.ifTrue(success.invokeVirtualMethod(Descriptors.EVALUATED_PARAMS_PARAM_TYPES_MATCH, (ResultHandle)whenEvaluatedParams, new ResultHandle[]{success.load(isVarArgs), paramTypesHandle})).falseBranch();
                    typeMatchFailed.invokeVirtualMethod(Descriptors.COMPLETABLE_FUTURE_COMPLETE, (ResultHandle)whenRet, new ResultHandle[]{typeMatchFailed.invokeStaticMethod(Descriptors.NOT_FOUND_FROM_EC, new ResultHandle[]{whenEvalContext})});
                    typeMatchFailed.returnValue(null);
                    TryBlock tryCatch = success.tryBlock();
                    CatchBlockCreator exception = tryCatch.addCatch(Throwable.class);
                    exception.invokeVirtualMethod(Descriptors.COMPLETABLE_FUTURE_COMPLETE_EXCEPTIONALLY, (ResultHandle)whenRet, new ResultHandle[]{exception.getCaughtException()});
                    ResultHandle[] args = new ResultHandle[params.size()];
                    int evalIdx = 0;
                    int lastIdx = params.size() - 1;
                    for (int i = 0; i < params.size(); ++i) {
                        Param param = params.get(i);
                        if (param.kind == ParamKind.NAME) {
                            args[i] = whenName;
                            continue;
                        }
                        if (param.kind == ParamKind.ATTR) {
                            args[i] = tryCatch.invokeInterfaceMethod(Descriptors.GET_ATTRIBUTE, (ResultHandle)whenEvalContext, new ResultHandle[]{tryCatch.load(param.name)});
                            continue;
                        }
                        if (isVarArgs && i == lastIdx) {
                            ResultHandle varargsResults;
                            Type varargsParam = params.get((int)lastIdx).type;
                            ResultHandle componentType = tryCatch.loadClass(varargsParam.asArrayType().constituent().name().toString());
                            args[i] = varargsResults = tryCatch.invokeVirtualMethod(Descriptors.EVALUATED_PARAMS_GET_VARARGS_RESULTS, (ResultHandle)whenEvaluatedParams, new ResultHandle[]{tryCatch.load(evaluated.size()), componentType});
                            continue;
                        }
                        args[i] = tryCatch.invokeVirtualMethod(Descriptors.EVALUATED_PARAMS_GET_RESULT, (ResultHandle)whenEvaluatedParams, new ResultHandle[]{tryCatch.load(evalIdx++)});
                    }
                    ResultHandle invokeRet = tryCatch.invokeStaticMethod(MethodDescriptor.of((MethodInfo)method), args);
                    tryCatch.invokeVirtualMethod(Descriptors.COMPLETABLE_FUTURE_COMPLETE, (ResultHandle)whenRet, new ResultHandle[]{invokeRet});
                    BytecodeCreator failure = throwableIsNull.falseBranch();
                    failure.invokeVirtualMethod(Descriptors.COMPLETABLE_FUTURE_COMPLETE_EXCEPTIONALLY, (ResultHandle)whenRet, new ResultHandle[]{whenComplete.getMethodParam(1)});
                    whenComplete.returnValue(null);
                    matchScope.returnValue(ret);
                }
            }

            @Override
            public void close() {
                this.constructor.returnValue(null);
                this.resolve.returnValue(this.resolve.invokeStaticMethod(Descriptors.RESULTS_NOT_FOUND_EC, new ResultHandle[]{this.evalContext}));
            }
        }
    }

    public static final class Param {
        public final String name;
        public final Type type;
        public final int position;
        public final ParamKind kind;

        public Param(String name, Type type, int position, ParamKind paramKind) {
            this.name = name;
            this.type = type;
            this.position = position;
            this.kind = paramKind;
        }

        public String toString() {
            return "Param [name=" + this.name + ", type=" + String.valueOf(this.type) + ", position=" + this.position + ", kind=" + String.valueOf((Object)this.kind) + "]";
        }
    }

    static enum ParamKind {
        BASE,
        NAME,
        ATTR,
        EVAL;

    }
}

