/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.reactive.server.jaxrs;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.ws.rs.core.EntityTag;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Request;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.Variant;
import org.jboss.resteasy.reactive.common.jaxrs.ResponseBuilderImpl;
import org.jboss.resteasy.reactive.common.util.DateUtil;
import org.jboss.resteasy.reactive.server.core.ResteasyReactiveRequestContext;
import org.jboss.resteasy.reactive.server.core.request.ServerDrivenNegotiation;

public class RequestImpl
implements Request {
    private final ResteasyReactiveRequestContext requestContext;
    private final String httpMethod;
    private String varyHeader;

    public RequestImpl(ResteasyReactiveRequestContext requestContext) {
        this.requestContext = requestContext;
        this.httpMethod = requestContext.serverRequest().getRequestMethod();
    }

    public String getMethod() {
        return this.requestContext.serverRequest().getRequestMethod();
    }

    private boolean isRfc7232preconditions() {
        return true;
    }

    public Variant selectVariant(List<Variant> variants) throws IllegalArgumentException {
        if (variants == null || variants.size() == 0) {
            throw new IllegalArgumentException("Variant list must not be empty");
        }
        ServerDrivenNegotiation negotiation = new ServerDrivenNegotiation();
        MultivaluedMap<String, String> requestHeaders = this.requestContext.getHttpHeaders().getRequestHeaders();
        negotiation.setAcceptHeaders((List)requestHeaders.get((Object)"Accept"));
        negotiation.setAcceptCharsetHeaders((List)requestHeaders.get((Object)"Accept-Charset"));
        negotiation.setAcceptEncodingHeaders((List)requestHeaders.get((Object)"Accept-Encoding"));
        negotiation.setAcceptLanguageHeaders((List)requestHeaders.get((Object)"Accept-Language"));
        this.varyHeader = ResponseBuilderImpl.createVaryHeader(variants);
        this.requestContext.serverResponse().setResponseHeader((CharSequence)"Vary", this.varyHeader);
        return negotiation.getBestMatch(variants);
    }

    public List<EntityTag> convertEtag(List<String> tags) {
        ArrayList<EntityTag> result = new ArrayList<EntityTag>();
        for (String tag : tags) {
            String[] split;
            for (String etag : split = tag.split(",")) {
                result.add(EntityTag.valueOf((String)etag.trim()));
            }
        }
        return result;
    }

    public Response.ResponseBuilder ifMatch(List<EntityTag> ifMatch, EntityTag eTag) {
        boolean match = false;
        for (EntityTag tag : ifMatch) {
            if (!tag.equals((Object)eTag) && !tag.getValue().equals("*")) continue;
            match = true;
            break;
        }
        if (match) {
            return null;
        }
        return Response.status((Response.Status)Response.Status.PRECONDITION_FAILED).tag(eTag);
    }

    public Response.ResponseBuilder ifNoneMatch(List<EntityTag> ifMatch, EntityTag eTag) {
        boolean match = false;
        for (EntityTag tag : ifMatch) {
            if (!tag.equals((Object)eTag) && !tag.getValue().equals("*")) continue;
            match = true;
            break;
        }
        if (match) {
            if ("GET".equals(this.httpMethod) || "HEAD".equals(this.httpMethod)) {
                return Response.notModified((EntityTag)eTag);
            }
            return Response.status((Response.Status)Response.Status.PRECONDITION_FAILED).tag(eTag);
        }
        return null;
    }

    public Response.ResponseBuilder evaluatePreconditions(EntityTag eTag) {
        List ifNoneMatch;
        if (eTag == null) {
            throw new IllegalArgumentException("ETag was null");
        }
        Response.ResponseBuilder builder = null;
        List ifMatch = (List)this.requestContext.getHttpHeaders().getRequestHeaders().get((Object)"If-Match");
        if (ifMatch != null && ifMatch.size() > 0) {
            builder = this.ifMatch(this.convertEtag(ifMatch), eTag);
        }
        if (builder == null && (ifNoneMatch = (List)this.requestContext.getHttpHeaders().getRequestHeaders().get((Object)"If-None-Match")) != null && ifNoneMatch.size() > 0) {
            builder = this.ifNoneMatch(this.convertEtag(ifNoneMatch), eTag);
        }
        if (builder != null) {
            builder.tag(eTag);
        }
        if (builder != null && this.varyHeader != null) {
            builder.header("Vary", (Object)this.varyHeader);
        }
        return builder;
    }

    public Response.ResponseBuilder ifModifiedSince(String strDate, Date lastModified) {
        Date date = DateUtil.parseDate((String)strDate);
        if (date.getTime() >= lastModified.getTime()) {
            return Response.notModified();
        }
        return null;
    }

    public Response.ResponseBuilder ifUnmodifiedSince(String strDate, Date lastModified) {
        Date date = DateUtil.parseDate((String)strDate);
        if (date.getTime() >= lastModified.getTime()) {
            return null;
        }
        return Response.status((Response.Status)Response.Status.PRECONDITION_FAILED).lastModified(lastModified);
    }

    public Response.ResponseBuilder evaluatePreconditions(Date lastModified) {
        String ifUnmodifiedSince;
        if (lastModified == null) {
            throw new IllegalArgumentException("Param cannot be null");
        }
        Response.ResponseBuilder builder = null;
        MultivaluedMap<String, String> headers = this.requestContext.getHttpHeaders().getRequestHeaders();
        String ifModifiedSince = (String)headers.getFirst((Object)"If-Modified-Since");
        if (!(ifModifiedSince == null || this.isRfc7232preconditions() && headers.containsKey((Object)"If-None-Match"))) {
            builder = this.ifModifiedSince(ifModifiedSince, lastModified);
        }
        if (!(builder != null || (ifUnmodifiedSince = (String)headers.getFirst((Object)"If-Unmodified-Since")) == null || this.isRfc7232preconditions() && headers.containsKey((Object)"If-Match"))) {
            builder = this.ifUnmodifiedSince(ifUnmodifiedSince, lastModified);
        }
        if (builder != null && this.varyHeader != null) {
            builder.header("Vary", (Object)this.varyHeader);
        }
        return builder;
    }

    public Response.ResponseBuilder evaluatePreconditions(Date lastModified, EntityTag eTag) {
        if (lastModified == null) {
            throw new IllegalArgumentException("Last modified was null");
        }
        if (eTag == null) {
            throw new IllegalArgumentException("etag was null");
        }
        Response.ResponseBuilder rtn = null;
        Response.ResponseBuilder lastModifiedBuilder = this.evaluatePreconditions(lastModified);
        Response.ResponseBuilder etagBuilder = this.evaluatePreconditions(eTag);
        if (lastModifiedBuilder == null && etagBuilder == null) {
            rtn = null;
        } else if (lastModifiedBuilder != null && etagBuilder == null) {
            rtn = lastModifiedBuilder;
        } else if (lastModifiedBuilder == null && etagBuilder != null) {
            rtn = etagBuilder;
        } else {
            rtn = lastModifiedBuilder;
            rtn.tag(eTag);
        }
        if (rtn != null && this.varyHeader != null) {
            rtn.header("Vary", (Object)this.varyHeader);
        }
        return rtn;
    }

    public Response.ResponseBuilder evaluatePreconditions() {
        List ifMatch = (List)this.requestContext.getHttpHeaders().getRequestHeaders().get((Object)"If-Match");
        if (ifMatch == null || ifMatch.size() == 0) {
            return null;
        }
        return Response.status((Response.Status)Response.Status.PRECONDITION_FAILED);
    }
}

