/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.reactive.server.handlers;

import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import org.jboss.resteasy.reactive.common.util.MediaTypeHelper;
import org.jboss.resteasy.reactive.common.util.ServerMediaType;
import org.jboss.resteasy.reactive.server.core.ResteasyReactiveRequestContext;
import org.jboss.resteasy.reactive.server.mapping.RuntimeResource;
import org.jboss.resteasy.reactive.server.spi.ServerHttpRequest;
import org.jboss.resteasy.reactive.server.spi.ServerRestHandler;

public class MediaTypeMapper
implements ServerRestHandler {
    final Map<MediaType, Holder> resourcesByConsumes = new HashMap<MediaType, Holder>();
    final List<MediaType> consumesTypes = new ArrayList<MediaType>();

    public MediaTypeMapper(List<RuntimeResource> runtimeResources) {
        for (RuntimeResource runtimeResource : runtimeResources) {
            MediaType[] produces;
            MediaType consumesMT;
            MediaType mediaType = consumesMT = runtimeResource.getConsumes().isEmpty() ? MediaType.WILDCARD_TYPE : runtimeResource.getConsumes().get(0);
            if (!this.resourcesByConsumes.containsKey(consumesMT)) {
                this.consumesTypes.add(consumesMT);
                this.resourcesByConsumes.put(consumesMT, new Holder());
            }
            MediaType[] mediaTypeArray = produces = runtimeResource.getProduces() != null ? runtimeResource.getProduces().getSortedOriginalMediaTypes() : null;
            if (produces == null) {
                produces = new MediaType[]{MediaType.WILDCARD_TYPE};
            }
            for (MediaType producesMT : produces) {
                this.resourcesByConsumes.get(consumesMT).setResource(runtimeResource, producesMT);
            }
        }
        for (Holder holder : this.resourcesByConsumes.values()) {
            holder.setupServerMediaType();
        }
    }

    @Override
    public void handle(ResteasyReactiveRequestContext requestContext) throws Exception {
        RuntimeResource selectedResource;
        String contentType = requestContext.serverRequest().getRequestHeader("Content-Type");
        MediaType contentMediaType = contentType != null ? MediaType.valueOf((String)contentType) : MediaType.WILDCARD_TYPE;
        MediaType consumes = MediaTypeHelper.getBestMatch(Collections.singletonList(contentMediaType), this.consumesTypes);
        Holder selectedHolder = this.resourcesByConsumes.get(consumes);
        if (selectedHolder == null) {
            selectedHolder = this.resourcesByConsumes.get(MediaType.WILDCARD_TYPE);
        }
        if (selectedHolder == null) {
            throw new WebApplicationException(Response.status((Response.Status)Response.Status.UNSUPPORTED_MEDIA_TYPE).build());
        }
        if (selectedHolder.mtWithoutParamsToResource.size() == 1) {
            selectedResource = (RuntimeResource)selectedHolder.mtWithoutParamsToResource.values().iterator().next();
        } else {
            MediaType produces = this.selectMediaType(requestContext, selectedHolder);
            requestContext.setResponseContentType(produces);
            MediaType key = produces;
            if (!key.getParameters().isEmpty()) {
                key = new MediaType(key.getType(), key.getSubtype());
            }
            if ((selectedResource = (RuntimeResource)selectedHolder.mtWithoutParamsToResource.get(key)) == null) {
                selectedResource = (RuntimeResource)selectedHolder.mtWithoutParamsToResource.get(MediaType.WILDCARD_TYPE);
            }
        }
        if (selectedResource == null) {
            throw new WebApplicationException(Response.status((int)416).build());
        }
        requestContext.restart(selectedResource);
    }

    public MediaType selectMediaType(ResteasyReactiveRequestContext requestContext, Holder holder) {
        Map.Entry entry;
        MediaType selected = null;
        ServerHttpRequest httpServerRequest = requestContext.serverRequest();
        if (httpServerRequest.containsRequestHeader("Accept") && (entry = holder.serverMediaType.negotiateProduces(requestContext.serverRequest().getRequestHeader("Accept"), null)).getValue() != null) {
            selected = (MediaType)entry.getValue();
        }
        if (selected == null) {
            selected = (MediaType)holder.mtsWithParams.get(0);
        }
        if (selected.equals((Object)MediaType.WILDCARD_TYPE)) {
            return MediaType.APPLICATION_OCTET_STREAM_TYPE;
        }
        return selected;
    }

    private static final class Holder {
        private final Map<MediaType, RuntimeResource> mtWithoutParamsToResource = new HashMap<MediaType, RuntimeResource>();
        private final List<MediaType> mtsWithParams = new ArrayList<MediaType>();
        private ServerMediaType serverMediaType;

        private Holder() {
        }

        public void setResource(RuntimeResource runtimeResource, MediaType mediaType) {
            MediaType withoutParams = mediaType;
            MediaType withParas = mediaType;
            if (!mediaType.getParameters().isEmpty()) {
                withoutParams = new MediaType(mediaType.getType(), mediaType.getSubtype());
            }
            this.mtWithoutParamsToResource.put(withoutParams, runtimeResource);
            this.mtsWithParams.add(withParas);
        }

        public void setupServerMediaType() {
            this.serverMediaType = new ServerMediaType(this.mtsWithParams, StandardCharsets.UTF_8.name(), true, false);
        }
    }
}

