/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.reactive.server.core;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.lang.reflect.Type;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.function.Consumer;
import java.util.function.Function;
import javax.ws.rs.RuntimeType;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.Variant;
import javax.ws.rs.ext.MessageBodyReader;
import javax.ws.rs.ext.MessageBodyWriter;
import javax.ws.rs.ext.WriterInterceptor;
import org.jboss.resteasy.reactive.common.core.Serialisers;
import org.jboss.resteasy.reactive.common.headers.HeaderUtil;
import org.jboss.resteasy.reactive.common.jaxrs.ConfigurationImpl;
import org.jboss.resteasy.reactive.common.model.ResourceReader;
import org.jboss.resteasy.reactive.common.model.ResourceWriter;
import org.jboss.resteasy.reactive.common.util.MediaTypeHelper;
import org.jboss.resteasy.reactive.common.util.QuarkusMultivaluedHashMap;
import org.jboss.resteasy.reactive.common.util.QuarkusMultivaluedMap;
import org.jboss.resteasy.reactive.server.core.EncodedMediaType;
import org.jboss.resteasy.reactive.server.core.ResteasyReactiveRequestContext;
import org.jboss.resteasy.reactive.server.core.serialization.EntityWriter;
import org.jboss.resteasy.reactive.server.core.serialization.FixedEntityWriterArray;
import org.jboss.resteasy.reactive.server.jaxrs.WriterInterceptorContextImpl;
import org.jboss.resteasy.reactive.server.mapping.RuntimeResource;
import org.jboss.resteasy.reactive.server.providers.serialisers.ServerBooleanMessageBodyHandler;
import org.jboss.resteasy.reactive.server.providers.serialisers.ServerByteArrayMessageBodyHandler;
import org.jboss.resteasy.reactive.server.providers.serialisers.ServerCharArrayMessageBodyHandler;
import org.jboss.resteasy.reactive.server.providers.serialisers.ServerCharacterMessageBodyHandler;
import org.jboss.resteasy.reactive.server.providers.serialisers.ServerDefaultTextPlainBodyHandler;
import org.jboss.resteasy.reactive.server.providers.serialisers.ServerFileBodyHandler;
import org.jboss.resteasy.reactive.server.providers.serialisers.ServerFormUrlEncodedProvider;
import org.jboss.resteasy.reactive.server.providers.serialisers.ServerInputStreamMessageBodyHandler;
import org.jboss.resteasy.reactive.server.providers.serialisers.ServerNumberMessageBodyHandler;
import org.jboss.resteasy.reactive.server.providers.serialisers.ServerReaderBodyHandler;
import org.jboss.resteasy.reactive.server.providers.serialisers.ServerStringMessageBodyHandler;
import org.jboss.resteasy.reactive.server.spi.ServerHttpRequest;
import org.jboss.resteasy.reactive.server.spi.ServerHttpResponse;
import org.jboss.resteasy.reactive.server.spi.ServerMessageBodyWriter;

public class ServerSerialisers
extends Serialisers {
    private static final Consumer<ResteasyReactiveRequestContext> HEADER_FUNCTION = new Consumer<ResteasyReactiveRequestContext>(){

        @Override
        public void accept(ResteasyReactiveRequestContext context) {
            ServerSerialisers.encodeResponseHeaders(context);
        }
    };
    public static Serialisers.BuiltinReader[] BUILTIN_READERS = new Serialisers.BuiltinReader[]{new Serialisers.BuiltinReader(String.class, ServerStringMessageBodyHandler.class, "*/*"), new Serialisers.BuiltinReader(Boolean.class, ServerBooleanMessageBodyHandler.class, "text/plain"), new Serialisers.BuiltinReader(Character.class, ServerCharacterMessageBodyHandler.class, "text/plain"), new Serialisers.BuiltinReader(Number.class, ServerNumberMessageBodyHandler.class, "text/plain"), new Serialisers.BuiltinReader(InputStream.class, ServerInputStreamMessageBodyHandler.class, "*/*"), new Serialisers.BuiltinReader(Reader.class, ServerReaderBodyHandler.class, "*/*"), new Serialisers.BuiltinReader(File.class, ServerFileBodyHandler.class, "*/*"), new Serialisers.BuiltinReader(byte[].class, ServerByteArrayMessageBodyHandler.class, "*/*"), new Serialisers.BuiltinReader(Object.class, ServerDefaultTextPlainBodyHandler.class, "text/plain", RuntimeType.SERVER)};
    public static Serialisers.BuiltinWriter[] BUILTIN_WRITERS = new Serialisers.BuiltinWriter[]{new Serialisers.BuiltinWriter(String.class, ServerStringMessageBodyHandler.class, "text/plain"), new Serialisers.BuiltinWriter(Number.class, ServerStringMessageBodyHandler.class, "text/plain"), new Serialisers.BuiltinWriter(Boolean.class, ServerStringMessageBodyHandler.class, "text/plain"), new Serialisers.BuiltinWriter(Character.class, ServerStringMessageBodyHandler.class, "text/plain"), new Serialisers.BuiltinWriter(Object.class, ServerStringMessageBodyHandler.class, "*/*"), new Serialisers.BuiltinWriter(char[].class, ServerCharArrayMessageBodyHandler.class, "text/plain"), new Serialisers.BuiltinWriter(byte[].class, ServerByteArrayMessageBodyHandler.class, "*/*"), new Serialisers.BuiltinWriter(MultivaluedMap.class, ServerFormUrlEncodedProvider.class, "application/x-www-form-urlencoded"), new Serialisers.BuiltinWriter(InputStream.class, ServerInputStreamMessageBodyHandler.class, "*/*"), new Serialisers.BuiltinWriter(Reader.class, ServerReaderBodyHandler.class, "*/*"), new Serialisers.BuiltinWriter(File.class, ServerFileBodyHandler.class, "*/*")};
    private static final String CONTENT_TYPE = "Content-Type";
    public static final MessageBodyWriter<?>[] NO_WRITER;
    public static final MessageBodyReader<?>[] NO_READER;
    private final ConcurrentMap<Class<?>, List<ResourceWriter>> noMediaTypeClassCache = new ConcurrentHashMap();
    private final Function<Class<?>, List<ResourceWriter>> mappingFunction = new Function<Class<?>, List<ResourceWriter>>(){

        @Override
        public List<ResourceWriter> apply(Class<?> aClass) {
            ArrayList<ResourceWriter> writers = new ArrayList<ResourceWriter>();
            HashSet<Class> seenInterfaces = new HashSet<Class>();
            for (Class<?> c = aClass; c != null; c = c.getSuperclass()) {
                List forClass = (ArrayList)ServerSerialisers.this.getWriters().get(c);
                if (forClass != null) {
                    forClass = new ArrayList(forClass);
                    forClass.sort(new ResourceWriter.ResourceWriterComparator());
                    writers.addAll(forClass);
                }
                ArrayDeque interfaces = new ArrayDeque(Arrays.asList(c.getInterfaces()));
                while (!interfaces.isEmpty()) {
                    Class iface = (Class)interfaces.poll();
                    if (seenInterfaces.contains(iface)) continue;
                    seenInterfaces.add(iface);
                    forClass = (List)ServerSerialisers.this.getWriters().get((Object)iface);
                    if (forClass != null) {
                        forClass = new ArrayList(forClass);
                        forClass.sort(new ResourceWriter.ResourceWriterComparator());
                        writers.addAll(forClass);
                    }
                    interfaces.addAll(Arrays.asList(iface.getInterfaces()));
                }
            }
            return writers;
        }
    };

    public static boolean invokeWriter(ResteasyReactiveRequestContext context, Object entity, MessageBodyWriter writer, ServerSerialisers serialisers) throws IOException {
        return ServerSerialisers.invokeWriter(context, entity, writer, serialisers, null);
    }

    public static boolean invokeWriter(ResteasyReactiveRequestContext context, Object entity, MessageBodyWriter writer, ServerSerialisers serialisers, MediaType mediaType) throws IOException {
        WriterInterceptor[] writerInterceptors = context.getWriterInterceptors();
        boolean outputStreamSet = context.getOutputStream() != null;
        context.serverResponse().setPreCommitListener(HEADER_FUNCTION);
        try {
            if (writer instanceof ServerMessageBodyWriter && writerInterceptors == null && !outputStreamSet) {
                ServerMessageBodyWriter quarkusRestWriter = (ServerMessageBodyWriter)writer;
                RuntimeResource target = context.getTarget();
                Type genericType = context.hasGenericReturnType() ? context.getGenericReturnType() : (target == null ? null : target.getReturnType());
                Class<?> entityClass = entity.getClass();
                if (quarkusRestWriter.isWriteable(entityClass, genericType, target == null ? null : target.getLazyMethod(), context.getResponseMediaType())) {
                    if (mediaType != null) {
                        context.setResponseContentType(mediaType);
                    }
                    quarkusRestWriter.writeResponse(entity, genericType, context);
                    return true;
                }
                return false;
            }
            if (writer.isWriteable(entity.getClass(), context.getGenericReturnType(), context.getAllAnnotations(), context.getResponseMediaType())) {
                Response response = context.getResponse().get();
                if (mediaType != null) {
                    context.setResponseContentType(mediaType);
                }
                if (writerInterceptors == null) {
                    writer.writeTo(entity, entity.getClass(), context.getGenericReturnType(), context.getAllAnnotations(), response.getMediaType(), response.getHeaders(), context.getOrCreateOutputStream());
                    context.getOrCreateOutputStream().close();
                } else {
                    ServerSerialisers.runWriterInterceptors(context, entity, writer, response, writerInterceptors, serialisers);
                }
                return true;
            }
            return false;
        }
        catch (Throwable e) {
            context.serverResponse().setPreCommitListener(null);
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            if (e instanceof IOException) {
                throw (IOException)e;
            }
            throw new RuntimeException(e);
        }
    }

    public static void runWriterInterceptors(ResteasyReactiveRequestContext context, Object entity, MessageBodyWriter writer, Response response, WriterInterceptor[] writerInterceptor, ServerSerialisers serialisers) throws IOException {
        WriterInterceptorContextImpl wc = new WriterInterceptorContextImpl(context, writerInterceptor, writer, context.getAllAnnotations(), entity.getClass(), context.getGenericReturnType(), entity, response.getMediaType(), (MultivaluedMap<String, Object>)response.getHeaders(), serialisers);
        wc.proceed();
    }

    public MultivaluedMap<Class<?>, ResourceWriter> getWriters() {
        return this.writers;
    }

    public MultivaluedMap<Class<?>, ResourceReader> getReaders() {
        return this.readers;
    }

    public BestMatchingServerWriterResult findBestMatchingServerWriter(ConfigurationImpl configuration, Class<?> entityType, ServerHttpRequest request) {
        QuarkusMultivaluedMap writers;
        Class<?> klass = entityType;
        LinkedList toProcess = new LinkedList();
        if (configuration != null && !configuration.getResourceWriters().isEmpty()) {
            writers = new QuarkusMultivaluedHashMap();
            writers.putAll((Map)this.writers);
            writers.addAll(configuration.getResourceWriters());
        } else {
            writers = this.writers;
        }
        BestMatchingServerWriterResult result = new BestMatchingServerWriterResult();
        do {
            if (klass == Object.class) {
                HashSet seen = new HashSet(toProcess);
                while (!toProcess.isEmpty()) {
                    Class iface = (Class)toProcess.poll();
                    List matchingWritersByType = (List)writers.get((Object)iface);
                    this.serverResourceWriterLookup(request, matchingWritersByType, result);
                    for (Class<?> i : iface.getInterfaces()) {
                        if (seen.contains(i)) continue;
                        seen.add(i);
                        toProcess.add(i);
                    }
                }
            }
            List matchingWritersByType = (List)writers.get(klass);
            this.serverResourceWriterLookup(request, matchingWritersByType, result);
            toProcess.addAll(Arrays.asList(klass.getInterfaces()));
        } while ((klass = klass.getSuperclass()) != null);
        return result;
    }

    private void serverResourceWriterLookup(ServerHttpRequest request, List<ResourceWriter> candidates, BestMatchingServerWriterResult result) {
        if (candidates == null) {
            return;
        }
        Map.Entry selectedMediaTypes = null;
        ArrayList<ResourceWriter> selectedResourceWriters = null;
        for (ResourceWriter resourceWriter : candidates) {
            Map.Entry current;
            if (!resourceWriter.matchesRuntimeType(RuntimeType.SERVER) || (current = resourceWriter.serverMediaType().negotiateProduces(request.getRequestHeader("Accept"), null)).getValue() == null) continue;
            if (selectedMediaTypes == null) {
                selectedMediaTypes = current;
                selectedResourceWriters = new ArrayList<ResourceWriter>(1);
                selectedResourceWriters.add(resourceWriter);
                continue;
            }
            int compare = MediaTypeHelper.COMPARATOR.compare((MediaType)current.getValue(), (MediaType)selectedMediaTypes.getValue());
            if (compare == 0) {
                selectedResourceWriters.add(resourceWriter);
                continue;
            }
            if (compare >= 0) continue;
            selectedMediaTypes = current;
            selectedResourceWriters = new ArrayList(1);
            selectedResourceWriters.add(resourceWriter);
        }
        if (selectedMediaTypes != null) {
            for (ResourceWriter selectedResourceWriter : selectedResourceWriters) {
                result.add(selectedResourceWriter.instance(), (MediaType)selectedMediaTypes.getKey());
            }
        }
    }

    public NoMediaTypeResult findWriterNoMediaType(ResteasyReactiveRequestContext requestContext, Object entity, ServerSerialisers serialisers, RuntimeType runtimeType) {
        ResourceWriter writer;
        List<ResourceWriter> resultForClass = this.noMediaTypeClassCache.computeIfAbsent(entity.getClass(), this.mappingFunction);
        ArrayList<ResourceWriter> constrainedResultsForClass = new ArrayList<ResourceWriter>(resultForClass.size());
        for (ResourceWriter resourceWriter : resultForClass) {
            if (!resourceWriter.matchesRuntimeType(runtimeType)) continue;
            constrainedResultsForClass.add(resourceWriter);
        }
        MediaType selected = null;
        Iterator iterator = constrainedResultsForClass.iterator();
        while (iterator.hasNext() && (selected = (MediaType)(writer = (ResourceWriter)iterator.next()).serverMediaType().negotiateProduces(requestContext.serverRequest().getRequestHeader("Accept")).getKey()) == null) {
        }
        if (selected == null) {
            HashSet hashSet = new HashSet();
            for (ResourceWriter resourceWriter : constrainedResultsForClass) {
                hashSet.addAll(resourceWriter.mediaTypes());
            }
            throw new WebApplicationException(Response.notAcceptable((List)Variant.mediaTypes((MediaType[])hashSet.toArray(new MediaType[0])).build()).build());
        }
        if (selected.isWildcardType() || selected.getType().equals("application") && selected.isWildcardSubtype()) {
            selected = MediaType.APPLICATION_OCTET_STREAM_TYPE;
        }
        ArrayList<MessageBodyWriter> arrayList = new ArrayList<MessageBodyWriter>(constrainedResultsForClass.size());
        block3: for (ResourceWriter resourceWriter : constrainedResultsForClass) {
            if (resourceWriter.mediaTypes().isEmpty()) {
                arrayList.add(resourceWriter.instance());
                continue;
            }
            for (MediaType mt : resourceWriter.mediaTypes()) {
                if (!mt.isCompatible(selected)) continue;
                arrayList.add(resourceWriter.instance());
                continue block3;
            }
        }
        return new NoMediaTypeResult(arrayList.toArray(NO_WRITER), selected, serialisers);
    }

    public Serialisers.BuiltinWriter[] getBultinWriters() {
        return BUILTIN_WRITERS;
    }

    public Serialisers.BuiltinReader[] getBultinReaders() {
        return BUILTIN_READERS;
    }

    public static void encodeResponseHeaders(ResteasyReactiveRequestContext requestContext) {
        ServerHttpResponse vertxResponse = requestContext.serverResponse();
        if (!requestContext.getResponse().isCreated()) {
            EncodedMediaType contentType;
            if (requestContext.getResponseEntity() == null) {
                vertxResponse.setStatusCode(Response.Status.NO_CONTENT.getStatusCode());
            }
            if ((contentType = requestContext.getResponseContentType()) != null) {
                vertxResponse.setResponseHeader((CharSequence)CONTENT_TYPE, contentType.toString());
            }
            return;
        }
        Response response = requestContext.getResponse().get();
        vertxResponse.setStatusCode(response.getStatus());
        MultivaluedMap headers = response.getHeaders();
        for (Map.Entry entry : headers.entrySet()) {
            if (((List)entry.getValue()).size() == 1) {
                Object o = ((List)entry.getValue()).get(0);
                if (o instanceof CharSequence) {
                    vertxResponse.setResponseHeader((CharSequence)entry.getKey(), (CharSequence)o);
                    continue;
                }
                vertxResponse.setResponseHeader((CharSequence)entry.getKey(), HeaderUtil.headerToString(o));
                continue;
            }
            ArrayList<CharSequence> strValues = new ArrayList<CharSequence>(((List)entry.getValue()).size());
            for (Object o : (List)entry.getValue()) {
                strValues.add(HeaderUtil.headerToString(o));
            }
            vertxResponse.setResponseHeader((CharSequence)entry.getKey(), strValues);
        }
    }

    static {
        primitivesToWrappers.put(Boolean.TYPE, Boolean.class);
        primitivesToWrappers.put(Character.TYPE, Character.class);
        primitivesToWrappers.put(Byte.TYPE, Byte.class);
        primitivesToWrappers.put(Short.TYPE, Short.class);
        primitivesToWrappers.put(Integer.TYPE, Integer.class);
        primitivesToWrappers.put(Long.TYPE, Long.class);
        primitivesToWrappers.put(Float.TYPE, Float.class);
        primitivesToWrappers.put(Double.TYPE, Double.class);
        NO_WRITER = new MessageBodyWriter[0];
        NO_READER = new MessageBodyReader[0];
    }

    public static class BestMatchingServerWriterResult {
        final List<Entry> entries = new ArrayList<Entry>();

        void add(MessageBodyWriter<?> writer, MediaType mediaType) {
            this.entries.add(new Entry(writer, mediaType));
        }

        public boolean isEmpty() {
            return this.entries.isEmpty();
        }

        public List<MessageBodyWriter<?>> getMessageBodyWriters() {
            if (this.isEmpty()) {
                return Collections.emptyList();
            }
            ArrayList result = new ArrayList(this.entries.size());
            for (Entry entry : this.entries) {
                result.add(entry.writer);
            }
            return result;
        }

        public MediaType getSelectedMediaType() {
            if (this.isEmpty()) {
                return null;
            }
            return this.entries.get((int)0).mediaType;
        }

        private static class Entry {
            final MessageBodyWriter<?> writer;
            final MediaType mediaType;

            public Entry(MessageBodyWriter<?> writer, MediaType mediaType) {
                this.writer = writer;
                this.mediaType = mediaType;
            }
        }
    }

    public static class NoMediaTypeResult {
        final MessageBodyWriter<?>[] writers;
        final MediaType mediaType;
        final EntityWriter entityWriter;

        public NoMediaTypeResult(MessageBodyWriter<?>[] writers, MediaType mediaType, ServerSerialisers serialisers) {
            this.writers = writers;
            this.mediaType = mediaType;
            this.entityWriter = new FixedEntityWriterArray(writers, serialisers);
        }

        public MessageBodyWriter<?>[] getWriters() {
            return this.writers;
        }

        public MediaType getMediaType() {
            return this.mediaType;
        }

        public EntityWriter getEntityWriter() {
            return this.entityWriter;
        }
    }
}

