/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.reactive.server.handlers;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import org.jboss.resteasy.reactive.server.core.ResteasyReactiveRequestContext;
import org.jboss.resteasy.reactive.server.spi.ServerHttpRequest;
import org.jboss.resteasy.reactive.server.spi.ServerRestHandler;

public class ReadBodyHandler
implements ServerRestHandler {
    private static final byte[] NO_BYTES = new byte[0];
    private boolean alsoSetInputStream;

    public ReadBodyHandler(boolean alsoSetInputStream) {
        this.alsoSetInputStream = alsoSetInputStream;
    }

    @Override
    public void handle(final ResteasyReactiveRequestContext requestContext) throws Exception {
        if (requestContext.hasInputStream()) {
            return;
        }
        ServerHttpRequest vertxRequest = requestContext.serverRequest();
        if (vertxRequest.isRequestEnded()) {
            if (this.alsoSetInputStream) {
                requestContext.setInputStream(new ByteArrayInputStream(NO_BYTES));
            }
        } else {
            vertxRequest.setExpectMultipart(true);
            requestContext.suspend();
            final ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
            vertxRequest.setReadListener(new ServerHttpRequest.ReadCallback(){

                @Override
                public void done() {
                    requestContext.setInputStream(new ByteArrayInputStream(outputStream.toByteArray()));
                    requestContext.resume();
                }

                @Override
                public void data(ByteBuffer data) {
                    byte[] buf = new byte[data.remaining()];
                    data.get(buf);
                    try {
                        outputStream.write(buf);
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
            });
        }
    }
}

