/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.reactive.server.core.startup;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import org.jboss.resteasy.reactive.common.model.ResourceMethod;
import org.jboss.resteasy.reactive.server.handlers.MediaTypeMapper;
import org.jboss.resteasy.reactive.server.mapping.RequestMapper;
import org.jboss.resteasy.reactive.server.mapping.RuntimeResource;
import org.jboss.resteasy.reactive.server.mapping.URITemplate;
import org.jboss.resteasy.reactive.server.spi.ServerRestHandler;

public class RuntimeMappingDeployment {
    public static Map<String, RequestMapper<RuntimeResource>> buildClassMapper(Map<String, TreeMap<URITemplate, List<RequestMapper.RequestPath<RuntimeResource>>>> perClassMappers) {
        HashMap<String, RequestMapper<RuntimeResource>> mappersByMethod = new HashMap<String, RequestMapper<RuntimeResource>>();
        SortedMap nullMethod = perClassMappers.get(null);
        if (nullMethod == null) {
            nullMethod = Collections.emptySortedMap();
        }
        for (Map.Entry<String, TreeMap<URITemplate, List<RequestMapper.RequestPath<RuntimeResource>>>> i : perClassMappers.entrySet()) {
            for (Map.Entry nm : nullMethod.entrySet()) {
                TreeMap<URITemplate, List<RequestMapper.RequestPath<RuntimeResource>>> templateMap = i.getValue();
                if (templateMap.containsKey(nm.getKey())) continue;
                templateMap.put((URITemplate)nm.getKey(), (List<RequestMapper.RequestPath<RuntimeResource>>)nm.getValue());
            }
            ArrayList result = new ArrayList();
            for (Map.Entry<URITemplate, List<RequestMapper.RequestPath<RuntimeResource>>> entry : i.getValue().entrySet()) {
                List<RequestMapper.RequestPath<RuntimeResource>> requestPaths = entry.getValue();
                if (requestPaths.size() == 1) {
                    result.addAll(requestPaths);
                    continue;
                }
                ArrayList<RuntimeResource> resources = new ArrayList<RuntimeResource>(requestPaths.size());
                for (int j = 0; j < requestPaths.size(); ++j) {
                    resources.add((RuntimeResource)requestPaths.get((int)j).value);
                }
                MediaTypeMapper mapper = new MediaTypeMapper(resources);
                RuntimeResource fake = new RuntimeResource(i.getKey(), entry.getKey(), null, null, Collections.emptyList(), null, null, new ServerRestHandler[]{mapper}, null, new Class[0], null, false, null, null, null, null, null, Collections.emptyMap());
                result.add(new RequestMapper.RequestPath<RuntimeResource>(false, fake.getPath(), fake));
            }
            mappersByMethod.put(i.getKey(), new RequestMapper(result));
        }
        return mappersByMethod;
    }

    public static void buildMethodMapper(Map<String, TreeMap<URITemplate, List<RequestMapper.RequestPath<RuntimeResource>>>> perClassMappers, ResourceMethod method, RuntimeResource runtimeResource) {
        List<RequestMapper.RequestPath<RuntimeResource>> list;
        TreeMap<URITemplate, List<RequestMapper.RequestPath<RuntimeResource>>> templateMap = perClassMappers.get(method.getHttpMethod());
        if (templateMap == null) {
            templateMap = new TreeMap();
            perClassMappers.put(method.getHttpMethod(), templateMap);
        }
        if ((list = templateMap.get(runtimeResource.getPath())) == null) {
            list = new ArrayList<RequestMapper.RequestPath<RuntimeResource>>();
            templateMap.put(runtimeResource.getPath(), list);
        }
        list.add(new RequestMapper.RequestPath<RuntimeResource>(method.getHttpMethod() == null, runtimeResource.getPath(), runtimeResource));
    }
}

